/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;

public final class EDecimal
extends AExpression {
    private final String value;

    public EDecimal(Location location, String value) {
        super(location);
        this.value = Objects.requireNonNull(value);
    }

    @Override
    void extractVariables(Set<String> variables) {
    }

    @Override
    void analyze(Locals locals) {
        if (!this.read) {
            throw this.createError(new IllegalArgumentException("Must read from constant [" + this.value + "]."));
        }
        if (this.value.endsWith("f") || this.value.endsWith("F")) {
            try {
                this.constant = Float.valueOf(Float.parseFloat(this.value.substring(0, this.value.length() - 1)));
                this.actual = Definition.FLOAT_TYPE;
            }
            catch (NumberFormatException exception) {
                throw this.createError(new IllegalArgumentException("Invalid float constant [" + this.value + "]."));
            }
        }
        try {
            this.constant = Double.parseDouble(this.value);
            this.actual = Definition.DOUBLE_TYPE;
        }
        catch (NumberFormatException exception) {
            throw this.createError(new IllegalArgumentException("Invalid double constant [" + this.value + "]."));
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }
}

