/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class UpdateResponse
extends DocWriteResponse {
    private GetResult getResult;

    public UpdateResponse() {
    }

    public UpdateResponse(ShardId shardId, String type, String id, long version, DocWriteResponse.Result result) {
        this(new ReplicationResponse.ShardInfo(0, 0, new ReplicationResponse.ShardInfo.Failure[0]), shardId, type, id, version, result);
    }

    public UpdateResponse(ReplicationResponse.ShardInfo shardInfo, ShardId shardId, String type, String id, long version, DocWriteResponse.Result result) {
        super(shardId, type, id, version, result);
        this.setShardInfo(shardInfo);
    }

    public void setGetResult(GetResult getResult) {
        this.getResult = getResult;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.getResult = GetResult.readGetResult(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.toXContent(builder, params);
        if (this.getGetResult() != null) {
            builder.startObject("get");
            this.getGetResult().toXContentEmbedded(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UpdateResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",type=").append(this.getType());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",shards=").append(this.getShardInfo());
        return builder.append("]").toString();
    }

    static final class Fields {
        static final String GET = "get";

        Fields() {
        }
    }
}

