/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.monitor.jvm.JvmInfo;

final class JVMCheck {
    static final String JVM_RECOMMENDATIONS = "http://www.elastic.co/guide/en/elasticsearch/reference/current/_installation.html";
    static final String JVM_BYPASS = "es.bypass.vm.check";
    static final Map<String, HotSpotCheck> JVM_BROKEN_HOTSPOT_VERSIONS;

    private JVMCheck() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void check() {
        if (Boolean.parseBoolean(System.getProperty(JVM_BYPASS))) {
            Loggers.getLogger(JVMCheck.class).warn("bypassing jvm version check for version [{}], this can result in data corruption!", (Object)JVMCheck.fullVersion());
            return;
        }
        if ("Oracle Corporation".equals(Constants.JVM_VENDOR)) {
            HotSpotCheck bug = JVM_BROKEN_HOTSPOT_VERSIONS.get(Constants.JVM_VERSION);
            if (bug == null || !bug.check()) return;
            if (!bug.getWorkaround().isPresent() || !ManagementFactory.getRuntimeMXBean().getInputArguments().contains(bug.getWorkaround().get())) throw new RuntimeException(bug.getErrorMessage());
            Loggers.getLogger(JVMCheck.class).warn("{}", (Object)bug.getWarningMessage().get());
            return;
        }
        if (!"IBM Corporation".equals(Constants.JVM_VENDOR)) return;
        float version = Float.POSITIVE_INFINITY;
        try {
            version = Float.parseFloat(Constants.JVM_VERSION);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!(version < 2.8f)) return;
        StringBuilder sb = new StringBuilder();
        sb.append("IBM J9 runtimes < 2.8 suffer from several bugs which can cause data corruption.");
        sb.append(System.lineSeparator());
        sb.append("Your version: " + JVMCheck.fullVersion());
        sb.append(System.lineSeparator());
        sb.append("Please upgrade the JVM to a recent IBM JDK");
        throw new RuntimeException(sb.toString());
    }

    static String fullVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append(Constants.JAVA_VENDOR);
        sb.append(" ");
        sb.append(Constants.JAVA_VERSION);
        sb.append(" [");
        sb.append(Constants.JVM_NAME);
        sb.append(" ");
        sb.append(Constants.JVM_VERSION);
        sb.append("]");
        return sb.toString();
    }

    static {
        HashMap<String, HotSpotCheck> bugs = new HashMap<String, HotSpotCheck>();
        bugs.put("21.0-b17", new HotspotBug("https://bugs.openjdk.java.net/browse/JDK-7070134", "-XX:-UseLoopPredicate"));
        bugs.put("24.0-b56", new HotspotBug("https://bugs.openjdk.java.net/browse/JDK-8024830", "-XX:-UseSuperWord"));
        bugs.put("24.45-b08", new HotspotBug("https://bugs.openjdk.java.net/browse/JDK-8024830", "-XX:-UseSuperWord"));
        bugs.put("24.51-b03", new HotspotBug("https://bugs.openjdk.java.net/browse/JDK-8024830", "-XX:-UseSuperWord"));
        G1GCCheck g1GcCheck = new G1GCCheck();
        bugs.put("25.0-b70", g1GcCheck);
        bugs.put("25.11-b03", g1GcCheck);
        bugs.put("25.20-b23", g1GcCheck);
        bugs.put("25.25-b02", g1GcCheck);
        bugs.put("25.31-b07", g1GcCheck);
        JVM_BROKEN_HOTSPOT_VERSIONS = Collections.unmodifiableMap(bugs);
    }

    static class G1GCCheck
    implements HotSpotCheck {
        G1GCCheck() {
        }

        @Override
        public boolean check() {
            return JvmInfo.jvmInfo().useG1GC().equals("true");
        }

        @Override
        public String getErrorMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Java version: ").append(JVMCheck.fullVersion());
            sb.append(" can cause data corruption");
            sb.append(" when used with G1GC.");
            sb.append(System.lineSeparator());
            sb.append("Please upgrade the JVM, see ").append(JVMCheck.JVM_RECOMMENDATIONS);
            sb.append(" for current recommendations.");
            return sb.toString();
        }

        @Override
        public Optional<String> getWarningMessage() {
            return Optional.empty();
        }

        @Override
        public Optional<String> getWorkaround() {
            return Optional.empty();
        }
    }

    static class HotspotBug
    implements HotSpotCheck {
        final String bugUrl;
        final String workAround;

        HotspotBug(String bugUrl, String workAround) {
            this.bugUrl = bugUrl;
            this.workAround = workAround;
        }

        @Override
        public String getErrorMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Java version: ").append(JVMCheck.fullVersion());
            sb.append(" suffers from critical bug ").append(this.bugUrl);
            sb.append(" which can cause data corruption.");
            sb.append(System.lineSeparator());
            sb.append("Please upgrade the JVM, see ").append(JVMCheck.JVM_RECOMMENDATIONS);
            sb.append(" for current recommendations.");
            if (this.workAround != null) {
                sb.append(System.lineSeparator());
                sb.append("If you absolutely cannot upgrade, please add ").append(this.workAround);
                sb.append(" to the ES_JAVA_OPTS environment variable.");
                sb.append(System.lineSeparator());
                sb.append("Upgrading is preferred, this workaround will result in degraded performance.");
            }
            return sb.toString();
        }

        @Override
        public Optional<String> getWarningMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("Workaround flag ").append(this.workAround);
            sb.append(" for bug ").append(this.bugUrl);
            sb.append(" found. ");
            sb.append(System.lineSeparator());
            sb.append("This will result in degraded performance!");
            sb.append(System.lineSeparator());
            sb.append("Upgrading is preferred, see ").append(JVMCheck.JVM_RECOMMENDATIONS);
            sb.append(" for current recommendations.");
            return Optional.of(sb.toString());
        }

        @Override
        public boolean check() {
            return true;
        }

        @Override
        public Optional<String> getWorkaround() {
            return Optional.of(this.workAround);
        }
    }

    static interface HotSpotCheck {
        public boolean check();

        public String getErrorMessage();

        public Optional<String> getWarningMessage();

        public Optional<String> getWorkaround();
    }
}

