/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.ObjectLongMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;

public abstract class ReplicaShardAllocator
extends AbstractComponent {
    public ReplicaShardAllocator(Settings settings) {
        super(settings);
    }

    public void processExistingRecoveries(RoutingAllocation allocation) {
        MetaData metaData = allocation.metaData();
        RoutingNodes routingNodes = allocation.routingNodes();
        ArrayList<Runnable> shardCancellationActions = new ArrayList<Runnable>();
        for (RoutingNode routingNode : routingNodes) {
            for (ShardRouting shard : routingNode) {
                if (shard.primary() || !shard.initializing() || shard.relocatingNodeId() != null || shard.unassignedInfo() != null && shard.unassignedInfo().getReason() == UnassignedInfo.Reason.INDEX_CREATED) continue;
                AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> shardStores = this.fetchData(shard, allocation);
                if (!shardStores.hasData()) {
                    this.logger.trace("{}: fetching new stores for initializing shard", (Object)shard);
                    continue;
                }
                ShardRouting primaryShard = allocation.routingNodes().activePrimary(shard.shardId());
                assert (primaryShard != null) : "the replica shard can be allocated on at least one node, so there must be an active primary";
                TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore = this.findStore(primaryShard, allocation, shardStores);
                if (primaryStore == null) {
                    this.logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", (Object)shard);
                    continue;
                }
                MatchingNodes matchingNodes = this.findMatchingNodes(shard, allocation, primaryStore, shardStores);
                if (matchingNodes.getNodeWithHighestMatch() == null) continue;
                DiscoveryNode currentNode = allocation.nodes().get(shard.currentNodeId());
                DiscoveryNode nodeWithHighestMatch = matchingNodes.getNodeWithHighestMatch();
                String currentSyncId = shardStores.getData().containsKey(currentNode) ? shardStores.getData().get(currentNode).storeFilesMetaData().syncId() : null;
                if (currentNode.equals(nodeWithHighestMatch) || Objects.equals(currentSyncId, primaryStore.syncId()) || !matchingNodes.isNodeMatchBySyncID(nodeWithHighestMatch)) continue;
                this.logger.debug("cancelling allocation of replica on [{}], sync id match found on node [{}]", (Object)currentNode, (Object)nodeWithHighestMatch);
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.REALLOCATED_REPLICA, "existing allocation of replica to [" + currentNode + "] cancelled, sync id match found on node [" + nodeWithHighestMatch + "]", null, 0, allocation.getCurrentNanoTime(), System.currentTimeMillis(), false, UnassignedInfo.AllocationStatus.NO_ATTEMPT);
                shardCancellationActions.add(() -> routingNodes.failShard(this.logger, shard, unassignedInfo, metaData.getIndexSafe(shard.index()), allocation.changes()));
            }
        }
        for (Runnable action : shardCancellationActions) {
            action.run();
        }
    }

    public void allocateUnassigned(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            ShardRouting shard = unassignedIterator.next();
            if (shard.primary() || shard.unassignedInfo().getReason() == UnassignedInfo.Reason.INDEX_CREATED) continue;
            Decision decision = this.canBeAllocatedToAtLeastOneNode(shard, allocation);
            if (decision.type() != Decision.Type.YES) {
                this.logger.trace("{}: ignoring allocation, can't be allocated on any node", (Object)shard);
                unassignedIterator.removeAndIgnore(UnassignedInfo.AllocationStatus.fromDecision(decision), allocation.changes());
                continue;
            }
            AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> shardStores = this.fetchData(shard, allocation);
            if (!shardStores.hasData()) {
                this.logger.trace("{}: ignoring allocation, still fetching shard stores", (Object)shard);
                allocation.setHasPendingAsyncFetch();
                unassignedIterator.removeAndIgnore(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, allocation.changes());
                continue;
            }
            ShardRouting primaryShard = routingNodes.activePrimary(shard.shardId());
            assert (primaryShard != null) : "the replica shard can be allocated on at least one node, so there must be an active primary";
            TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore = this.findStore(primaryShard, allocation, shardStores);
            if (primaryStore == null) {
                this.logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", (Object)shard);
                continue;
            }
            MatchingNodes matchingNodes = this.findMatchingNodes(shard, allocation, primaryStore, shardStores);
            if (matchingNodes.getNodeWithHighestMatch() != null) {
                RoutingNode nodeWithHighestMatch = allocation.routingNodes().node(matchingNodes.getNodeWithHighestMatch().getId());
                decision = allocation.deciders().canAllocate(shard, nodeWithHighestMatch, allocation);
                if (decision.type() == Decision.Type.THROTTLE) {
                    this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent store", (Object)shard.index(), (Object)shard.id(), (Object)shard, (Object)nodeWithHighestMatch.node());
                    unassignedIterator.removeAndIgnore(UnassignedInfo.AllocationStatus.fromDecision(decision), allocation.changes());
                    continue;
                }
                this.logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its unallocated persistent store", (Object)shard.index(), (Object)shard.id(), (Object)shard, (Object)nodeWithHighestMatch.node());
                unassignedIterator.initialize(nodeWithHighestMatch.nodeId(), null, allocation.clusterInfo().getShardSize(shard, -1L), allocation.changes());
                continue;
            }
            if (matchingNodes.hasAnyData()) continue;
            this.ignoreUnassignedIfDelayed(unassignedIterator, shard, allocation.changes());
        }
    }

    public void ignoreUnassignedIfDelayed(RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator, ShardRouting shard, RoutingChangesObserver changes) {
        if (shard.unassignedInfo().isDelayed()) {
            this.logger.debug("{}: allocation of [{}] is delayed", (Object)shard.shardId(), (Object)shard);
            unassignedIterator.removeAndIgnore(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, changes);
        }
    }

    private Decision canBeAllocatedToAtLeastOneNode(ShardRouting shard, RoutingAllocation allocation) {
        Decision madeDecision = Decision.NO;
        for (ObjectCursor cursor : allocation.nodes().getDataNodes().values()) {
            RoutingNode node = allocation.routingNodes().node(((DiscoveryNode)cursor.value).getId());
            if (node == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            if (decision.type() == Decision.Type.YES) {
                return decision;
            }
            if (madeDecision.type() != Decision.Type.NO || decision.type() != Decision.Type.THROTTLE) continue;
            madeDecision = decision;
        }
        return madeDecision;
    }

    private TransportNodesListShardStoreMetaData.StoreFilesMetaData findStore(ShardRouting shard, RoutingAllocation allocation, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> data) {
        assert (shard.currentNodeId() != null);
        DiscoveryNode primaryNode = allocation.nodes().get(shard.currentNodeId());
        if (primaryNode == null) {
            return null;
        }
        TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData primaryNodeFilesStore = data.getData().get(primaryNode);
        if (primaryNodeFilesStore == null) {
            return null;
        }
        return primaryNodeFilesStore.storeFilesMetaData();
    }

    private MatchingNodes findMatchingNodes(ShardRouting shard, RoutingAllocation allocation, TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> data) {
        ObjectLongHashMap nodesToSize = new ObjectLongHashMap();
        for (Map.Entry<DiscoveryNode, TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> nodeStoreEntry : data.getData().entrySet()) {
            Decision decision;
            RoutingNode node;
            DiscoveryNode discoNode = nodeStoreEntry.getKey();
            TransportNodesListShardStoreMetaData.StoreFilesMetaData storeFilesMetaData = nodeStoreEntry.getValue().storeFilesMetaData();
            if (storeFilesMetaData.isEmpty() || (node = allocation.routingNodes().node(discoNode.getId())) == null || (decision = allocation.deciders().canAllocate(shard, node, allocation)).type() == Decision.Type.NO) continue;
            String primarySyncId = primaryStore.syncId();
            String replicaSyncId = storeFilesMetaData.syncId();
            if (replicaSyncId != null && replicaSyncId.equals(primarySyncId)) {
                this.logger.trace("{}: node [{}] has same sync id {} as primary", (Object)shard, (Object)discoNode.getName(), (Object)replicaSyncId);
                nodesToSize.put((Object)discoNode, Long.MAX_VALUE);
                continue;
            }
            long sizeMatched = 0L;
            for (StoreFileMetaData storeFileMetaData : storeFilesMetaData) {
                String metaDataFileName = storeFileMetaData.name();
                if (!primaryStore.fileExists(metaDataFileName) || !primaryStore.file(metaDataFileName).isSame(storeFileMetaData)) continue;
                sizeMatched += storeFileMetaData.length();
            }
            this.logger.trace("{}: node [{}] has [{}/{}] bytes of re-usable data", (Object)shard, (Object)discoNode.getName(), (Object)new ByteSizeValue(sizeMatched), (Object)sizeMatched);
            nodesToSize.put((Object)discoNode, sizeMatched);
        }
        return new MatchingNodes((ObjectLongMap<DiscoveryNode>)nodesToSize);
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> fetchData(ShardRouting var1, RoutingAllocation var2);

    static class MatchingNodes {
        private final ObjectLongMap<DiscoveryNode> nodesToSize;
        private final DiscoveryNode nodeWithHighestMatch;

        public MatchingNodes(ObjectLongMap<DiscoveryNode> nodesToSize) {
            this.nodesToSize = nodesToSize;
            long highestMatchSize = 0L;
            DiscoveryNode highestMatchNode = null;
            for (ObjectLongCursor cursor : nodesToSize) {
                if (cursor.value <= highestMatchSize) continue;
                highestMatchSize = cursor.value;
                highestMatchNode = (DiscoveryNode)cursor.key;
            }
            this.nodeWithHighestMatch = highestMatchNode;
        }

        @Nullable
        public DiscoveryNode getNodeWithHighestMatch() {
            return this.nodeWithHighestMatch;
        }

        public boolean isNodeMatchBySyncID(DiscoveryNode node) {
            return this.nodesToSize.get((Object)node) == Long.MAX_VALUE;
        }

        public boolean hasAnyData() {
            return !this.nodesToSize.isEmpty();
        }
    }
}

