/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.cardinality;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.support.AbstractValuesSourceParser;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class CardinalityParser
extends AbstractValuesSourceParser.AnyValuesSourceParser {
    private static final ParseField REHASH = new ParseField("rehash", new String[0]).withAllDeprecated("no replacement - values will always be rehashed");

    public CardinalityParser() {
        super(true, false);
    }

    protected CardinalityAggregationBuilder createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        CardinalityAggregationBuilder factory = new CardinalityAggregationBuilder(aggregationName, targetValueType);
        Long precisionThreshold = (Long)otherOptions.get(CardinalityAggregationBuilder.PRECISION_THRESHOLD_FIELD);
        if (precisionThreshold != null) {
            factory.precisionThreshold(precisionThreshold);
        }
        return factory;
    }

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParseContext context, Map<ParseField, Object> otherOptions) throws IOException {
        if (token.isValue()) {
            if (context.matchField(currentFieldName, CardinalityAggregationBuilder.PRECISION_THRESHOLD_FIELD)) {
                otherOptions.put(CardinalityAggregationBuilder.PRECISION_THRESHOLD_FIELD, context.getParser().longValue());
                return true;
            }
            if (context.matchField(currentFieldName, REHASH)) {
                return true;
            }
        }
        return false;
    }
}

