/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayDeque;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckerContext;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;
import kotlin.reflect.jvm.internal.impl.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.annotations.NotNull;

public class TypeCheckerContext {
    private int argumentsDepth;
    private boolean supertypesLocked;
    private ArrayDeque<SimpleType> supertypesDeque;
    private Set<SimpleType> supertypesSet;
    private final boolean errorTypeEqualsToAnything;

    protected final int getArgumentsDepth() {
        return this.argumentsDepth;
    }

    protected final void setArgumentsDepth(int n) {
        this.argumentsDepth = n;
    }

    public boolean isSubtypeByExternalRule(@NotNull SimpleType subType, @NotNull SimpleType superType) {
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return false;
    }

    public final <T> T runWithArgumentsSettings(@NotNull UnwrappedType subArgument, @NotNull Function1<? super TypeCheckerContext, ? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)subArgument, (String)"subArgument");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        if (this.argumentsDepth > 100) {
            String string = "Arguments depth is too high. Some related argument: " + subArgument;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        TypeCheckerContext typeCheckerContext = this;
        int n = typeCheckerContext.argumentsDepth;
        typeCheckerContext.argumentsDepth = n + 1;
        Object result = f.invoke((Object)this);
        TypeCheckerContext typeCheckerContext2 = this;
        int n2 = typeCheckerContext2.argumentsDepth;
        typeCheckerContext2.argumentsDepth = n2 + -1;
        return (T)result;
    }

    private final void initialize() {
        boolean bl = !this.supertypesLocked;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque();
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = SmartSet.Companion.create();
        }
    }

    private final void clear() {
        ArrayDeque<SimpleType> arrayDeque = this.supertypesDeque;
        if (arrayDeque == null) {
            Intrinsics.throwNpe();
        }
        arrayDeque.clear();
        Set<SimpleType> set = this.supertypesSet;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        set.clear();
        this.supertypesLocked = false;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean anySupertype$kotlin_core(@NotNull SimpleType start, @NotNull Function1<? super SimpleType, Boolean> predicate, @NotNull Function1<? super SimpleType, ? extends SupertypesPolicy> supertypesPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Intrinsics.checkParameterIsNotNull(supertypesPolicy, (String)"supertypesPolicy");
        this.initialize();
        v0 = this.supertypesDeque;
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        deque = v0;
        v1 = this.supertypesSet;
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        visitedSupertypes = v1;
        deque.push(start);
        block0: while (true) {
            var6_6 = deque;
            if (!(var6_6.isEmpty() == false)) break;
            if (visitedSupertypes.size() > 1000) {
                var6_6 = "Too many supertypes for type: " + start + ". Supertypes = " + CollectionsKt.joinToString$default((Iterable)visitedSupertypes, null, null, null, (int)0, null, null, (int)63, null);
                throw (Throwable)new IllegalStateException(var6_6.toString());
            }
            v2 = current = deque.pop();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"current");
            if (!visitedSupertypes.add(v2)) continue;
            v3 = current;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"current");
            if (((Boolean)predicate.invoke((Object)v3)).booleanValue()) {
                this.clear();
                return true;
            }
            v4 = current;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"current");
            if ((SupertypesPolicy)AddToStdlibKt.check(supertypesPolicy.invoke((Object)v4), anySupertype.policy.1.INSTANCE) == null) {
                continue;
            }
            var8_8 = current.getConstructor().getSupertypes().iterator();
            while (true) {
                if (var8_8.hasNext()) ** break;
                continue block0;
                v5 = supertype = var8_8.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"supertype");
                deque.add(policy.transformType(v5));
            }
            break;
        }
        this.clear();
        return false;
    }

    public final boolean getErrorTypeEqualsToAnything() {
        return this.errorTypeEqualsToAnything;
    }

    public TypeCheckerContext(boolean errorTypeEqualsToAnything) {
        this.errorTypeEqualsToAnything = errorTypeEqualsToAnything;
    }

    public static abstract class SupertypesPolicy {
        @NotNull
        public abstract SimpleType transformType(@NotNull KotlinType var1);

        private SupertypesPolicy() {
        }

        public /* synthetic */ SupertypesPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class None
        extends SupertypesPolicy {
            public static final None INSTANCE;

            @NotNull
            public Void transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                throw (Throwable)new UnsupportedOperationException("Should not be called");
            }

            private None() {
                super(null);
                INSTANCE = this;
            }

            static {
                new None();
            }
        }

        public static final class UpperIfFlexible
        extends SupertypesPolicy {
            public static final UpperIfFlexible INSTANCE;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                return FlexibleTypesKt.upperIfFlexible(type2);
            }

            private UpperIfFlexible() {
                super(null);
                INSTANCE = this;
            }

            static {
                new UpperIfFlexible();
            }
        }

        public static final class LowerIfFlexible
        extends SupertypesPolicy {
            public static final LowerIfFlexible INSTANCE;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                return FlexibleTypesKt.lowerIfFlexible(type2);
            }

            private LowerIfFlexible() {
                super(null);
                INSTANCE = this;
            }

            static {
                new LowerIfFlexible();
            }
        }

        public static final class LowerIfFlexibleWithCustomSubstitutor
        extends SupertypesPolicy {
            @NotNull
            private final TypeSubstitutor substitutor;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                return TypeSubstitutionKt.asSimpleType(this.substitutor.safeSubstitute(FlexibleTypesKt.lowerIfFlexible(type2), Variance.INVARIANT));
            }

            @NotNull
            public final TypeSubstitutor getSubstitutor() {
                return this.substitutor;
            }

            public LowerIfFlexibleWithCustomSubstitutor(@NotNull TypeSubstitutor substitutor) {
                Intrinsics.checkParameterIsNotNull((Object)substitutor, (String)"substitutor");
                super(null);
                this.substitutor = substitutor;
            }
        }
    }
}

