/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectLocalComponentProvider;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.scala.plugins.ScalaLanguagePlugin;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.GenerateIdeaProject;
import org.gradle.plugins.ide.idea.GenerateIdeaWorkspace;
import org.gradle.plugins.ide.idea.internal.IdeaNameDeduper;
import org.gradle.plugins.ide.idea.internal.IdeaScalaConfigurer;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaModuleIml;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.gradle.plugins.ide.idea.model.IdeaWorkspace;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.internal.IdePlugin;

public class IdeaPlugin
extends IdePlugin {
    private final Instantiator instantiator;
    private IdeaModel ideaModel;

    @Inject
    public IdeaPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public IdeaModel getModel() {
        return this.ideaModel;
    }

    @Override
    protected String getLifecycleTaskName() {
        return "idea";
    }

    @Override
    protected void onApply(Project project) {
        this.getLifecycleTask().setDescription("Generates IDEA project files (IML, IPR, IWS)");
        this.getCleanTask().setDescription("Cleans IDEA project files (IML, IPR)");
        this.ideaModel = (IdeaModel)project.getExtensions().create("idea", IdeaModel.class, new Object[0]);
        this.configureIdeaWorkspace(project);
        this.configureIdeaProject(project);
        this.configureIdeaModule(project);
        this.configureForJavaPlugin(project);
        this.configureForScalaPlugin();
        this.postProcess("idea", (Action<? super Gradle>)new Action<Gradle>(){

            public void execute(Gradle gradle) {
                IdeaPlugin.this.performPostEvaluationActions();
            }
        });
    }

    public void performPostEvaluationActions() {
        this.makeSureModuleNamesAreUnique();
        this.registerImlArtifacts();
    }

    private void makeSureModuleNamesAreUnique() {
        new IdeaNameDeduper().configureRoot(this.project.getRootProject());
    }

    private void registerImlArtifacts() {
        Set projectsWithIml = Sets.filter((Set)this.project.getRootProject().getAllprojects(), (Predicate)new Predicate<Project>(){

            public boolean apply(Project project) {
                return project.getPlugins().hasPlugin(IdeaPlugin.class);
            }
        });
        for (Project project : projectsWithIml) {
            ProjectLocalComponentProvider projectComponentProvider = (ProjectLocalComponentProvider)((ProjectInternal)project).getServices().get(ProjectLocalComponentProvider.class);
            ProjectComponentIdentifier projectId = DefaultProjectComponentIdentifier.newProjectId((Project)project);
            projectComponentProvider.registerAdditionalArtifact(projectId, IdeaPlugin.createImlArtifact(projectId, project));
        }
    }

    private static LocalComponentArtifactMetadata createImlArtifact(ProjectComponentIdentifier projectId, Project project) {
        String moduleName = ((IdeaModel)project.getExtensions().getByType(IdeaModel.class)).getModule().getName();
        File imlFile = new File(project.getProjectDir(), moduleName + ".iml");
        Task byName = project.getTasks().getByName("ideaModule");
        DefaultPublishArtifact publishArtifact = new DefaultPublishArtifact(moduleName, "iml", "iml", null, null, imlFile, new Object[]{byName});
        return new PublishArtifactLocalArtifactMetadata((ComponentIdentifier)projectId, "idea.iml", (PublishArtifact)publishArtifact);
    }

    private void configureIdeaWorkspace(Project project) {
        if (IdeaPlugin.isRoot(project)) {
            GenerateIdeaWorkspace task = (GenerateIdeaWorkspace)project.getTasks().create("ideaWorkspace", GenerateIdeaWorkspace.class);
            task.setDescription("Generates an IDEA workspace file (IWS)");
            IdeaWorkspace workspace = new IdeaWorkspace();
            workspace.setIws(new XmlFileContentMerger(task.getXmlTransformer()));
            task.setWorkspace(workspace);
            this.ideaModel.setWorkspace(task.getWorkspace());
            task.setOutputFile(new File(project.getProjectDir(), project.getName() + ".iws"));
            this.addWorker((Task)task, false);
        }
    }

    private void configureIdeaProject(final Project project) {
        if (IdeaPlugin.isRoot(project)) {
            final GenerateIdeaProject task = (GenerateIdeaProject)project.getTasks().create("ideaProject", GenerateIdeaProject.class);
            task.setDescription("Generates IDEA project file (IPR)");
            XmlFileContentMerger ipr = new XmlFileContentMerger(task.getXmlTransformer());
            IdeaProject ideaProject = (IdeaProject)this.instantiator.newInstance(IdeaProject.class, new Object[]{project, ipr});
            task.setIdeaProject(ideaProject);
            this.ideaModel.setProject(ideaProject);
            ideaProject.setOutputFile(new File(project.getProjectDir(), project.getName() + ".ipr"));
            ConventionMapping conventionMapping = ((IConventionAware)ideaProject).getConventionMapping();
            conventionMapping.map("jdkName", (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return JavaVersion.current().toString();
                }
            });
            conventionMapping.map("languageLevel", (Callable)new Callable<IdeaLanguageLevel>(){

                @Override
                public IdeaLanguageLevel call() throws Exception {
                    JavaVersion maxSourceCompatibility = IdeaPlugin.this.getMaxJavaModuleCompatibilityVersionFor((Function<Project, JavaVersion>)((Function)new Function<Project, JavaVersion>(){

                        public JavaVersion apply(Project p) {
                            return ((JavaPluginConvention)p.getConvention().getPlugin(JavaPluginConvention.class)).getSourceCompatibility();
                        }
                    }));
                    return new IdeaLanguageLevel(maxSourceCompatibility);
                }
            });
            conventionMapping.map("targetBytecodeVersion", (Callable)new Callable<JavaVersion>(){

                @Override
                public JavaVersion call() throws Exception {
                    return IdeaPlugin.this.getMaxJavaModuleCompatibilityVersionFor((Function<Project, JavaVersion>)((Function)new Function<Project, JavaVersion>(){

                        public JavaVersion apply(Project p) {
                            return ((JavaPluginConvention)p.getConvention().getPlugin(JavaPluginConvention.class)).getTargetCompatibility();
                        }
                    }));
                }
            });
            ideaProject.setWildcards(Sets.newHashSet((Object[])new String[]{"!?*.class", "!?*.scala", "!?*.groovy", "!?*.java"}));
            conventionMapping.map("modules", (Callable)new Callable<List<IdeaModule>>(){

                @Override
                public List<IdeaModule> call() throws Exception {
                    return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Sets.filter((Set)project.getRootProject().getAllprojects(), (Predicate)new Predicate<Project>(){

                        public boolean apply(Project p) {
                            return p.getPlugins().hasPlugin(IdeaPlugin.class);
                        }
                    }), (Function)new Function<Project, IdeaModule>(){

                        public IdeaModule apply(Project p) {
                            return IdeaPlugin.ideaModelFor(p).getModule();
                        }
                    }));
                }
            });
            conventionMapping.map("pathFactory", (Callable)new Callable<PathFactory>(){

                @Override
                public PathFactory call() throws Exception {
                    return new PathFactory().addPathVariable("PROJECT_DIR", task.getOutputFile().getParentFile());
                }
            });
            this.addWorker((Task)task);
        }
    }

    private static IdeaModel ideaModelFor(Project project) {
        return (IdeaModel)project.getExtensions().getByType(IdeaModel.class);
    }

    private JavaVersion getMaxJavaModuleCompatibilityVersionFor(Function<Project, JavaVersion> toJavaVersion) {
        ArrayList allProjectJavaVersions = Lists.newArrayList((Iterable)Iterables.transform((Iterable)Sets.filter((Set)this.project.getRootProject().getAllprojects(), (Predicate)new Predicate<Project>(){

            public boolean apply(Project project) {
                return project.getPlugins().hasPlugin(IdeaPlugin.class) && project.getPlugins().hasPlugin(JavaBasePlugin.class);
            }
        }), toJavaVersion));
        if (allProjectJavaVersions.isEmpty()) {
            return JavaVersion.VERSION_1_6;
        }
        return (JavaVersion)Collections.max(Sets.newHashSet((Iterable)allProjectJavaVersions));
    }

    private void configureIdeaModule(final Project project) {
        final GenerateIdeaModule task = (GenerateIdeaModule)project.getTasks().create("ideaModule", GenerateIdeaModule.class);
        task.setDescription("Generates IDEA module files (IML)");
        IdeaModuleIml iml = new IdeaModuleIml(task.getXmlTransformer(), project.getProjectDir());
        final IdeaModule module = (IdeaModule)this.instantiator.newInstance(IdeaModule.class, new Object[]{project, iml});
        task.setModule(module);
        this.ideaModel.setModule(module);
        ConventionMapping conventionMapping = ((IConventionAware)module).getConventionMapping();
        conventionMapping.map("sourceDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return Sets.newHashSet();
            }
        });
        conventionMapping.map("name", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getName();
            }
        });
        conventionMapping.map("contentRoot", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return project.getProjectDir();
            }
        });
        conventionMapping.map("testSourceDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return Sets.newHashSet();
            }
        });
        conventionMapping.map("excludeDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return Sets.newHashSet((Object[])new File[]{project.getBuildDir(), project.file((Object)".gradle")});
            }
        });
        conventionMapping.map("pathFactory", (Callable)new Callable<PathFactory>(){

            @Override
            public PathFactory call() throws Exception {
                PathFactory factory = new PathFactory();
                factory.addPathVariable("MODULE_DIR", task.getOutputFile().getParentFile());
                for (Map.Entry<String, File> entry : module.getPathVariables().entrySet()) {
                    factory.addPathVariable(entry.getKey(), entry.getValue());
                }
                return factory;
            }
        });
        this.addWorker((Task)task);
    }

    private DomainObjectCollection<JavaPlugin> configureForJavaPlugin(final Project project) {
        return project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                IdeaPlugin.this.configureIdeaModuleForJava(project);
            }
        });
    }

    private void configureIdeaModuleForJava(final Project project) {
        project.getTasks().withType(GenerateIdeaModule.class, (Action)new Action<GenerateIdeaModule>(){

            public void execute(GenerateIdeaModule ideaModule) {
                LinkedHashMap scopes = Maps.newLinkedHashMap();
                this.addScope("PROVIDED", scopes);
                this.addScope("COMPILE", scopes);
                this.addScope("RUNTIME", scopes);
                this.addScope("TEST", scopes);
                ideaModule.getModule().setScopes(scopes);
                ConventionMapping convention = ((IConventionAware)ideaModule.getModule()).getConventionMapping();
                convention.map("sourceDirs", (Callable)new Callable<Set<File>>(){

                    @Override
                    public Set<File> call() throws Exception {
                        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
                        return ((SourceSet)sourceSets.getByName("main")).getAllSource().getSrcDirs();
                    }
                });
                convention.map("testSourceDirs", (Callable)new Callable<Set<File>>(){

                    @Override
                    public Set<File> call() throws Exception {
                        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
                        return ((SourceSet)sourceSets.getByName("test")).getAllSource().getSrcDirs();
                    }
                });
                convention.map("singleEntryLibraries", (Callable)new Callable<Map<String, FileCollection>>(){

                    @Override
                    public Map<String, FileCollection> call() throws Exception {
                        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
                        LinkedHashMap<String, FileCollection> map = new LinkedHashMap<String, FileCollection>(2);
                        map.put("RUNTIME", ((SourceSet)sourceSets.getByName("main")).getOutput().getDirs());
                        map.put("TEST", ((SourceSet)sourceSets.getByName("test")).getOutput().getDirs());
                        return map;
                    }
                });
                convention.map("targetBytecodeVersion", (Callable)new Callable<JavaVersion>(){

                    @Override
                    public JavaVersion call() throws Exception {
                        JavaVersion moduleTargetBytecodeLevel = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getTargetCompatibility();
                        return IdeaPlugin.includeModuleBytecodeLevelOverride(project.getRootProject(), moduleTargetBytecodeLevel) ? moduleTargetBytecodeLevel : null;
                    }
                });
                convention.map("languageLevel", (Callable)new Callable<IdeaLanguageLevel>(){

                    @Override
                    public IdeaLanguageLevel call() throws Exception {
                        IdeaLanguageLevel moduleLanguageLevel = new IdeaLanguageLevel(((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceCompatibility());
                        return IdeaPlugin.includeModuleLanguageLevelOverride(project.getRootProject(), moduleLanguageLevel) ? moduleLanguageLevel : null;
                    }
                });
                ideaModule.dependsOn(new Object[]{new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
                        return ((SourceSet)sourceSets.getByName("main")).getOutput().getDirs().plus(((SourceSet)sourceSets.getByName("test")).getOutput().getDirs());
                    }
                }});
            }

            private void addScope(String name, LinkedHashMap<String, Map<String, Collection<Configuration>>> scopes) {
                LinkedHashMap scope = Maps.newLinkedHashMap();
                scope.put("plus", Lists.newArrayList());
                scope.put("minus", Lists.newArrayList());
                scopes.put(name, scope);
            }
        });
    }

    private static boolean includeModuleBytecodeLevelOverride(Project rootProject, JavaVersion moduleTargetBytecodeLevel) {
        if (!rootProject.getPlugins().hasPlugin(IdeaPlugin.class)) {
            return true;
        }
        IdeaProject ideaProject = IdeaPlugin.ideaModelFor(rootProject).getProject();
        return !moduleTargetBytecodeLevel.equals((Object)ideaProject.getTargetBytecodeVersion());
    }

    private static boolean includeModuleLanguageLevelOverride(Project rootProject, IdeaLanguageLevel moduleLanguageLevel) {
        if (!rootProject.getPlugins().hasPlugin(IdeaPlugin.class)) {
            return true;
        }
        IdeaProject ideaProject = IdeaPlugin.ideaModelFor(rootProject).getProject();
        return !moduleLanguageLevel.equals(ideaProject.getLanguageLevel());
    }

    private void configureForScalaPlugin() {
        this.project.getPlugins().withType(ScalaBasePlugin.class, (Action)new Action<ScalaBasePlugin>(){

            public void execute(ScalaBasePlugin scalaBasePlugin) {
                IdeaPlugin.this.ideaModuleDependsOnRoot();
            }
        });
        this.project.getPlugins().withType(ScalaLanguagePlugin.class, (Action)new Action<ScalaLanguagePlugin>(){

            public void execute(ScalaLanguagePlugin scalaLanguagePlugin) {
                IdeaPlugin.this.ideaModuleDependsOnRoot();
            }
        });
        if (IdeaPlugin.isRoot(this.project)) {
            new IdeaScalaConfigurer(this.project).configure();
        }
    }

    private void ideaModuleDependsOnRoot() {
        ((Task)this.project.getTasks().findByName("ideaModule")).dependsOn(new Object[]{this.project.getRootProject().getTasks().findByName("ideaProject")});
    }

    private static boolean isRoot(Project project) {
        return project.getParent() == null;
    }
}

