/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver.model;

import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.plugins.ide.internal.resolver.model.IdeDependency;

public class IdeProjectDependency
extends IdeDependency {
    private final ProjectComponentIdentifier projectId;
    private final String projectName;

    public IdeProjectDependency(ProjectComponentIdentifier projectId, String projectName) {
        this.projectId = projectId;
        this.projectName = projectName;
    }

    public IdeProjectDependency(ProjectComponentIdentifier projectId) {
        this.projectId = projectId;
        this.projectName = IdeProjectDependency.determineProjectName(projectId);
    }

    public ProjectComponentIdentifier getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    private static String determineProjectName(ProjectComponentIdentifier projectId) {
        assert (!projectId.getBuild().isCurrentBuild());
        String projectPath = projectId.getProjectPath();
        if (projectPath.equals(":")) {
            return projectId.getBuild().getName();
        }
        int index = projectPath.lastIndexOf(58);
        return projectPath.substring(index + 1);
    }
}

