/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleFactory;

public class DefaultJvmVersionDetector
implements JvmVersionDetector {
    private final ExecHandleFactory execHandleFactory;

    public DefaultJvmVersionDetector(ExecHandleFactory execHandleFactory) {
        this.execHandleFactory = execHandleFactory;
    }

    public JavaVersion getJavaVersion(JavaInfo jvm) {
        return this.getJavaVersion(jvm.getJavaExecutable().getPath());
    }

    public JavaVersion getJavaVersion(String javaCommand) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ExecHandleBuilder builder = this.execHandleFactory.newExec();
        builder.setWorkingDir((Object)new File(".").getAbsolutePath());
        builder.setCommandLine(new Object[]{javaCommand, "-version"});
        builder.setStandardOutput((OutputStream)new ByteArrayOutputStream());
        builder.setErrorOutput((OutputStream)outputStream);
        builder.build().start().waitForFinish().assertNormalExitValue();
        return this.parseJavaVersionCommandOutput(javaCommand, new BufferedReader(new InputStreamReader(new ByteArrayInputStream(outputStream.toByteArray()))));
    }

    private JavaVersion parseJavaVersionCommandOutput(String javaExecutable, BufferedReader reader) {
        try {
            String versionStr = reader.readLine();
            while (versionStr != null) {
                Matcher matcher = Pattern.compile("(?:java|openjdk) version \"(.+?)\"").matcher(versionStr);
                if (matcher.matches()) {
                    return JavaVersion.toVersion((Object)matcher.group(1));
                }
                versionStr = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        throw new GradleException(String.format("Could not determine Java version using executable %s.", javaExecutable));
    }
}

