/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.tooling.internal.provider.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.DeserializeMap;
import org.gradle.tooling.internal.provider.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.SerializeMap;
import org.gradle.tooling.internal.provider.SerializedPayload;

@ThreadSafe
public class PayloadSerializer {
    private static final short SYSTEM_CLASS_LOADER_ID = -1;
    private static final ClassLoader SYSTEM_CLASS_LOADER = new DefaultClassLoaderFactory().getIsolatedSystemClassLoader();
    private static final Set<ClassLoader> SYSTEM_CLASS_LOADERS = new HashSet<ClassLoader>();
    private final PayloadClassLoaderRegistry classLoaderRegistry;

    public PayloadSerializer(PayloadClassLoaderRegistry registry) {
        this.classLoaderRegistry = registry;
    }

    public SerializedPayload serialize(Object payload) {
        final SerializeMap map = this.classLoaderRegistry.newSerializeSession();
        try {
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(content){

                @Override
                protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
                    Class<?> targetClass = desc.forClass();
                    this.writeClass(targetClass);
                }

                @Override
                protected void annotateProxyClass(Class<?> cl) throws IOException {
                    this.writeInt(cl.getInterfaces().length);
                    for (Class<?> type : cl.getInterfaces()) {
                        this.writeClass(type);
                    }
                }

                private void writeClass(Class<?> targetClass) throws IOException {
                    this.writeClassLoader(targetClass);
                    this.writeUTF(targetClass.getName());
                }

                private void writeClassLoader(Class<?> targetClass) throws IOException {
                    ClassLoader classLoader = targetClass.getClassLoader();
                    if (classLoader == null || SYSTEM_CLASS_LOADERS.contains(classLoader)) {
                        this.writeShort(-1);
                    } else {
                        this.writeShort(map.visitClass(targetClass));
                    }
                }
            };
            objectStream.writeObject(payload);
            objectStream.close();
            Map<Short, ClassLoaderDetails> classLoaders = map.getClassLoaders();
            if (classLoaders.containsKey((short)-1)) {
                throw new IllegalArgumentException("Unexpected ClassLoader id found");
            }
            return new SerializedPayload(classLoaders, content.toByteArray());
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public Object deserialize(SerializedPayload payload) {
        final DeserializeMap map = this.classLoaderRegistry.newDeserializeSession();
        try {
            final ClassLoader systemClassLoader = SYSTEM_CLASS_LOADER;
            final Map classLoaderDetails = (Map)payload.getHeader();
            ObjectInputStream objectStream = new ObjectInputStream(new ByteArrayInputStream(payload.getSerializedModel())){

                @Override
                protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                    Class<?> aClass = this.readClass();
                    ObjectStreamClass descriptor = ObjectStreamClass.lookupAny(aClass);
                    if (descriptor == null) {
                        throw new ClassNotFoundException(aClass.getName());
                    }
                    return descriptor;
                }

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return desc.forClass();
                }

                private Class<?> readClass() throws IOException, ClassNotFoundException {
                    short id = this.readShort();
                    String className = this.readUTF();
                    if (id == -1) {
                        return Class.forName(className, false, systemClassLoader);
                    }
                    ClassLoaderDetails classLoader = (ClassLoaderDetails)classLoaderDetails.get(id);
                    return map.resolveClass(classLoader, className);
                }

                @Override
                protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
                    int count = this.readInt();
                    Class[] actualInterfaces = new Class[count];
                    for (int i = 0; i < count; ++i) {
                        actualInterfaces[i] = this.readClass();
                    }
                    return Proxy.getProxyClass(actualInterfaces[0].getClassLoader(), actualInterfaces);
                }
            };
            return objectStream.readObject();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    static {
        for (ClassLoader cl = SYSTEM_CLASS_LOADER; cl != null; cl = cl.getParent()) {
            SYSTEM_CLASS_LOADERS.add(cl);
        }
    }
}

