/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jetty;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.plugins.jetty.AbstractJettyRunTask;
import org.gradle.api.plugins.jetty.internal.Jetty6PluginServer;
import org.gradle.api.plugins.jetty.internal.JettyPluginServer;
import org.gradle.api.tasks.InputFile;
import org.mortbay.util.Scanner;
import org.mortbay.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JettyRunWar
extends AbstractJettyRunTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyRunWar.class);
    private File webApp;

    @Override
    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.getWebAppConfig().setWar(this.getWebApp().getCanonicalPath());
        this.getWebAppConfig().configure();
    }

    @Override
    public void validateConfiguration() {
    }

    @Override
    public void configureScanner() {
        ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(this.getProject().getBuildFile());
        scanList.add(this.getWebApp());
        this.getScanner().setScanDirs(scanList);
        ArrayList<Scanner.Listener> listeners = new ArrayList<Scanner.Listener>();
        listeners.add((Scanner.Listener)new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    boolean reconfigure = changes.contains(JettyRunWar.this.getProject().getBuildFile().getCanonicalPath());
                    JettyRunWar.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    LOGGER.error("Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        LOGGER.info("Restarting webapp ...");
        LOGGER.debug("Stopping webapp ...");
        this.getWebAppConfig().stop();
        LOGGER.debug("Reconfiguring webapp ...");
        this.validateConfiguration();
        if (reconfigureScanner) {
            LOGGER.info("Reconfiguring scanner ...");
            ArrayList<File> scanList = new ArrayList<File>();
            scanList.add(this.getProject().getBuildFile());
            scanList.add(this.getWebApp());
            this.getScanner().setScanDirs(scanList);
        }
        LOGGER.debug("Restarting webapp ...");
        this.getWebAppConfig().start();
        LOGGER.info("Restart completed.");
    }

    @Override
    public void finishConfigurationBeforeStart() {
    }

    @InputFile
    public File getWebApp() {
        return this.webApp;
    }

    public void setWebApp(File webApp) {
        this.webApp = webApp;
    }

    @Override
    public void applyJettyXml() throws Exception {
        if (this.getJettyConfig() == null) {
            return;
        }
        LOGGER.info("Configuring Jetty from xml configuration file = {}", (Object)this.getJettyConfig());
        XmlConfiguration xmlConfiguration = new XmlConfiguration(this.getJettyConfig().toURI().toURL());
        xmlConfiguration.configure(this.getServer().getProxiedObject());
    }

    @Override
    public JettyPluginServer createServer() throws Exception {
        return new Jetty6PluginServer();
    }
}

