/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathNotationConverter
implements NotationConverter<Object, String> {
    @Override
    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("String or CharSequence instances").example("'some/path'");
        visitor.candidate("Boolean values").example("true").example("Boolean.TRUE");
        visitor.candidate("Number values").example("42").example("3.14");
        visitor.candidate("A File instance");
        visitor.candidate("A Closure that returns any supported value.");
        visitor.candidate("A Callable that returns any supported value.");
    }

    public static NotationParser<Object, String> parser() {
        return NotationParserBuilder.toType(String.class).noImplicitConverters().allowNullInput().converter(new PathNotationConverter()).toComposite();
    }

    @Override
    public void convert(Object notation, NotationConvertResult<? super String> result) throws TypeConversionException {
        if (notation == null) {
            result.converted(null);
        } else if (notation instanceof CharSequence || notation instanceof File || notation instanceof Number || notation instanceof Boolean) {
            result.converted(notation.toString());
        } else if (notation instanceof Closure) {
            Closure closure = (Closure)notation;
            Object called = closure.call();
            this.convert(called, result);
        } else if (notation instanceof Callable) {
            Callable callableNotation = (Callable)notation;
            Object called = GUtil.uncheckedCall((Callable)callableNotation);
            this.convert(called, result);
            if (!result.hasResult()) {
                throw new TypeConversionException("Couldn't convert " + notation);
            }
        }
    }
}

