/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationUtils;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.InputFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputFilePropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction inputFileValidation = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
            File fileValue = (File)value;
            if (!fileValue.exists()) {
                messages.add(String.format("File '%s' specified for property '%s' does not exist.", fileValue, propertyName));
            } else if (!fileValue.isFile()) {
                messages.add(String.format("File '%s' specified for property '%s' is not a file.", fileValue, propertyName));
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return InputFile.class;
    }

    @Override
    public boolean attachActions(final TaskPropertyActionContext context) {
        context.setValidationAction(this.inputFileValidation);
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(TaskInternal task, Callable<Object> futureValue) {
                task.getInputs().files(futureValue).withPropertyName(context.getName()).withPathSensitivity(PropertyAnnotationUtils.getPathSensitivity(context));
            }
        });
        return true;
    }

    @Override
    public boolean getMustNotBeNullByDefault() {
        return true;
    }
}

