/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.rc.plugins.internal;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.rc.WindowsResourceSet;
import org.gradle.language.rc.tasks.WindowsResourceCompile;
import org.gradle.nativeplatform.PreprocessingTool;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.StaticLibraryBinarySpecInternal;
import org.gradle.platform.base.BinarySpec;

public class WindowsResourcesCompileTaskConfig
implements SourceTransformTaskConfig {
    public String getTaskPrefix() {
        return "compile";
    }

    public Class<? extends DefaultTask> getTaskType() {
        return WindowsResourceCompile.class;
    }

    public void configureTask(Task task, BinarySpec binary, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
        this.configureResourceCompileTask((WindowsResourceCompile)task, (NativeBinarySpecInternal)binary, (WindowsResourceSet)sourceSet);
    }

    private void configureResourceCompileTask(WindowsResourceCompile task, NativeBinarySpecInternal binary, final WindowsResourceSet sourceSet) {
        task.setDescription("Compiles resources of the " + sourceSet + " of " + binary);
        task.setToolChain(binary.getToolChain());
        task.setTargetPlatform(binary.getTargetPlatform());
        task.includes(new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                return sourceSet.getExportedHeaders().getSrcDirs();
            }
        });
        task.source(sourceSet.getSource());
        Project project = task.getProject();
        task.setOutputDir(new File(binary.getNamingScheme().getOutputDirectory(project.getBuildDir(), "objs"), ((LanguageSourceSetInternal)sourceSet).getProjectScopedName()));
        PreprocessingTool rcCompiler = (PreprocessingTool)binary.getToolByName("rcCompiler");
        task.setMacros(rcCompiler.getMacros());
        task.setCompilerArgs(rcCompiler.getArgs());
        FileTree resourceOutputs = task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.res"}));
        binary.binaryInputs((FileCollection)resourceOutputs);
        if (binary instanceof StaticLibraryBinarySpecInternal) {
            ((StaticLibraryBinarySpecInternal)binary).additionalLinkFiles((FileCollection)resourceOutputs);
        }
    }
}

