/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalButtonUI;
import org.gradle.gradleplugin.userinterface.swing.common.BorderlessUtility;

public class BorderlessImageToggleButton
extends JToggleButton {
    public Border selectedBorder = BorderFactory.createLoweredBevelBorder();
    private Color defaultBackground;

    public BorderlessImageToggleButton(Action action, Icon icon) {
        super(action);
        this.setUI();
        this.init(icon);
    }

    private void setUI() {
        this.setUI(MetalButtonUI.createUI(this));
    }

    private void init(Icon icon) {
        this.setBorder(BorderlessUtility.DEFAULT_BORDER);
        this.defaultBackground = this.getBackground();
        this.addMouseListener(new HighlightMouseListener());
        this.setText(null);
        if (icon != null) {
            this.setIcon(icon);
            int height = icon.getIconHeight();
            int width = icon.getIconWidth();
            Dimension preferredSize = new Dimension(width + 2, height + 2);
            this.setMinimumSize(preferredSize);
            this.setMaximumSize(preferredSize);
            this.setPreferredSize(preferredSize);
            this.setFocusPainted(false);
        }
    }

    public void setSelected(boolean select) {
        super.setSelected(select);
        this.setBorder(null);
    }

    public void setBorder(Border border) {
        super.setBorder(this.isSelected() ? this.selectedBorder : BorderlessUtility.DEFAULT_BORDER);
    }

    private class HighlightMouseListener
    extends MouseAdapter {
        public void mouseEntered(MouseEvent event) {
            if (BorderlessImageToggleButton.this.getAction() != null ? BorderlessImageToggleButton.this.getAction().isEnabled() : BorderlessImageToggleButton.this.isEnabled()) {
                BorderlessImageToggleButton.this.setBackground(BorderlessUtility.ON_MOUSE_OVER_BACKGROUND);
                BorderlessImageToggleButton.this.setBorder(BorderlessUtility.ON_MOUSEOVER_BORDER);
            }
        }

        public void mousePressed(MouseEvent event) {
            if (BorderlessImageToggleButton.this.getAction() != null ? BorderlessImageToggleButton.this.getAction().isEnabled() : BorderlessImageToggleButton.this.isEnabled()) {
                BorderlessImageToggleButton.this.setBackground(BorderlessUtility.ON_BUTTON_PRESSED_BACKGROUND);
            }
        }

        public void mouseReleased(MouseEvent event) {
            Rectangle buttonRect;
            if ((BorderlessImageToggleButton.this.getAction() != null ? BorderlessImageToggleButton.this.getAction().isEnabled() : BorderlessImageToggleButton.this.isEnabled()) && (buttonRect = BorderlessImageToggleButton.this.getBounds()).contains((Point2D)event.getPoint())) {
                BorderlessImageToggleButton.this.setBackground(BorderlessUtility.ON_MOUSE_OVER_BACKGROUND);
            }
        }

        public void mouseExited(MouseEvent event) {
            BorderlessImageToggleButton.this.setBackground(BorderlessImageToggleButton.this.defaultBackground);
            if (BorderlessImageToggleButton.this.isSelected()) {
                BorderlessImageToggleButton.this.setBorder(BorderlessImageToggleButton.this.selectedBorder);
            } else {
                BorderlessImageToggleButton.this.setBorder(BorderlessUtility.DEFAULT_BORDER);
            }
        }
    }
}

