/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.extapi.psi;

import java.lang.reflect.Array;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiLock;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;

public class StubBasedPsiElementBase<T extends StubElement>
extends ASTDelegatePsiElement {
    public static final Key<String> CREATION_TRACE = Key.create("CREATION_TRACE");
    private static final Logger LOG = Logger.getInstance("#com.intellij.extapi.psi.StubBasedPsiElementBase");
    public static final boolean ourTraceStubAstBinding = "true".equals(System.getProperty("trace.stub.ast.binding", "false"));
    private volatile T myStub;
    private volatile ASTNode myNode;
    private final IElementType myElementType;

    public StubBasedPsiElementBase(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "<init>"));
        }
        this.myStub = stub;
        this.myElementType = nodeType;
        this.myNode = null;
    }

    public StubBasedPsiElementBase(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "<init>"));
        }
        this.myNode = node;
        this.myElementType = node.getElementType();
    }

    public StubBasedPsiElementBase(T stub, IElementType nodeType, ASTNode node) {
        if (stub != null) {
            if (nodeType == null) {
                throw new IllegalArgumentException("null cannot be passed to 'nodeType' when 'stub' is non-null");
            }
            if (node != null) {
                throw new IllegalArgumentException("null must be passed to 'node' parameter when 'stub' is non-null");
            }
            this.myStub = stub;
            this.myElementType = nodeType;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("'stub' and 'node' parameters cannot be null both");
            }
            if (nodeType != null) {
                throw new IllegalArgumentException("null must be passed to 'nodeType' parameter when 'node' is non-null");
            }
            this.myNode = node;
            this.myElementType = node.getElementType();
        }
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        ASTNode node = this.myNode;
        if (node == null) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            PsiFileImpl file2 = (PsiFileImpl)this.getContainingFile();
            if (!file2.isValid()) {
                throw new PsiInvalidElementAccessException(this);
            }
            FileElement treeElement = file2.getTreeElement();
            if (treeElement != null && this.myNode == null) {
                ASTNode aSTNode = this.notBoundInExistingAst(file2, treeElement);
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "getNode"));
                }
                return aSTNode;
            }
            treeElement = file2.calcTreeElement();
            node = this.myNode;
            if (node == null) {
                ASTNode aSTNode = this.failedToBindStubToAst(file2, treeElement);
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "getNode"));
                }
                return aSTNode;
            }
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "getNode"));
        }
        return aSTNode;
    }

    private ASTNode failedToBindStubToAst(PsiFileImpl file2, FileElement fileElement) {
        VirtualFile vFile = file2.getVirtualFile();
        StubTree stubTree = file2.getStubTree();
        String stubString = stubTree != null ? ((PsiFileStubImpl)stubTree.getRoot()).printTree() : "is null";
        String astString = DebugUtil.treeToString(fileElement, true);
        if (!ourTraceStubAstBinding) {
            stubString = StringUtil.trimLog(stubString, 1024);
            astString = StringUtil.trimLog(astString, 1024);
        }
        String message = "Failed to bind stub to AST for element " + this.getClass() + " in " + (vFile == null ? "<unknown file>" : vFile.getPath()) + "\nFile:\n" + file2 + "@" + System.identityHashCode(file2) + "\nFile stub tree:\n" + stubString + "\nLoaded file AST:\n" + astString;
        if (ourTraceStubAstBinding) {
            message = message + this.dumpCreationTraces(fileElement);
        }
        throw new IllegalArgumentException(message);
    }

    private String dumpCreationTraces(FileElement fileElement) {
        final StringBuilder traces = new StringBuilder("\nNow " + Thread.currentThread() + "\n");
        traces.append("My creation trace:\n").append(this.getUserData(CREATION_TRACE));
        traces.append("AST creation traces:\n");
        fileElement.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            public void visitComposite(CompositeElement composite) {
                PsiElement psi = composite.getPsi();
                if (psi != null) {
                    traces.append(psi).append("@").append(System.identityHashCode(psi)).append("\n");
                    String trace = psi.getUserData(CREATION_TRACE);
                    if (trace != null) {
                        traces.append(trace).append("\n");
                    }
                }
                super.visitComposite(composite);
            }
        });
        return traces.toString();
    }

    private ASTNode notBoundInExistingAst(PsiFileImpl file2, FileElement treeElement) {
        String message = "file=" + file2 + "; tree=" + treeElement;
        for (PsiElement each = this; each != null; each = each.getParentByStub()) {
            message = message + "\n each of class " + each.getClass() + "; valid=" + each.isValid();
            if (each instanceof StubBasedPsiElementBase) {
                message = message + "; node=" + each.myNode + "; stub=" + each.myStub;
                continue;
            }
            if (!(each instanceof PsiFile)) break;
            message = message + "; same file=" + (each == file2) + "; current tree= " + file2.getTreeElement() + "; stubTree=" + file2.getStubTree() + "; physical=" + file2.isPhysical();
            break;
        }
        for (Object eachStub = this.myStub; eachStub != null; eachStub = eachStub.getParentStub()) {
            message = message + "\n each stub " + (eachStub instanceof PsiFileStubImpl ? ((PsiFileStubImpl)eachStub).getDiagnostics() : eachStub);
        }
        if (ourTraceStubAstBinding) {
            message = message + this.dumpCreationTraces(treeElement);
        }
        throw new AssertionError((Object)message);
    }

    public final void setNode(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "setNode"));
        }
        this.myNode = node;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "getLanguage"));
        }
        return language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFile file2;
        Object stub = this.myStub;
        if (stub != null) {
            while (!(stub instanceof PsiFileStub)) {
                stub = stub.getParentStub();
            }
            PsiFile psi = (PsiFile)stub.getPsi();
            if (psi != null) {
                PsiFile psiFile = psi;
                if (psiFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "getContainingFile"));
                }
                return psiFile;
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Object object = PsiLock.LOCK;
            synchronized (object) {
                if (this.myStub != null) {
                    String reason = ((PsiFileStubImpl)stub).getInvalidationReason();
                    PsiInvalidElementAccessException exception = new PsiInvalidElementAccessException(this, "no psi for file stub " + stub + ", invalidation reason=" + reason, null);
                    if ("stub-psi mismatch".equals(reason)) {
                        throw new ProcessCanceledException(exception);
                    }
                    throw exception;
                }
            }
        }
        if ((file2 = super.getContainingFile()) == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        PsiFile psiFile = file2;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "getContainingFile"));
        }
        return psiFile;
    }

    @Override
    public boolean isWritable() {
        return this.getContainingFile().isWritable();
    }

    @Override
    public boolean isValid() {
        T stub = this.myStub;
        if (stub != null) {
            StubElement parent2 = stub.getParentStub();
            if (parent2 == null) {
                LOG.error("No parent for stub " + stub + " of class " + stub.getClass());
                return false;
            }
            Object psi = parent2.getPsi();
            return psi != null && psi.isValid();
        }
        return super.isValid();
    }

    @Override
    public PsiManagerEx getManager() {
        return (PsiManagerEx)this.getContainingFile().getManager();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.getContainingFile().getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "getProject"));
        }
        return project;
    }

    @Override
    public boolean isPhysical() {
        return this.getContainingFile().isPhysical();
    }

    @Override
    public PsiElement getContext() {
        T stub = this.myStub;
        if (stub != null && !(stub instanceof PsiFileStub)) {
            return stub.getParentStub().getPsi();
        }
        return super.getContext();
    }

    protected final PsiElement getParentByStub() {
        T stub = this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        return SharedImplUtil.getParent(this.getNode());
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.setStub(null);
    }

    protected final PsiElement getParentByTree() {
        return SharedImplUtil.getParent(this.getNode());
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByTree();
    }

    @NotNull
    public IStubElementType getElementType() {
        if (!(this.myElementType instanceof IStubElementType)) {
            throw new AssertionError((Object)("Not a stub type: " + this.myElementType + " in " + this.getClass()));
        }
        IStubElementType iStubElementType = (IStubElementType)this.myElementType;
        if (iStubElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "getElementType"));
        }
        return iStubElementType;
    }

    @Nullable
    public T getStub() {
        ProgressIndicatorProvider.checkCanceled();
        return this.myStub;
    }

    public final void setStub(@Nullable T stub) {
        this.myStub = stub;
    }

    @Nullable
    public <Psi extends PsiElement> Psi getStubOrPsiChild(IStubElementType<? extends StubElement, Psi> elementType) {
        T stub = this.myStub;
        if (stub != null) {
            StubElement<Psi> element = stub.findChildStubByType(elementType);
            if (element != null) {
                return element.getPsi();
            }
        } else {
            ASTNode childNode = this.getNode().findChildByType(elementType);
            if (childNode != null) {
                return (Psi)childNode.getPsi();
            }
        }
        return null;
    }

    @NotNull
    public <S extends StubElement, Psi extends PsiElement> Psi getRequiredStubOrPsiChild(IStubElementType<S, Psi> elementType) {
        Psi result2 = this.getStubOrPsiChild(elementType);
        assert (result2 != null) : "Missing required child of type " + elementType + "; tree: " + DebugUtil.psiToString(this, false);
        Psi Psi = result2;
        if (Psi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/extapi/psi/StubBasedPsiElementBase", "getRequiredStubOrPsiChild"));
        }
        return Psi;
    }

    public <S extends StubElement, Psi extends PsiElement> Psi[] getStubOrPsiChildren(IStubElementType<S, Psi> elementType, Psi[] array) {
        T stub = this.myStub;
        if (stub != null) {
            return stub.getChildrenByType(elementType, array);
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    public <S extends StubElement, Psi extends PsiElement> Psi[] getStubOrPsiChildren(IStubElementType<S, Psi> elementType, ArrayFactory<Psi> f) {
        T stub = this.myStub;
        if (stub != null) {
            return stub.getChildrenByType(elementType, f);
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    public <Psi extends PsiElement> Psi[] getStubOrPsiChildren(TokenSet filter2, Psi[] array) {
        T stub = this.myStub;
        if (stub != null) {
            return stub.getChildrenByType(filter2, array);
        }
        ASTNode[] nodes = this.getNode().getChildren(filter2);
        PsiElement[] psiElements = (PsiElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    public <Psi extends PsiElement> Psi[] getStubOrPsiChildren(TokenSet filter2, ArrayFactory<Psi> f) {
        T stub = this.myStub;
        if (stub != null) {
            return stub.getChildrenByType(filter2, f);
        }
        ASTNode[] nodes = this.getNode().getChildren(filter2);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        return psiElements;
    }

    @Nullable
    protected <E extends PsiElement> E getStubOrPsiParentOfType(Class<E> parentClass) {
        T stub = this.myStub;
        if (stub != null) {
            return stub.getParentStubOfType(parentClass);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)this, parentClass);
    }

    @Deprecated
    @Nullable
    protected PsiElement getStubOrPsiParent() {
        T stub = this.myStub;
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        return this.getParent();
    }

    @Override
    protected Object clone() {
        StubBasedPsiElementBase copy = (StubBasedPsiElementBase)super.clone();
        copy.myStub = null;
        return copy;
    }
}

