/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.pom.impl;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.pom.PomManager;
import org.jetbrains.kotlin.com.intellij.pom.PomModelAspect;
import org.jetbrains.kotlin.com.intellij.pom.PomTransaction;
import org.jetbrains.kotlin.com.intellij.pom.event.PomModelEvent;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public abstract class PomTransactionBase
implements PomTransaction {
    private final PsiElement myScope;
    private final PomModelAspect myAspect;
    private final PomModelEvent myAccumulatedEvent;

    public PomTransactionBase(PsiElement scope, PomModelAspect aspect) {
        this.myScope = scope;
        this.myAspect = aspect;
        this.myAccumulatedEvent = new PomModelEvent(PomManager.getModel(scope.getProject()));
    }

    public PomModelEvent getAccumulatedEvent() {
        return this.myAccumulatedEvent;
    }

    public void run() throws IncorrectOperationException {
        PomModelEvent event = this.runInner();
        if (event == null) {
            this.myAccumulatedEvent.registerChangeSet(this.myAspect, null);
            return;
        }
        this.myAccumulatedEvent.merge(event);
    }

    @Nullable
    public abstract PomModelEvent runInner() throws IncorrectOperationException;

    public PsiElement getChangeScope() {
        return this.myScope;
    }

    public PomModelAspect getTransactionAspect() {
        return this.myAspect;
    }
}

