/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

public class PsiCapturedWildcardType
extends PsiType.Stub {
    @NotNull
    private final PsiWildcardType myExistential;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private final PsiTypeParameter myParameter;
    private PsiType myUpperBound;
    public static RecursionGuard guard = RecursionManager.createGuard("captureGuard");

    @NotNull
    public static PsiCapturedWildcardType create(@NotNull PsiWildcardType existential, @NotNull PsiElement context) {
        if (existential == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existential", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        PsiCapturedWildcardType psiCapturedWildcardType = PsiCapturedWildcardType.create(existential, context, null);
        if (psiCapturedWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        return psiCapturedWildcardType;
    }

    @NotNull
    public static PsiCapturedWildcardType create(@NotNull PsiWildcardType existential, @NotNull PsiElement context, @Nullable PsiTypeParameter parameter) {
        if (existential == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existential", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        PsiCapturedWildcardType psiCapturedWildcardType = new PsiCapturedWildcardType(existential, context, parameter);
        if (psiCapturedWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "create"));
        }
        return psiCapturedWildcardType;
    }

    private PsiCapturedWildcardType(@NotNull PsiWildcardType existential, @NotNull PsiElement context, @Nullable PsiTypeParameter parameter) {
        if (existential == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existential", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "<init>"));
        }
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myExistential = existential;
        this.myContext = context;
        this.myParameter = parameter;
        this.myUpperBound = PsiType.getJavaLangObject(this.myContext.getManager(), this.getResolveScope());
    }

    public static boolean isCapture() {
        return guard.currentStack().isEmpty();
    }

    @Nullable
    public static PsiType captureUpperBound(@NotNull PsiTypeParameter typeParameter, @NotNull PsiWildcardType wildcardType, @NotNull PsiSubstitutor captureSubstitutor) {
        PsiType originalBound;
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "captureUpperBound"));
        }
        if (wildcardType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wildcardType", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "captureUpperBound"));
        }
        if (captureSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "captureUpperBound"));
        }
        PsiClassType[] boundTypes = typeParameter.getExtendsListTypes();
        PsiType glb = originalBound = !wildcardType.isSuper() ? wildcardType.getBound() : null;
        for (PsiClassType boundType : boundTypes) {
            PsiType substitutedBoundType = captureSubstitutor.substitute(boundType);
            if (originalBound instanceof PsiArrayType && substitutedBoundType instanceof PsiArrayType && !originalBound.isAssignableFrom(substitutedBoundType) && !substitutedBoundType.isAssignableFrom(originalBound)) continue;
            glb = glb == null ? substitutedBoundType : GenericsUtil.getGreatestLowerBound(glb, substitutedBoundType);
        }
        return glb;
    }

    public boolean equals(Object o) {
        Boolean sameUpperBounds;
        if (!(o instanceof PsiCapturedWildcardType)) {
            return false;
        }
        final PsiCapturedWildcardType captured = (PsiCapturedWildcardType)o;
        PsiManager manager = this.myContext.getManager();
        if (!manager.areElementsEquivalent(this.myContext, captured.myContext)) {
            return false;
        }
        if ((this.myExistential.isSuper() || captured.myExistential.isSuper()) && !this.myExistential.equals(captured.myExistential)) {
            return false;
        }
        if ((this.myContext instanceof PsiReferenceExpression || this.myContext instanceof PsiMethodCallExpression) && !manager.areElementsEquivalent(this.myParameter, captured.myParameter)) {
            return false;
        }
        if (this.myParameter != null && ((sameUpperBounds = guard.doPreventingRecursion(this.myContext, true, new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return Comparing.equal(PsiCapturedWildcardType.this.myUpperBound, captured.myUpperBound);
            }
        })) == null || sameUpperBounds.booleanValue())) {
            return true;
        }
        return this.myExistential.equals(captured.myExistential);
    }

    public int hashCode() {
        return this.myUpperBound.hashCode() + 31 * this.myContext.hashCode();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = "capture of " + this.myExistential.getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.myExistential.getCanonicalText(annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = "capture<" + this.myExistential.getInternalCanonicalText() + '>';
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "getInternalCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean isValid() {
        return this.myExistential.isValid() && this.myContext.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "equalsToText"));
        }
        return false;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "accept"));
        }
        return visitor2.visitCapturedWildcardType(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myExistential.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = this.myExistential.getSuperTypes();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "getSuperTypes"));
        }
        return psiTypeArray;
    }

    public PsiType getLowerBound() {
        return this.myExistential.isSuper() ? this.myExistential.getBound() : NULL;
    }

    @NotNull
    public PsiType getUpperBound() {
        PsiType bound = this.myExistential.getBound();
        if (this.myExistential.isExtends() && this.myParameter == null) {
            assert (bound != null) : this.myExistential.getCanonicalText();
            PsiType psiType = bound;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "getUpperBound"));
            }
            return psiType;
        }
        PsiType psiType = this.myUpperBound;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "getUpperBound"));
        }
        return psiType;
    }

    public void setUpperBound(@NotNull PsiType upperBound) {
        if (upperBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperBound", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "setUpperBound"));
        }
        this.myUpperBound = upperBound;
    }

    @NotNull
    public PsiWildcardType getWildcard() {
        PsiWildcardType psiWildcardType = this.myExistential;
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "getWildcard"));
        }
        return psiWildcardType;
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiCapturedWildcardType", "getContext"));
        }
        return psiElement;
    }

    public PsiTypeParameter getTypeParameter() {
        return this.myParameter;
    }
}

