/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.OriginInfoAwareElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightModifierList;
import org.jetbrains.kotlin.com.intellij.ui.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public abstract class LightVariableBase
extends LightElement
implements OriginInfoAwareElement,
PsiVariable {
    protected PsiElement myScope;
    protected PsiIdentifier myNameIdentifier;
    protected PsiType myType;
    protected final PsiModifierList myModifierList;
    protected boolean myWritable;
    private String myOriginInfo = null;

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, PsiType type2, boolean writable, PsiElement scope) {
        this(manager, nameIdentifier, JavaLanguage.INSTANCE, type2, writable, scope);
    }

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, Language language, PsiType type2, boolean writable, PsiElement scope) {
        super(manager, language);
        this.myNameIdentifier = nameIdentifier;
        this.myWritable = writable;
        this.myType = type2;
        this.myScope = scope;
        this.myModifierList = this.createModifierList();
    }

    protected PsiModifierList createModifierList() {
        return new LightModifierList(this.getManager());
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement = this.myScope;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBase", "getDeclarationScope"));
        }
        return psiElement;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    @Override
    public boolean isValid() {
        return this.myNameIdentifier == null || this.myNameIdentifier.isValid();
    }

    @Override
    @NotNull
    public String getName() {
        String string = StringUtil.notNullize(this.getNameIdentifier().getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBase", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBase", "setName"));
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public PsiType getType() {
        if (this.myType == null) {
            this.myType = this.computeType();
        }
        PsiType psiType = this.myType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBase", "getType"));
        }
        return psiType;
    }

    @NotNull
    protected PsiType computeType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBase", "computeType"));
        }
        return psiPrimitiveType;
    }

    @Override
    @NotNull
    public PsiTypeElement getTypeElement() {
        PsiTypeElement psiTypeElement = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createTypeElement(this.myType);
        if (psiTypeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBase", "getTypeElement"));
        }
        return psiTypeElement;
    }

    @Override
    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBase", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public String getText() {
        return this.myNameIdentifier.getText();
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public boolean isWritable() {
        return this.myWritable;
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.VARIABLE_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(String originInfo) {
        this.myOriginInfo = originInfo;
    }
}

