/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc;

import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.JavaErrorMessages;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaDocTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.JavadocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

class ParamDocTagInfo
implements JavadocTagInfo {
    ParamDocTagInfo() {
    }

    @Override
    public String getName() {
        return "param";
    }

    @Override
    public boolean isValidInContext(PsiElement element) {
        return element instanceof PsiMethod || element instanceof PsiClass && PsiUtil.isLanguageLevel5OrHigher(element);
    }

    @Override
    public Object[] getPossibleValues(PsiElement context, PsiElement place, String prefix) {
        if (context instanceof PsiTypeParameterListOwner) {
            ArrayList<PsiTypeParameter> result2 = new ArrayList<PsiTypeParameter>(Arrays.asList(((PsiTypeParameterListOwner)context).getTypeParameters()));
            if (context instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)context;
                ContainerUtil.addAll(result2, method.getParameterList().getParameters());
            }
            return result2.toArray(new PsiNamedElement[result2.size()]);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public String checkTagValue(PsiDocTagValue value) {
        if (value == null) {
            return JavaErrorMessages.message("javadoc.param.tag.parameter.name.expected", new Object[0]);
        }
        ASTNode firstChildNode = value.getNode().getFirstChildNode();
        if (firstChildNode != null && firstChildNode.getElementType().equals(JavaDocTokenType.DOC_TAG_VALUE_LT)) {
            if (value.getNode().findChildByType(JavaDocTokenType.DOC_TAG_VALUE_TOKEN) == null) {
                return JavaErrorMessages.message("javadoc.param.tag.type.parameter.name.expected", new Object[0]);
            }
            if (value.getNode().findChildByType(JavaDocTokenType.DOC_TAG_VALUE_GT) == null) {
                return JavaErrorMessages.message("javadoc.param.tag.type.parameter.gt.expected", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public PsiReference getReference(PsiDocTagValue value) {
        if (value instanceof PsiDocParamRef) {
            return value.getReference();
        }
        return null;
    }

    @Override
    public boolean isInline() {
        return false;
    }
}

