/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavadocParser;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.PsiDocCommentImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.PsiDocTagImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.PsiInlineDocTagImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.ICompositeElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IReparseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.tree.java.IJavaDocElementType;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import sun.reflect.ConstructorAccessor;

public interface JavaDocElementType {
    public static final IElementType DOC_TAG = new JavaDocCompositeElementType("DOC_TAG", PsiDocTagImpl.class);
    public static final IElementType DOC_INLINE_TAG = new JavaDocCompositeElementType("DOC_INLINE_TAG", PsiInlineDocTagImpl.class);
    public static final IElementType DOC_METHOD_OR_FIELD_REF = new JavaDocCompositeElementType("DOC_METHOD_OR_FIELD_REF", PsiDocMethodOrFieldRef.class);
    public static final IElementType DOC_PARAMETER_REF = new JavaDocCompositeElementType("DOC_PARAMETER_REF", PsiDocParamRef.class);
    public static final IElementType DOC_TAG_VALUE_ELEMENT = new IJavaDocElementType("DOC_TAG_VALUE_ELEMENT");
    public static final ILazyParseableElementType DOC_REFERENCE_HOLDER = new JavaDocLazyElementType("DOC_REFERENCE_HOLDER"){
        private final JavaParserUtil.ParserWrapper myParser = new JavaParserUtil.ParserWrapper(){

            @Override
            public void parse(PsiBuilder builder) {
                JavadocParser.parseJavadocReference(builder);
            }
        };

        @Override
        @Nullable
        public ASTNode parseContents(ASTNode chameleon) {
            return JavaParserUtil.parseFragment(chameleon, this.myParser, false, LanguageLevel.JDK_1_3);
        }
    };
    public static final ILazyParseableElementType DOC_TYPE_HOLDER = new JavaDocLazyElementType("DOC_TYPE_HOLDER"){
        private final JavaParserUtil.ParserWrapper myParser = new JavaParserUtil.ParserWrapper(){

            @Override
            public void parse(PsiBuilder builder) {
                JavadocParser.parseJavadocType(builder);
            }
        };

        @Override
        @Nullable
        public ASTNode parseContents(ASTNode chameleon) {
            return JavaParserUtil.parseFragment(chameleon, this.myParser, false, LanguageLevel.JDK_1_3);
        }
    };
    public static final ILazyParseableElementType DOC_COMMENT = new IReparseableElementType("DOC_COMMENT", JavaLanguage.INSTANCE){
        private final JavaParserUtil.ParserWrapper myParser = new JavaParserUtil.ParserWrapper(){

            @Override
            public void parse(PsiBuilder builder) {
                JavadocParser.parseDocCommentText(builder);
            }
        };

        @Override
        public ASTNode createNode(CharSequence text2) {
            return new PsiDocCommentImpl(text2);
        }

        @Override
        @Nullable
        public ASTNode parseContents(ASTNode chameleon) {
            return JavaParserUtil.parseFragment(chameleon, this.myParser);
        }

        @Override
        public boolean isParsable(CharSequence buffer, Language fileLanguage, Project project) {
            if (!StringUtil.startsWith(buffer, "/**") || !StringUtil.endsWith(buffer, "*/")) {
                return false;
            }
            Lexer lexer = JavaParserDefinition.createLexer(LanguageLevelProjectExtension.getInstance(project).getLanguageLevel());
            lexer.start(buffer);
            if (lexer.getTokenType() == DOC_COMMENT) {
                lexer.advance();
                if (lexer.getTokenType() == null) {
                    return true;
                }
            }
            return false;
        }
    };
    public static final TokenSet ALL_JAVADOC_ELEMENTS = TokenSet.create(DOC_TAG, DOC_INLINE_TAG, DOC_METHOD_OR_FIELD_REF, DOC_PARAMETER_REF, DOC_TAG_VALUE_ELEMENT, DOC_REFERENCE_HOLDER, DOC_TYPE_HOLDER, DOC_COMMENT);

    public static class JavaDocLazyElementType
    extends ILazyParseableElementType {
        private JavaDocLazyElementType(@NonNls String debugName) {
            super(debugName, JavaLanguage.INSTANCE);
        }

        @Override
        public ASTNode createNode(CharSequence text2) {
            return new LazyParseablePsiElement(this, text2);
        }
    }

    public static class JavaDocCompositeElementType
    extends IJavaDocElementType
    implements ICompositeElementType {
        private final ConstructorAccessor myConstructor;

        private JavaDocCompositeElementType(@NonNls String debugName, Class<? extends ASTNode> nodeClass) {
            super(debugName);
            Constructor<? extends ASTNode> constructor = ReflectionUtil.getDefaultConstructor(nodeClass);
            this.myConstructor = ReflectionUtil.getConstructorAccessor(constructor);
        }

        @Override
        @NotNull
        public ASTNode createCompositeNode() {
            ASTNode aSTNode = (ASTNode)ReflectionUtil.createInstanceViaConstructorAccessor(this.myConstructor);
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaDocElementType$JavaDocCompositeElementType", "createCompositeNode"));
            }
            return aSTNode;
        }
    }
}

