/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.PackageIndex;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

public class PackageScope
extends GlobalSearchScope {
    private final Collection<VirtualFile> myDirs;
    private final PsiPackage myPackage;
    private final boolean myIncludeSubpackages;
    private final boolean myIncludeLibraries;
    protected final boolean myPartOfPackagePrefix;
    protected final String myPackageQualifiedName;
    protected final String myPackageQNamePrefix;

    public PackageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages, boolean includeLibraries) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope", "<init>"));
        }
        super(aPackage.getProject());
        this.myPackage = aPackage;
        this.myIncludeSubpackages = includeSubpackages;
        Project project = this.myPackage.getProject();
        this.myPackageQualifiedName = this.myPackage.getQualifiedName();
        this.myDirs = PackageIndex.getInstance(project).getDirsByPackageName(this.myPackageQualifiedName, true).findAll();
        this.myIncludeLibraries = includeLibraries;
        this.myPartOfPackagePrefix = JavaPsiFacade.getInstance(this.getProject()).isPartOfPackagePrefix(this.myPackageQualifiedName);
        this.myPackageQNamePrefix = this.myPackageQualifiedName + ".";
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        String packageName;
        PsiFile psiFile;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope", "contains"));
        }
        for (VirtualFile scopeDir : this.myDirs) {
            boolean inDir = this.myIncludeSubpackages ? VfsUtilCore.isAncestor(scopeDir, file2, false) : Comparing.equal(file2.getParent(), scopeDir);
            if (!inDir) continue;
            return true;
        }
        return this.myPartOfPackagePrefix && this.myIncludeSubpackages && (psiFile = this.myPackage.getManager().findFile(file2)) instanceof PsiClassOwner && (this.myPackageQualifiedName.equals(packageName = ((PsiClassOwner)psiFile).getPackageName()) || packageName.startsWith(this.myPackageQNamePrefix));
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope", "compare"));
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope", "isSearchInModuleContent"));
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myIncludeLibraries;
    }

    public String toString() {
        return "package scope: " + this.myPackage + ", includeSubpackages = " + this.myIncludeSubpackages;
    }

    @NotNull
    public static GlobalSearchScope packageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope", "packageScope"));
        }
        PackageScope packageScope = new PackageScope(aPackage, includeSubpackages, true);
        if (packageScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope", "packageScope"));
        }
        return packageScope;
    }

    @NotNull
    public static GlobalSearchScope packageScopeWithoutLibraries(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope", "packageScopeWithoutLibraries"));
        }
        PackageScope packageScope = new PackageScope(aPackage, includeSubpackages, false);
        if (packageScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/PackageScope", "packageScopeWithoutLibraries"));
        }
        return packageScope;
    }
}

