/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;

public class InOperationTranslator
extends AbstractTranslator {
    private static final DescriptorPredicate INT_SPECIALIZATION_TEST = PatternBuilder.pattern("ranges.IntRange.contains");
    private static final DescriptorPredicate INT_RANGE_TEST = PatternBuilder.pattern("Int.rangeTo");
    private final JsExpression left;
    private final KtExpression right;
    private final KtSimpleNameExpression operation;
    private final boolean negated;

    public InOperationTranslator(@NotNull TranslationContext context, @NotNull JsExpression left, @NotNull KtExpression right, @NotNull KtSimpleNameExpression operation, boolean negated) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "<init>"));
        }
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "<init>"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "<init>"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "<init>"));
        }
        super(context);
        this.left = left;
        this.right = right;
        this.operation = operation;
        this.negated = negated;
    }

    @NotNull
    public JsExpression translate() {
        JsExpression candidate;
        ResolvedCall<? extends FunctionDescriptor> call = CallUtilKt.getFunctionResolvedCallWithAssert(this.operation, this.bindingContext());
        if (INT_SPECIALIZATION_TEST.apply(call.getResultingDescriptor()) && (candidate = this.translateInt()) != null) {
            JsExpression jsExpression = candidate;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression rightTranslated = Translation.translateAsExpression(this.right, this.context());
        JsExpression jsExpression = this.translateGeneral(call, rightTranslated);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateGeneral(@NotNull ResolvedCall<? extends FunctionDescriptor> call, @NotNull JsExpression rightTranslated) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "translateGeneral"));
        }
        if (rightTranslated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightTranslated", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "translateGeneral"));
        }
        JsExpression result2 = CallTranslator.translate(this.context(), call, rightTranslated);
        if (this.negated) {
            result2 = JsAstUtils.negated(result2);
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "translateGeneral"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression translateInt() {
        ResolvedCall<? extends CallableDescriptor> rightCall = CallUtilKt.getResolvedCallWithAssert(this.right, this.bindingContext());
        if (!(rightCall.getResultingDescriptor() instanceof FunctionDescriptor)) {
            return null;
        }
        FunctionDescriptor callDescriptor = (FunctionDescriptor)rightCall.getResultingDescriptor();
        if (!INT_RANGE_TEST.apply(callDescriptor)) {
            return null;
        }
        if (!(rightCall.getDispatchReceiver() instanceof ExpressionReceiver)) {
            return null;
        }
        KtExpression lower = ((ExpressionReceiver)rightCall.getDispatchReceiver()).getExpression();
        KtExpression upper = rightCall.getCall().getValueArguments().get(0).getArgumentExpression();
        assert (upper != null) : "Parse error occurred: " + PsiUtilsKt.getTextWithLocation(this.right);
        return this.translateInt(lower, upper);
    }

    @NotNull
    private JsExpression translateInt(@NotNull KtExpression lowerExpression, @NotNull KtExpression upperExpression) {
        if (lowerExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lowerExpression", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "translateInt"));
        }
        if (upperExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperExpression", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "translateInt"));
        }
        JsExpression lower = Translation.translateAsExpression(lowerExpression, this.context());
        JsExpression upper = Translation.translateAsExpression(upperExpression, this.context());
        if (!this.negated) {
            JsBinaryOperation first = JsAstUtils.greaterThanEq(this.left, lower);
            JsBinaryOperation second = JsAstUtils.lessThanEq(this.left, upper);
            JsBinaryOperation jsBinaryOperation = JsAstUtils.and(first, second);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "translateInt"));
            }
            return jsBinaryOperation;
        }
        JsBinaryOperation first = JsAstUtils.lessThan(this.left, lower);
        JsBinaryOperation second = JsAstUtils.greaterThan(this.left, upper);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.or(first, second);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/InOperationTranslator", "translateInt"));
        }
        return jsBinaryOperation;
    }
}

