/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0002\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\f\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"isFromIncrementalPackageFragment", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "toSourceElement", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "getToSourceElement", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/SourceElement;", "getSourceElement", "descriptor", "isContainedByCompiledPartOfOurModule", "outDirectory", "Ljava/io/File;", "kotlin-compiler"})
public final class ModuleVisibilityUtilsKt {
    public static final boolean isFromIncrementalPackageFragment(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return DescriptorUtils.getParentOfType($receiver, PackageFragmentDescriptor.class, false) instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment;
    }

    public static final boolean isContainedByCompiledPartOfOurModule(@NotNull DeclarationDescriptor descriptor2, @Nullable File outDirectory) {
        VirtualFile file2;
        KotlinJvmBinaryClass binaryClass;
        KotlinJvmBinaryClass kotlinJvmBinaryClass;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        PackageFragmentDescriptor packageFragment = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class, false);
        if (packageFragment instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment) {
            return true;
        }
        if (outDirectory == null || !(packageFragment instanceof LazyJavaPackageFragment)) {
            return false;
        }
        SourceElement source = ModuleVisibilityUtilsKt.getSourceElement(descriptor2);
        SourceElement sourceElement = source;
        if (sourceElement instanceof KotlinJvmBinarySourceElement) {
            kotlinJvmBinaryClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
        } else if (sourceElement instanceof KotlinJvmBinaryPackageSourceElement) {
            if (descriptor2 instanceof DeserializedCallableMemberDescriptor) {
                kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedCallableMemberDescriptor)descriptor2);
                if (kotlinJvmBinaryClass == null) {
                    kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass();
                }
            } else {
                kotlinJvmBinaryClass = ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass();
            }
        } else {
            kotlinJvmBinaryClass = binaryClass = (KotlinJvmBinaryClass)null;
        }
        if (binaryClass instanceof VirtualFileKotlinClass && Intrinsics.areEqual((file2 = ((VirtualFileKotlinClass)binaryClass).getFile()).getFileSystem().getProtocol(), "file")) {
            File ioFile = VfsUtilCore.virtualToIoFile(file2);
            return StringsKt.startsWith$default(ioFile.getAbsolutePath(), outDirectory.getAbsolutePath() + File.separator, false, 2, null);
        }
        return false;
    }

    @NotNull
    public static final SourceElement getSourceElement(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getSource() == SourceElement.NO_SOURCE ? ModuleVisibilityUtilsKt.getToSourceElement(((CallableMemberDescriptor)descriptor2).getContainingDeclaration()) : ModuleVisibilityUtilsKt.getToSourceElement(descriptor2);
    }

    private static final SourceElement getToSourceElement(@NotNull DeclarationDescriptor $receiver) {
        SourceElement sourceElement;
        if ($receiver instanceof DeclarationDescriptorWithSource) {
            SourceElement sourceElement2 = ((DeclarationDescriptorWithSource)$receiver).getSource();
            sourceElement = sourceElement2;
            Intrinsics.checkExpressionValueIsNotNull(sourceElement2, "source");
        } else {
            SourceElement sourceElement3 = SourceElement.NO_SOURCE;
            sourceElement = sourceElement3;
            Intrinsics.checkExpressionValueIsNotNull(sourceElement3, "SourceElement.NO_SOURCE");
        }
        return sourceElement;
    }
}

