/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerBuilder;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002J,\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010#\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0016H\u0016J(\u0010#\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u001a2\b\u0010'\u001a\u0004\u0018\u00010(J\u000e\u0010)\u001a\u0004\u0018\u00010\f*\u00020*H\u0002\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "checkTypesForReturnStatements", "", "function", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "actualReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "collectReturns", "", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "computeReturnType", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "functionTypeExpected", "", "computeReturnTypeBasedOnReturnExpressions", "typeOfBodyExpression", "computeUnsafeReturnType", "expectedReturnType", "createFunctionLiteralDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "data", "isDeclaration", "statementScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "createFunctionType", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "kotlin-compiler"})
public final class FunctionsTypingVisitor
extends ExpressionTypingVisitor {
    @Override
    @NotNull
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext data) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return this.visitNamedFunction(function2, data, false, null);
    }

    @NotNull
    public final KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext context, boolean isDeclaration, @Nullable LexicalWritableScope statementScope) {
        SimpleFunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (!isDeclaration) {
            if (!function2.getTypeParameters().isEmpty()) {
                context.trace.report(Errors.TYPE_PARAMETERS_NOT_ALLOWED.on((KtDeclaration)((PsiElement)function2)));
            }
            if (function2.getName() != null) {
                BindingTrace bindingTrace = context.trace;
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                bindingTrace.report(Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(psiElement));
            }
            for (KtParameter parameter : function2.getValueParameters()) {
                if (parameter.hasDefaultValue()) {
                    context.trace.report(Errors.ANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE.on((KtParameter)((PsiElement)parameter)));
                }
                if (!parameter.isVarArg()) continue;
                context.trace.report(Errors.USELESS_VARARG_ON_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
        if (isDeclaration) {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            functionDescriptor = functionDescriptorResolver.resolveFunctionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo);
            boolean bl = statementScope != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "statementScope must be not null for function: " + function2.getName() + " at location " + DiagnosticUtils.atLocation(function2);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            LexicalWritableScope lexicalWritableScope = statementScope;
            if (lexicalWritableScope == null) {
                Intrinsics.throwNpe();
            }
            lexicalWritableScope.addFunctionDescriptor(functionDescriptor);
        } else {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            KotlinType kotlinType = context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
            functionDescriptor = functionDescriptorResolver.resolveFunctionExpressionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo, kotlinType);
        }
        ForceResolveUtil.forceResolveAllContents(functionDescriptor.getAnnotations());
        if (!function2.hasDeclaredReturnType() && !function2.hasBlockBody()) {
            ForceResolveUtil.forceResolveAllContents(functionDescriptor.getReturnType());
        } else {
            LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace, this.components.overloadChecker);
            this.components.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function2, functionDescriptor, context.dataFlowInfo, null, context.trace);
        }
        ValueParameterResolver valueParameterResolver = this.components.valueParameterResolver;
        List<KtParameter> list2 = function2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "function.getValueParameters()");
        List<ValueParameterDescriptor> list3 = functionDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, "functionDescriptor.valueParameters");
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        valueParameterResolver.resolveValueParameters(list2, list3, lexicalScope, dataFlowInfo, bindingTrace);
        KtDeclaration ktDeclaration = function2;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
        DeclarationsCheckerKt.checkTypeReferences(ktDeclaration, bindingTrace2);
        this.components.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(function2, functionDescriptor);
        IdentifierChecker identifierChecker = this.components.identifierChecker;
        KtDeclaration ktDeclaration2 = function2;
        DiagnosticSink diagnosticSink = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "context.trace");
        identifierChecker.checkDeclaration(ktDeclaration2, diagnosticSink);
        DeclarationsCheckerBuilder declarationsCheckerBuilder = this.components.declarationsCheckerBuilder;
        BindingTrace bindingTrace3 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace3, "context.trace");
        declarationsCheckerBuilder.withTrace(bindingTrace3).checkFunction(function2, functionDescriptor);
        if (isDeclaration) {
            return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(function2, context), context);
        }
        KotlinTypeInfo kotlinTypeInfo = this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.createFunctionType(functionDescriptor), context, function2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "components.dataFlowAnaly\u2026ype(), context, function)");
        return kotlinTypeInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType createFunctionType(@NotNull SimpleFunctionDescriptor $receiver) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
        Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "components.builtIns");
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getExtensionReceiverParameter();
        Iterable iterable = $receiver.getValueParameters();
        KotlinType kotlinType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        KotlinBuiltIns kotlinBuiltIns2 = kotlinBuiltIns;
        void var6_6 = $receiver$iv;
        Collection collection = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            list2 = destination$iv$iv;
            KotlinType kotlinType2 = it.getType();
            list2.add(kotlinType2);
        }
        list2 = (List)destination$iv$iv;
        KotlinType kotlinType3 = $receiver.getReturnType();
        if (kotlinType3 == null) {
            return null;
        }
        return FunctionTypeResolveUtilsKt.createFunctionType(kotlinBuiltIns2, annotations2, kotlinType, list2, kotlinType3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KotlinTypeInfo visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull ExpressionTypingContext context) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (!expression.getFunctionLiteral().hasBody()) {
            return null;
        }
        KotlinType expectedType = context.expectedType;
        boolean functionTypeExpected = !TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isFunctionType(expectedType);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionLiteralDescriptor(expression, context);
        Iterable iterable = expression.getValueParameters();
        for (Object element$iv : $receiver$iv) {
            KtParameter it = (KtParameter)element$iv;
            IdentifierChecker identifierChecker = this.components.identifierChecker;
            KtDeclaration ktDeclaration = it;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "it");
            DiagnosticSink diagnosticSink = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "context.trace");
            identifierChecker.checkDeclaration(ktDeclaration, diagnosticSink);
            KtNamedDeclaration ktNamedDeclaration = it;
            Intrinsics.checkExpressionValueIsNotNull(ktNamedDeclaration, "it");
            DiagnosticSink diagnosticSink2 = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink2, "context.trace");
            UnderscoreChecker.INSTANCE.checkNamed(ktNamedDeclaration, diagnosticSink2);
        }
        KotlinType safeReturnType = this.computeReturnType(expression, context, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        KotlinType kotlinType = this.createFunctionType(functionDescriptor);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType resultType = kotlinType;
        if (functionTypeExpected) {
            return TypeInfoFactoryKt.createTypeInfo(resultType, context);
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression);
    }

    private final AnonymousFunctionDescriptor createFunctionLiteralDescriptor(KtLambdaExpression expression, ExpressionTypingContext context) {
        KtFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        Annotations annotations2 = this.components.annotationResolver.resolveAnnotationsWithArguments(context.scope, KtPsiUtilKt.getAnnotationEntries(expression), context.trace);
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement(functionLiteral);
        BindingContext bindingContext = context.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
        ValueParameterDescriptor valueParameterDescriptor = CallResolverUtilKt.getCorrespondingParameterForFunctionArgument(expression, bindingContext);
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(declarationDescriptor, annotations2, CallableMemberDescriptor.Kind.DECLARATION, sourceElement, valueParameterDescriptor != null ? valueParameterDescriptor.isCoroutine() : false);
        FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
        DeclarationDescriptor declarationDescriptor2 = context.scope.getOwnerDescriptor();
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        KtFunction ktFunction = functionLiteral;
        Intrinsics.checkExpressionValueIsNotNull(ktFunction, "functionLiteral");
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
        functionDescriptorResolver.initializeFunctionDescriptorAndExplicitReturnType(declarationDescriptor2, lexicalScope, ktFunction, simpleFunctionDescriptorImpl, bindingTrace, kotlinType);
        for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
            ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context.trace, functionLiteral, functionDescriptor);
        return functionDescriptor;
    }

    private final KotlinType computeReturnType(KtLambdaExpression expression, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        if (functionTypeExpected) {
            KotlinType kotlinType3 = context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "context.expectedType");
            kotlinType2 = FunctionTypesKt.getReturnTypeFromFunctionType(kotlinType3);
        } else {
            kotlinType2 = null;
        }
        KotlinType expectedReturnType = kotlinType2;
        KotlinType returnType2 = this.computeUnsafeReturnType(expression, context, functionDescriptor, expectedReturnType);
        if (!expression.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected) {
            KotlinType kotlinType4 = expectedReturnType;
            if (kotlinType4 == null) {
                Intrinsics.throwNpe();
            }
            if (!TypeUtils.noExpectedType(kotlinType4) && KotlinBuiltIns.isUnit(expectedReturnType)) {
                KotlinType kotlinType5 = this.components.builtIns.getUnitType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType5, "components.builtIns.unitType");
                return kotlinType5;
            }
        }
        if ((kotlinType = returnType2) == null) {
            KotlinType kotlinType6 = TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE;
            kotlinType = kotlinType6;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType6, "CANT_INFER_FUNCTION_PARAM_TYPE");
        }
        return kotlinType;
    }

    private final KotlinType computeUnsafeReturnType(KtLambdaExpression expression, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, KotlinType expectedReturnType) {
        KtFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        KotlinType kotlinType = expectedReturnType;
        if (kotlinType == null) {
            KotlinType kotlinType2 = TypeUtils.NO_EXPECTED_TYPE;
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "NO_EXPECTED_TYPE");
        }
        KotlinType expectedType = kotlinType;
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace, this.components.overloadChecker);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(functionInnerScope)).replaceExpectedType(expectedType);
        context.trace.record(BindingContext.EXPECTED_RETURN_TYPE, functionLiteral, expectedType);
        ExpressionTypingServices expressionTypingServices = this.components.expressionTypingServices;
        KtBlockExpression ktBlockExpression = functionLiteral.getBodyExpression();
        if (ktBlockExpression == null) {
            Intrinsics.throwNpe();
        }
        KotlinType typeOfBodyExpression = expressionTypingServices.getBlockReturnedType(ktBlockExpression, CoercionStrategy.COERCION_TO_UNIT, newContext).getType();
        KtFunctionLiteral ktFunctionLiteral = functionLiteral;
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionLiteral, "functionLiteral");
        return this.computeReturnTypeBasedOnReturnExpressions(ktFunctionLiteral, context, typeOfBodyExpression);
    }

    private final KotlinType computeReturnTypeBasedOnReturnExpressions(KtFunctionLiteral functionLiteral, ExpressionTypingContext context, KotlinType typeOfBodyExpression) {
        KtExpression returnedExpression;
        ArrayList returnedExpressionTypes = Lists.newArrayList();
        boolean hasEmptyReturn = false;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        Collection<KtReturnExpression> returnExpressions = this.collectReturns(functionLiteral, bindingTrace);
        for (KtReturnExpression returnExpression : returnExpressions) {
            returnedExpression = returnExpression.getReturnedExpression();
            if (returnedExpression == null) {
                hasEmptyReturn = true;
                continue;
            }
            CollectionsKt.addIfNotNull(returnedExpressionTypes, context.trace.getType(returnedExpression));
        }
        if (hasEmptyReturn) {
            for (KtReturnExpression returnExpression : returnExpressions) {
                KotlinType type2;
                returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null || (type2 = context.trace.getType(returnedExpression)) != null && KotlinBuiltIns.isUnit(type2)) continue;
                context.trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnedExpression), this.components.builtIns.getUnitType()));
            }
            return this.components.builtIns.getUnitType();
        }
        CollectionsKt.addIfNotNull(returnedExpressionTypes, typeOfBodyExpression);
        if (returnedExpressionTypes.isEmpty()) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtReturnExpression> collectReturns(KtFunctionLiteral functionLiteral, BindingTrace trace) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KtBlockExpression bodyExpression;
        ArrayList result2 = Lists.newArrayList();
        KtBlockExpression ktBlockExpression = bodyExpression = functionLiteral.getBodyExpression();
        if (ktBlockExpression != null) {
            Void cfr_ignored_0 = (Void)ktBlockExpression.accept((KtVisitor)new KtTreeVisitor<List<KtReturnExpression>>(){

                @Nullable
                public Void visitReturnExpression(@NotNull KtReturnExpression expression, @NotNull List<KtReturnExpression> data) {
                    Intrinsics.checkParameterIsNotNull(expression, "expression");
                    Intrinsics.checkParameterIsNotNull(data, "data");
                    data.add(expression);
                    return null;
                }
            }, result2);
        }
        Iterable iterable = result2;
        void var6_6 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiElement psiElement;
            KtReturnExpression it = (KtReturnExpression)element$iv$iv;
            if (it.getTargetLabel() != null) {
                KtSimpleNameExpression ktSimpleNameExpression;
                KtSimpleNameExpression it2 = ktSimpleNameExpression;
                psiElement = (PsiElement)trace.get(BindingContext.LABEL_TARGET, it2);
            } else {
                psiElement = null;
            }
            if (!Intrinsics.areEqual(psiElement, functionLiteral)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void checkTypesForReturnStatements(@NotNull KtDeclarationWithBody function2, @NotNull BindingTrace trace, @NotNull KotlinType actualReturnType) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(actualReturnType, "actualReturnType");
        if (function2.hasBlockBody()) {
            return;
        }
        if (!(function2 instanceof KtNamedFunction && ((KtNamedFunction)function2).getTypeReference() == null || function2 instanceof KtPropertyAccessor && ((KtPropertyAccessor)function2).getReturnTypeReference() != null)) {
            return;
        }
        KtExpression ktExpression = function2.getBodyExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression bodyExpression = ktExpression;
        ArrayList returns = new ArrayList();
        bodyExpression.accept((KtVisitor)new KtTreeVisitor<Boolean>(function2, trace, returns){
            final /* synthetic */ KtDeclarationWithBody $function;
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ ArrayList $returns;

            @Nullable
            public Void visitReturnExpression(@NotNull KtReturnExpression expression, boolean data) {
                Intrinsics.checkParameterIsNotNull(expression, "expression");
                KtSimpleNameExpression label = expression.getTargetLabel();
                if (label != null && Intrinsics.areEqual((PsiElement)this.$trace.get(BindingContext.LABEL_TARGET, label), this.$function) || label == null && data) {
                    this.$returns.add(expression);
                }
                return (Void)super.visitReturnExpression(expression, data);
            }

            @Nullable
            public Void visitNamedFunction(@NotNull KtNamedFunction function2, boolean data) {
                Intrinsics.checkParameterIsNotNull(function2, "function");
                return (Void)super.visitNamedFunction(function2, false);
            }
            {
                this.$function = $captured_local_variable$0;
                this.$trace = $captured_local_variable$1;
                this.$returns = $captured_local_variable$2;
            }
        }, true);
        for (KtReturnExpression returnForCheck : returns) {
            KotlinType expressionType;
            KtExpression expression = returnForCheck.getReturnedExpression();
            if (expression == null) {
                if (TypeUtilsKt.isUnit(actualReturnType)) continue;
                trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnForCheck), actualReturnType));
                continue;
            }
            if (trace.getType(expression) == null) {
                continue;
            }
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, actualReturnType)) continue;
            trace.report(Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)expression), expressionType, actualReturnType));
        }
    }

    public FunctionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        super(facade);
    }
}

