/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DeflateSerializer
extends Serializer {
    private final Serializer serializer;
    private boolean noHeaders = true;
    private int compressionLevel = 4;

    public DeflateSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void write(Kryo kryo, Output output, Object object) {
        Deflater deflater = new Deflater(this.compressionLevel, this.noHeaders);
        DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)output, deflater);
        Output deflaterOutput = new Output(deflaterStream, 256);
        kryo.writeObject(deflaterOutput, object, this.serializer);
        deflaterOutput.flush();
        try {
            deflaterStream.finish();
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }

    public Object read(Kryo kryo, Input input, Class type) {
        Inflater inflater = new Inflater(this.noHeaders);
        InflaterInputStream inflaterInput = new InflaterInputStream(input, inflater);
        return kryo.readObject(new Input(inflaterInput, 256), type, this.serializer);
    }

    public void setNoHeaders(boolean noHeaders) {
        this.noHeaders = noHeaders;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public Object copy(Kryo kryo, Object original) {
        return this.serializer.copy(kryo, original);
    }
}

