/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.DefaultComponentSelection;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentSelectionRulesProcessor;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.MetadataProvider;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionInfo;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionedComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.resolve.result.BuildableComponentSelectionResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.util.CollectionUtils;

class DefaultVersionedComponentChooser
implements VersionedComponentChooser {
    private final ComponentSelectionRulesProcessor rulesProcessor = new ComponentSelectionRulesProcessor();
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;
    private final ComponentSelectionRulesInternal componentSelectionRules;

    DefaultVersionedComponentChooser(VersionComparator versionComparator, VersionSelectorScheme versionSelectorScheme, ComponentSelectionRulesInternal componentSelectionRules) {
        this.versionComparator = versionComparator;
        this.versionSelectorScheme = versionSelectorScheme;
        this.componentSelectionRules = componentSelectionRules;
    }

    @Override
    public ComponentResolveMetadata selectNewestComponent(ComponentResolveMetadata one, ComponentResolveMetadata two) {
        if (one == null || two == null) {
            return two == null ? one : two;
        }
        int comparison = this.versionComparator.compare(new VersionInfo(one.getId().getVersion()), new VersionInfo(two.getId().getVersion()));
        if (comparison == 0) {
            if (this.isGeneratedModuleDescriptor(one) && !this.isGeneratedModuleDescriptor(two)) {
                return two;
            }
            return one;
        }
        return comparison < 0 ? two : one;
    }

    private boolean isGeneratedModuleDescriptor(ComponentResolveMetadata componentResolveMetadata) {
        return componentResolveMetadata.isGenerated();
    }

    @Override
    public void selectNewestMatchingComponent(Collection<? extends ModuleComponentResolveState> versions, BuildableComponentSelectionResult result, ModuleVersionSelector requested) {
        VersionSelector requestedVersion = this.versionSelectorScheme.parseSelector(requested.getVersion());
        Collection<SpecRuleAction<? super ComponentSelection>> rules = this.componentSelectionRules.getRules();
        for (ModuleComponentResolveState candidate : this.sortLatestFirst(versions)) {
            boolean accepted;
            MetadataProvider metadataProvider = new MetadataProvider(candidate);
            boolean versionMatches = this.versionMatches(requestedVersion, candidate, metadataProvider);
            if (!metadataProvider.isUsable()) {
                this.applyTo(metadataProvider, result);
                return;
            }
            if (!versionMatches) {
                result.notMatched(candidate.getVersion());
                continue;
            }
            ModuleComponentIdentifier candidateIdentifier = candidate.getId();
            boolean bl = accepted = !this.isRejectedByRules(candidateIdentifier, rules, metadataProvider);
            if (!metadataProvider.isUsable()) {
                this.applyTo(metadataProvider, result);
                return;
            }
            if (accepted) {
                result.matches(candidateIdentifier);
                return;
            }
            result.rejected(candidate.getVersion());
            if (!requestedVersion.matchesUniqueVersion()) continue;
            break;
        }
        result.noMatchFound();
    }

    private void applyTo(MetadataProvider provider, BuildableComponentSelectionResult result) {
        BuildableModuleComponentMetaDataResolveResult metaDataResult = provider.getResult();
        switch (metaDataResult.getState()) {
            case Unknown: {
                result.noMatchFound();
                break;
            }
            case Missing: {
                result.noMatchFound();
                break;
            }
            case Failed: {
                result.failed(metaDataResult.getFailure());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected meta-data resolution result.");
            }
        }
    }

    private boolean versionMatches(VersionSelector selector, ModuleComponentResolveState component, MetadataProvider metadataProvider) {
        if (selector.requiresMetadata()) {
            if (!metadataProvider.resolve()) {
                return false;
            }
            return selector.accept(metadataProvider.getComponentMetadata());
        }
        return selector.accept(component.getVersion());
    }

    @Override
    public boolean isRejectedComponent(ModuleComponentIdentifier candidateIdentifier, MetadataProvider metadataProvider) {
        return this.isRejectedByRules(candidateIdentifier, this.componentSelectionRules.getRules(), metadataProvider);
    }

    private boolean isRejectedByRules(ModuleComponentIdentifier candidateIdentifier, Collection<SpecRuleAction<? super ComponentSelection>> rules, MetadataProvider metadataProvider) {
        DefaultComponentSelection selection = new DefaultComponentSelection(candidateIdentifier);
        this.rulesProcessor.apply(selection, rules, metadataProvider);
        return selection.isRejected();
    }

    private List<ModuleComponentResolveState> sortLatestFirst(Collection<? extends ModuleComponentResolveState> listing) {
        return CollectionUtils.sort(listing, Collections.reverseOrder(this.versionComparator));
    }
}

