/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.GapVector;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class GapContent
extends GapVector
implements AbstractDocument.Content,
Serializable {
    private static final char[] empty = new char[0];
    private transient MarkVector marks;
    private transient MarkData search;
    private transient int unusedMarks = 0;
    private transient ReferenceQueue<StickyPosition> queue;
    static final int GROWTH_SIZE = 524288;

    public GapContent() {
        this(10);
    }

    public GapContent(int n) {
        super(Math.max(n, 2));
        char[] cArray = new char[]{'\n'};
        this.replace(0, 0, cArray, cArray.length);
        this.marks = new MarkVector();
        this.search = new MarkData(0);
        this.queue = new ReferenceQueue();
    }

    @Override
    protected Object allocateArray(int n) {
        return new char[n];
    }

    @Override
    protected int getArrayLength() {
        char[] cArray = (char[])this.getArray();
        return cArray.length;
    }

    @Override
    public int length() {
        int n = this.getArrayLength() - (this.getGapEnd() - this.getGapStart());
        return n;
    }

    @Override
    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        if (n > this.length() || n < 0) {
            throw new BadLocationException("Invalid insert", this.length());
        }
        char[] cArray = string.toCharArray();
        this.replace(n, 0, cArray, cArray.length);
        return new InsertUndo(n, string.length());
    }

    @Override
    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        if (n + n2 >= this.length()) {
            throw new BadLocationException("Invalid remove", this.length() + 1);
        }
        String string = this.getString(n, n2);
        RemoveUndo removeUndo = new RemoveUndo(n, string);
        this.replace(n, n2, empty, 0);
        return removeUndo;
    }

    @Override
    public String getString(int n, int n2) throws BadLocationException {
        Segment segment = new Segment();
        this.getChars(n, n2, segment);
        return new String(segment.array, segment.offset, segment.count);
    }

    @Override
    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        int n3 = n + n2;
        if (n < 0 || n3 < 0) {
            throw new BadLocationException("Invalid location", -1);
        }
        if (n3 > this.length() || n > this.length()) {
            throw new BadLocationException("Invalid location", this.length() + 1);
        }
        int n4 = this.getGapStart();
        int n5 = this.getGapEnd();
        char[] cArray = (char[])this.getArray();
        if (n + n2 <= n4) {
            segment.array = cArray;
            segment.offset = n;
        } else if (n >= n4) {
            segment.array = cArray;
            segment.offset = n5 + n - n4;
        } else {
            int n6 = n4 - n;
            if (segment.isPartialReturn()) {
                segment.array = cArray;
                segment.offset = n;
                segment.count = n6;
                return;
            }
            segment.array = new char[n2];
            segment.offset = 0;
            System.arraycopy(cArray, n, segment.array, 0, n6);
            System.arraycopy(cArray, n5, segment.array, n6, n2 - n6);
        }
        segment.count = n2;
    }

    @Override
    public Position createPosition(int n) throws BadLocationException {
        StickyPosition stickyPosition;
        block6: {
            MarkData markData;
            int n2;
            int n3;
            block5: {
                while (this.queue.poll() != null) {
                    ++this.unusedMarks;
                }
                if (this.unusedMarks > Math.max(5, this.marks.size() / 10)) {
                    this.removeUnusedMarks();
                }
                int n4 = this.getGapStart();
                int n5 = this.getGapEnd();
                this.search.index = n3 = n < n4 ? n : n + (n5 - n4);
                n2 = this.findSortIndex(this.search);
                if (n2 >= this.marks.size()) break block5;
                markData = this.marks.elementAt(n2);
                if (markData.index == n3 && (stickyPosition = markData.getPosition()) != null) break block6;
            }
            stickyPosition = new StickyPosition();
            markData = new MarkData(n3, stickyPosition, this.queue);
            stickyPosition.setMark(markData);
            this.marks.insertElementAt(markData, n2);
        }
        return stickyPosition;
    }

    @Override
    protected void shiftEnd(int n) {
        int n2 = this.getGapEnd();
        super.shiftEnd(n);
        int n3 = this.getGapEnd() - n2;
        int n4 = this.findMarkAdjustIndex(n2);
        int n5 = this.marks.size();
        for (int i = n4; i < n5; ++i) {
            MarkData markData = this.marks.elementAt(i);
            markData.index += n3;
        }
    }

    @Override
    int getNewArraySize(int n) {
        if (n < 524288) {
            return super.getNewArraySize(n);
        }
        return n + 524288;
    }

    @Override
    protected void shiftGap(int n) {
        int n2 = this.getGapStart();
        int n3 = n - n2;
        int n4 = this.getGapEnd();
        int n5 = n4 + n3;
        int n6 = n4 - n2;
        super.shiftGap(n);
        if (n3 > 0) {
            int n7 = this.findMarkAdjustIndex(n2);
            int n8 = this.marks.size();
            for (int i = n7; i < n8; ++i) {
                MarkData markData = this.marks.elementAt(i);
                if (markData.index < n5) {
                    markData.index -= n6;
                    continue;
                }
                break;
            }
        } else if (n3 < 0) {
            int n9 = this.findMarkAdjustIndex(n);
            int n10 = this.marks.size();
            for (int i = n9; i < n10; ++i) {
                MarkData markData = this.marks.elementAt(i);
                if (markData.index < n4) {
                    markData.index += n6;
                    continue;
                }
                break;
            }
        }
        this.resetMarksAtZero();
    }

    protected void resetMarksAtZero() {
        if (this.marks != null && this.getGapStart() == 0) {
            int n = this.getGapEnd();
            int n2 = this.marks.size();
            for (int i = 0; i < n2; ++i) {
                MarkData markData = this.marks.elementAt(i);
                if (markData.index > n) break;
                markData.index = 0;
            }
        }
    }

    @Override
    protected void shiftGapStartDown(int n) {
        int n2 = this.findMarkAdjustIndex(n);
        int n3 = this.marks.size();
        int n4 = this.getGapStart();
        int n5 = this.getGapEnd();
        for (int i = n2; i < n3; ++i) {
            MarkData markData = this.marks.elementAt(i);
            if (markData.index > n4) break;
            markData.index = n5;
        }
        super.shiftGapStartDown(n);
        this.resetMarksAtZero();
    }

    @Override
    protected void shiftGapEndUp(int n) {
        int n2 = this.findMarkAdjustIndex(this.getGapEnd());
        int n3 = this.marks.size();
        for (int i = n2; i < n3; ++i) {
            MarkData markData = this.marks.elementAt(i);
            if (markData.index >= n) break;
            markData.index = n;
        }
        super.shiftGapEndUp(n);
        this.resetMarksAtZero();
    }

    final int compare(MarkData markData, MarkData markData2) {
        if (markData.index < markData2.index) {
            return -1;
        }
        if (markData.index > markData2.index) {
            return 1;
        }
        return 0;
    }

    final int findMarkAdjustIndex(int n) {
        this.search.index = Math.max(n, 1);
        int n2 = this.findSortIndex(this.search);
        for (int i = n2 - 1; i >= 0; --i) {
            MarkData markData = this.marks.elementAt(i);
            if (markData.index != this.search.index) break;
            --n2;
        }
        return n2;
    }

    final int findSortIndex(MarkData markData) {
        int n = 0;
        int n2 = this.marks.size() - 1;
        int n3 = 0;
        if (n2 == -1) {
            return 0;
        }
        MarkData markData2 = this.marks.elementAt(n2);
        int n4 = this.compare(markData, markData2);
        if (n4 > 0) {
            return n2 + 1;
        }
        while (n <= n2) {
            n3 = n + (n2 - n) / 2;
            MarkData markData3 = this.marks.elementAt(n3);
            n4 = this.compare(markData, markData3);
            if (n4 == 0) {
                return n3;
            }
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            n = n3 + 1;
        }
        return n4 < 0 ? n3 : n3 + 1;
    }

    final void removeUnusedMarks() {
        int n = this.marks.size();
        MarkVector markVector = new MarkVector(n);
        for (int i = 0; i < n; ++i) {
            MarkData markData = this.marks.elementAt(i);
            if (markData.get() == null) continue;
            markVector.addElement(markData);
        }
        this.marks = markVector;
        this.unusedMarks = 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.marks = new MarkVector();
        this.search = new MarkData(0);
        this.queue = new ReferenceQueue();
    }

    protected Vector getPositionsInRange(Vector vector, int n, int n2) {
        int n3;
        int n4;
        int n5 = n + n2;
        int n6 = this.getGapStart();
        int n7 = this.getGapEnd();
        if (n < n6) {
            n4 = n == 0 ? 0 : this.findMarkAdjustIndex(n);
            n3 = n5 >= n6 ? this.findMarkAdjustIndex(n5 + (n7 - n6) + 1) : this.findMarkAdjustIndex(n5 + 1);
        } else {
            n4 = this.findMarkAdjustIndex(n + (n7 - n6));
            n3 = this.findMarkAdjustIndex(n5 + (n7 - n6) + 1);
        }
        Vector vector2 = vector == null ? new Vector(Math.max(1, n3 - n4)) : vector;
        for (int i = n4; i < n3; ++i) {
            vector2.addElement(new UndoPosRef(this.marks.elementAt(i)));
        }
        return vector2;
    }

    protected void updateUndoPositions(Vector vector, int n, int n2) {
        int n3 = n + n2;
        int n4 = this.getGapEnd();
        int n5 = this.findMarkAdjustIndex(n4 + 1);
        int n6 = n != 0 ? this.findMarkAdjustIndex(n4) : 0;
        for (int i = vector.size() - 1; i >= 0; --i) {
            UndoPosRef undoPosRef = (UndoPosRef)vector.elementAt(i);
            undoPosRef.resetLocation(n3, n4);
        }
        if (n6 < n5) {
            Object[] objectArray = new Object[n5 - n6];
            int n7 = 0;
            if (n == 0) {
                MarkData markData;
                int n8;
                for (n8 = n6; n8 < n5; ++n8) {
                    markData = this.marks.elementAt(n8);
                    if (markData.index != 0) continue;
                    objectArray[n7++] = markData;
                }
                for (n8 = n6; n8 < n5; ++n8) {
                    markData = this.marks.elementAt(n8);
                    if (markData.index == 0) continue;
                    objectArray[n7++] = markData;
                }
            } else {
                MarkData markData;
                int n9;
                for (n9 = n6; n9 < n5; ++n9) {
                    markData = this.marks.elementAt(n9);
                    if (markData.index == n4) continue;
                    objectArray[n7++] = markData;
                }
                for (n9 = n6; n9 < n5; ++n9) {
                    markData = this.marks.elementAt(n9);
                    if (markData.index != n4) continue;
                    objectArray[n7++] = markData;
                }
            }
            this.marks.replaceRange(n6, n5, objectArray);
        }
    }

    class RemoveUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected RemoveUndo(int n, String string) {
            this.offset = n;
            this.string = string;
            this.length = string.length();
            this.posRefs = GapContent.this.getPositionsInRange(null, n, this.length);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                GapContent.this.insertString(this.offset, this.string);
                if (this.posRefs != null) {
                    GapContent.this.updateUndoPositions(this.posRefs, this.offset, this.length);
                    this.posRefs = null;
                }
                this.string = null;
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                this.string = GapContent.this.getString(this.offset, this.length);
                this.posRefs = GapContent.this.getPositionsInRange(null, this.offset, this.length);
                GapContent.this.remove(this.offset, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    class InsertUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected InsertUndo(int n, int n2) {
            this.offset = n;
            this.length = n2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.posRefs = GapContent.this.getPositionsInRange(null, this.offset, this.length);
                this.string = GapContent.this.getString(this.offset, this.length);
                GapContent.this.remove(this.offset, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                GapContent.this.insertString(this.offset, this.string);
                this.string = null;
                if (this.posRefs != null) {
                    GapContent.this.updateUndoPositions(this.posRefs, this.offset, this.length);
                    this.posRefs = null;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    final class UndoPosRef {
        protected int undoLocation;
        protected MarkData rec;

        UndoPosRef(MarkData markData) {
            this.rec = markData;
            this.undoLocation = markData.getOffset();
        }

        protected void resetLocation(int n, int n2) {
            this.rec.index = this.undoLocation != n ? this.undoLocation : n2;
        }
    }

    static class MarkVector
    extends GapVector {
        MarkData[] oneMark = new MarkData[1];

        MarkVector() {
        }

        MarkVector(int n) {
            super(n);
        }

        @Override
        protected Object allocateArray(int n) {
            return new MarkData[n];
        }

        @Override
        protected int getArrayLength() {
            MarkData[] markDataArray = (MarkData[])this.getArray();
            return markDataArray.length;
        }

        public int size() {
            int n = this.getArrayLength() - (this.getGapEnd() - this.getGapStart());
            return n;
        }

        public void insertElementAt(MarkData markData, int n) {
            this.oneMark[0] = markData;
            this.replace(n, 0, this.oneMark, 1);
        }

        public void addElement(MarkData markData) {
            this.insertElementAt(markData, this.size());
        }

        public MarkData elementAt(int n) {
            int n2 = this.getGapStart();
            int n3 = this.getGapEnd();
            MarkData[] markDataArray = (MarkData[])this.getArray();
            if (n < n2) {
                return markDataArray[n];
            }
            return markDataArray[n += n3 - n2];
        }

        protected void replaceRange(int n, int n2, Object[] objectArray) {
            int n3 = this.getGapStart();
            int n4 = this.getGapEnd();
            int n5 = n;
            int n6 = 0;
            Object[] objectArray2 = (Object[])this.getArray();
            if (n >= n3) {
                n5 += n4 - n3;
                n2 += n4 - n3;
            } else if (n2 >= n3) {
                n2 += n4 - n3;
                while (n5 < n3) {
                    objectArray2[n5++] = objectArray[n6++];
                }
                n5 = n4;
            } else {
                while (n5 < n2) {
                    objectArray2[n5++] = objectArray[n6++];
                }
            }
            while (n5 < n2) {
                objectArray2[n5++] = objectArray[n6++];
            }
        }
    }

    final class StickyPosition
    implements Position {
        MarkData mark;

        StickyPosition() {
        }

        void setMark(MarkData markData) {
            this.mark = markData;
        }

        @Override
        public final int getOffset() {
            return this.mark.getOffset();
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }
    }

    final class MarkData
    extends WeakReference<StickyPosition> {
        int index;

        MarkData(int n) {
            super(null);
            this.index = n;
        }

        MarkData(int n, StickyPosition stickyPosition, ReferenceQueue<? super StickyPosition> referenceQueue) {
            super(stickyPosition, referenceQueue);
            this.index = n;
        }

        public final int getOffset() {
            int n = GapContent.this.getGapStart();
            int n2 = GapContent.this.getGapEnd();
            int n3 = this.index < n ? this.index : this.index - (n2 - n);
            return Math.max(n3, 0);
        }

        StickyPosition getPosition() {
            return (StickyPosition)this.get();
        }
    }
}

