/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.percolator.PercolateResponse;

@Deprecated
public class MultiPercolateResponse
extends ActionResponse
implements Iterable<Item>,
ToXContent {
    private Item[] items;

    MultiPercolateResponse(Item[] items) {
        this.items = items;
    }

    MultiPercolateResponse() {
        this.items = new Item[0];
    }

    @Override
    public Iterator<Item> iterator() {
        return Arrays.stream(this.items).iterator();
    }

    public Item[] items() {
        return this.items;
    }

    public Item[] getItems() {
        return this.items;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("responses");
        for (Item item : this.items) {
            builder.startObject();
            if (item.isFailure()) {
                ElasticsearchException.renderException((XContentBuilder)builder, (ToXContent.Params)params, (Exception)item.getFailure());
            } else {
                item.getResponse().toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.items.length);
        for (Item item : this.items) {
            item.writeTo(out);
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.items = new Item[size];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new Item();
            this.items[i].readFrom(in);
        }
    }

    static final class Fields {
        static final String RESPONSES = "responses";
        static final String ERROR = "error";

        Fields() {
        }
    }

    public static class Item
    implements Streamable {
        private PercolateResponse response;
        private Exception exception;

        Item(PercolateResponse response) {
            this.response = response;
        }

        Item(Exception exception) {
            this.exception = exception;
        }

        Item() {
        }

        @Nullable
        public PercolateResponse getResponse() {
            return this.response;
        }

        @Nullable
        public String getErrorMessage() {
            return this.exception == null ? null : this.exception.getMessage();
        }

        public boolean isFailure() {
            return this.exception != null;
        }

        public Exception getFailure() {
            return this.exception;
        }

        public void readFrom(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new PercolateResponse();
                this.response.readFrom(in);
            } else {
                this.exception = in.readException();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException((Throwable)this.exception);
            }
        }
    }
}

