/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.StringHelper;

public class XPointValues {
    public static long size(IndexReader reader, String field) throws IOException {
        long size = 0L;
        for (LeafReaderContext ctx : reader.leaves()) {
            FieldInfo info = ctx.reader().getFieldInfos().fieldInfo(field);
            if (info == null || info.getPointDimensionCount() == 0) continue;
            PointValues values = ctx.reader().getPointValues();
            size += values.size(field);
        }
        return size;
    }

    public static int getDocCount(IndexReader reader, String field) throws IOException {
        int count = 0;
        for (LeafReaderContext ctx : reader.leaves()) {
            FieldInfo info = ctx.reader().getFieldInfos().fieldInfo(field);
            if (info == null || info.getPointDimensionCount() == 0) continue;
            PointValues values = ctx.reader().getPointValues();
            count += values.getDocCount(field);
        }
        return count;
    }

    public static byte[] getMinPackedValue(IndexReader reader, String field) throws IOException {
        byte[] minValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values;
            byte[] leafMinValue;
            FieldInfo info = ctx.reader().getFieldInfos().fieldInfo(field);
            if (info == null || info.getPointDimensionCount() == 0 || (leafMinValue = (values = ctx.reader().getPointValues()).getMinPackedValue(field)) == null) continue;
            if (minValue == null) {
                minValue = (byte[])leafMinValue.clone();
                continue;
            }
            int numDimensions = values.getNumDimensions(field);
            int numBytesPerDimension = values.getBytesPerDimension(field);
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (StringHelper.compare((int)numBytesPerDimension, (byte[])leafMinValue, (int)offset, (byte[])minValue, (int)offset) >= 0) continue;
                System.arraycopy(leafMinValue, offset, minValue, offset, numBytesPerDimension);
            }
        }
        return minValue;
    }

    public static byte[] getMaxPackedValue(IndexReader reader, String field) throws IOException {
        byte[] maxValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values;
            byte[] leafMaxValue;
            FieldInfo info = ctx.reader().getFieldInfos().fieldInfo(field);
            if (info == null || info.getPointDimensionCount() == 0 || (leafMaxValue = (values = ctx.reader().getPointValues()).getMaxPackedValue(field)) == null) continue;
            if (maxValue == null) {
                maxValue = (byte[])leafMaxValue.clone();
                continue;
            }
            int numDimensions = values.getNumDimensions(field);
            int numBytesPerDimension = values.getBytesPerDimension(field);
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (StringHelper.compare((int)numBytesPerDimension, (byte[])leafMaxValue, (int)offset, (byte[])maxValue, (int)offset) <= 0) continue;
                System.arraycopy(leafMaxValue, offset, maxValue, offset, numBytesPerDimension);
            }
        }
        return maxValue;
    }

    private XPointValues() {
    }
}

