/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.DocumentRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.single.instance.InstanceShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class UpdateRequest
extends InstanceShardOperationRequest<UpdateRequest>
implements DocumentRequest<UpdateRequest>,
WriteRequest<UpdateRequest> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(UpdateRequest.class));
    private String type;
    private String id;
    @Nullable
    private String routing;
    @Nullable
    private String parent;
    @Nullable
    Script script;
    private String[] fields;
    private FetchSourceContext fetchSourceContext;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private int retryOnConflict = 0;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.NONE;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private IndexRequest upsertRequest;
    private boolean scriptedUpsert = false;
    private boolean docAsUpsert = false;
    private boolean detectNoop = true;
    @Nullable
    private IndexRequest doc;

    public UpdateRequest() {
    }

    public UpdateRequest(String index, String type, String id) {
        super(index);
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (this.versionType != VersionType.INTERNAL && this.versionType != VersionType.FORCE) {
            validationException = ValidateActions.addValidationError("version type [" + this.versionType + "] is not supported by the update API", validationException);
        } else {
            if (this.version != -3L && this.retryOnConflict > 0) {
                validationException = ValidateActions.addValidationError("can't provide both retry_on_conflict and a specific version", validationException);
            }
            if (!this.versionType.validateVersionForWrites(this.version)) {
                validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
            }
        }
        if (this.script == null && this.doc == null) {
            validationException = ValidateActions.addValidationError("script or doc is missing", validationException);
        }
        if (this.script != null && this.doc != null) {
            validationException = ValidateActions.addValidationError("can't provide both script and doc", validationException);
        }
        if (this.doc == null && this.docAsUpsert) {
            validationException = ValidateActions.addValidationError("doc must be specified if doc_as_upsert is enabled", validationException);
        }
        return validationException;
    }

    @Override
    public String type() {
        return this.type;
    }

    public UpdateRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    public UpdateRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public UpdateRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    public UpdateRequest parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public String parent() {
        return this.parent;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Script script() {
        return this.script;
    }

    public UpdateRequest script(Script script) {
        this.script = script;
        return this;
    }

    @Deprecated
    public String scriptString() {
        return this.script == null ? null : this.script.getScript();
    }

    @Deprecated
    public ScriptService.ScriptType scriptType() {
        return this.script == null ? null : this.script.getType();
    }

    @Deprecated
    public Map<String, Object> scriptParams() {
        return this.script == null ? null : this.script.getParams();
    }

    @Deprecated
    public UpdateRequest script(String script, ScriptService.ScriptType scriptType) {
        this.updateOrCreateScript(script, scriptType, null, null);
        return this;
    }

    @Deprecated
    public UpdateRequest script(String script) {
        this.updateOrCreateScript(script, ScriptService.ScriptType.INLINE, null, null);
        return this;
    }

    @Deprecated
    public UpdateRequest scriptLang(String scriptLang) {
        this.updateOrCreateScript(null, null, scriptLang, null);
        return this;
    }

    @Deprecated
    public String scriptLang() {
        return this.script == null ? null : this.script.getLang();
    }

    @Deprecated
    public UpdateRequest addScriptParam(String name, Object value) {
        Script script = this.script();
        if (script == null) {
            HashMap<String, Object> scriptParams = new HashMap<String, Object>();
            scriptParams.put(name, value);
            this.updateOrCreateScript(null, null, null, scriptParams);
        } else {
            Map<String, Object> scriptParams = script.getParams();
            if (scriptParams == null) {
                scriptParams = new HashMap<String, Object>();
                scriptParams.put(name, value);
                this.updateOrCreateScript(null, null, null, scriptParams);
            } else {
                scriptParams.put(name, value);
            }
        }
        return this;
    }

    @Deprecated
    public UpdateRequest scriptParams(Map<String, Object> scriptParams) {
        this.updateOrCreateScript(null, null, null, scriptParams);
        return this;
    }

    private void updateOrCreateScript(String scriptContent, ScriptService.ScriptType type, String lang, Map<String, Object> params) {
        Script script = this.script();
        if (script == null) {
            script = new Script(scriptContent == null ? "" : scriptContent, type == null ? ScriptService.ScriptType.INLINE : type, lang, params);
        } else {
            String newScriptContent = scriptContent == null ? script.getScript() : scriptContent;
            ScriptService.ScriptType newScriptType = type == null ? script.getType() : type;
            String newScriptLang = lang == null ? script.getLang() : lang;
            Map<String, Object> newScriptParams = params == null ? script.getParams() : params;
            script = new Script(newScriptContent, newScriptType, newScriptLang, newScriptParams);
        }
        this.script(script);
    }

    @Deprecated
    public UpdateRequest script(String script, ScriptService.ScriptType scriptType, @Nullable Map<String, Object> scriptParams) {
        this.script = new Script(script, scriptType, null, scriptParams);
        return this;
    }

    @Deprecated
    public UpdateRequest script(String script, @Nullable String scriptLang, ScriptService.ScriptType scriptType, @Nullable Map<String, Object> scriptParams) {
        this.script = new Script(script, scriptType, scriptLang, scriptParams);
        return this;
    }

    @Deprecated
    public UpdateRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public UpdateRequest fetchSource(@Nullable String include, @Nullable String exclude) {
        this.fetchSourceContext = new FetchSourceContext(include, exclude);
        return this;
    }

    public UpdateRequest fetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        this.fetchSourceContext = new FetchSourceContext(includes, excludes);
        return this;
    }

    public UpdateRequest fetchSource(boolean fetchSource) {
        this.fetchSourceContext = new FetchSourceContext(fetchSource);
        return this;
    }

    public UpdateRequest fetchSource(FetchSourceContext context) {
        this.fetchSourceContext = context;
        return this;
    }

    @Deprecated
    public String[] fields() {
        return this.fields;
    }

    public FetchSourceContext fetchSource() {
        return this.fetchSourceContext;
    }

    public UpdateRequest retryOnConflict(int retryOnConflict) {
        this.retryOnConflict = retryOnConflict;
        return this;
    }

    public int retryOnConflict() {
        return this.retryOnConflict;
    }

    public UpdateRequest version(long version) {
        this.version = version;
        return this;
    }

    public long version() {
        return this.version;
    }

    public UpdateRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public UpdateRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public UpdateRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public UpdateRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public UpdateRequest doc(IndexRequest doc) {
        this.doc = doc;
        return this;
    }

    public UpdateRequest doc(XContentBuilder source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(Map source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(Map source, XContentType contentType) {
        this.safeDoc().source(source, contentType);
        return this;
    }

    public UpdateRequest doc(String source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(byte[] source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(byte[] source, int offset, int length) {
        this.safeDoc().source(source, offset, length);
        return this;
    }

    public UpdateRequest doc(Object ... source) {
        this.safeDoc().source(source);
        return this;
    }

    public UpdateRequest doc(String field, Object value) {
        this.safeDoc().source(field, value);
        return this;
    }

    public IndexRequest doc() {
        return this.doc;
    }

    private IndexRequest safeDoc() {
        if (this.doc == null) {
            this.doc = new IndexRequest();
        }
        return this.doc;
    }

    public UpdateRequest upsert(IndexRequest upsertRequest) {
        this.upsertRequest = upsertRequest;
        return this;
    }

    public UpdateRequest upsert(XContentBuilder source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(Map source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(Map source, XContentType contentType) {
        this.safeUpsertRequest().source(source, contentType);
        return this;
    }

    public UpdateRequest upsert(String source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(byte[] source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public UpdateRequest upsert(byte[] source, int offset, int length) {
        this.safeUpsertRequest().source(source, offset, length);
        return this;
    }

    public UpdateRequest upsert(Object ... source) {
        this.safeUpsertRequest().source(source);
        return this;
    }

    public IndexRequest upsertRequest() {
        return this.upsertRequest;
    }

    private IndexRequest safeUpsertRequest() {
        if (this.upsertRequest == null) {
            this.upsertRequest = new IndexRequest();
        }
        return this.upsertRequest;
    }

    public UpdateRequest fromXContent(XContentBuilder source) throws Exception {
        return this.fromXContent(source.bytes());
    }

    public UpdateRequest fromXContent(byte[] source) throws Exception {
        return this.fromXContent(source, 0, source.length);
    }

    public UpdateRequest fromXContent(byte[] source, int offset, int length) throws Exception {
        return this.fromXContent(new BytesArray(source, offset, length));
    }

    public UpdateRequest detectNoop(boolean detectNoop) {
        this.detectNoop = detectNoop;
        return this;
    }

    public boolean detectNoop() {
        return this.detectNoop;
    }

    public UpdateRequest fromXContent(BytesReference source) throws IOException {
        Script script = null;
        try (XContentParser parser = XContentFactory.xContent(source).createParser(source);){
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                UpdateRequest updateRequest = this;
                return updateRequest;
            }
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                XContentType xContentType;
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if ("script".equals(currentFieldName)) {
                    script = Script.parse(parser, ParseFieldMatcher.EMPTY);
                    continue;
                }
                if ("scripted_upsert".equals(currentFieldName)) {
                    this.scriptedUpsert = parser.booleanValue();
                    continue;
                }
                if ("upsert".equals(currentFieldName)) {
                    xContentType = XContentFactory.xContentType(source);
                    XContentBuilder builder = XContentFactory.contentBuilder(xContentType);
                    builder.copyCurrentStructure(parser);
                    this.safeUpsertRequest().source(builder);
                    continue;
                }
                if ("doc".equals(currentFieldName)) {
                    xContentType = XContentFactory.xContentType(source);
                    XContentBuilder docBuilder = XContentFactory.contentBuilder(xContentType);
                    docBuilder.copyCurrentStructure(parser);
                    this.safeDoc().source(docBuilder);
                    continue;
                }
                if ("doc_as_upsert".equals(currentFieldName)) {
                    this.docAsUpsert(parser.booleanValue());
                    continue;
                }
                if ("detect_noop".equals(currentFieldName)) {
                    this.detectNoop(parser.booleanValue());
                    continue;
                }
                if ("fields".equals(currentFieldName)) {
                    List<Object> fields = null;
                    if (token == XContentParser.Token.START_ARRAY) {
                        fields = parser.list();
                    } else if (token.isValue()) {
                        fields = Collections.singletonList(parser.text());
                    }
                    if (fields == null) continue;
                    this.fields(fields.toArray(new String[fields.size()]));
                    continue;
                }
                if (!"_source".equals(currentFieldName)) continue;
                this.fetchSourceContext = FetchSourceContext.parse(parser);
            }
            if (script != null) {
                this.script = script;
            }
        }
        return this;
    }

    public boolean docAsUpsert() {
        return this.docAsUpsert;
    }

    public UpdateRequest docAsUpsert(boolean shouldUpsertDoc) {
        this.docAsUpsert = shouldUpsertDoc;
        return this;
    }

    public boolean scriptedUpsert() {
        return this.scriptedUpsert;
    }

    public UpdateRequest scriptedUpsert(boolean scriptedUpsert) {
        this.scriptedUpsert = scriptedUpsert;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.parent = in.readOptionalString();
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        this.retryOnConflict = in.readVInt();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
        if (in.readBoolean()) {
            this.doc = new IndexRequest();
            this.doc.readFrom(in);
        }
        this.fields = in.readOptionalStringArray();
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::new);
        if (in.readBoolean()) {
            this.upsertRequest = new IndexRequest();
            this.upsertRequest.readFrom(in);
        }
        this.docAsUpsert = in.readBoolean();
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
        this.detectNoop = in.readBoolean();
        this.scriptedUpsert = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.waitForActiveShards.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.parent);
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        out.writeVInt(this.retryOnConflict);
        this.refreshPolicy.writeTo(out);
        if (this.doc == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.doc.index(this.index);
            this.doc.type(this.type);
            this.doc.id(this.id);
            this.doc.writeTo(out);
        }
        out.writeOptionalStringArray(this.fields);
        out.writeOptionalWriteable(this.fetchSourceContext);
        if (this.upsertRequest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.upsertRequest.index(this.index);
            this.upsertRequest.type(this.type);
            this.upsertRequest.id(this.id);
            this.upsertRequest.writeTo(out);
        }
        out.writeBoolean(this.docAsUpsert);
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
        out.writeBoolean(this.detectNoop);
        out.writeBoolean(this.scriptedUpsert);
    }
}

