/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.derivative;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.derivative.Derivative;

public class InternalDerivative
extends InternalSimpleValue
implements Derivative {
    private final double normalizationFactor;

    public InternalDerivative(String name, double value, double normalizationFactor, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, value, formatter, pipelineAggregators, metaData);
        this.normalizationFactor = normalizationFactor;
    }

    public InternalDerivative(StreamInput in) throws IOException {
        super(in);
        this.normalizationFactor = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeDouble(this.normalizationFactor);
    }

    @Override
    public String getWriteableName() {
        return "derivative";
    }

    @Override
    public double normalizedValue() {
        return this.normalizationFactor > 0.0 ? this.value() / this.normalizationFactor : this.value();
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.value();
        }
        if (path.size() == 1 && "normalized_value".equals(path.get(0))) {
            return this.normalizedValue();
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, params);
        if (this.normalizationFactor > 0.0) {
            boolean hasValue = !Double.isInfinite(this.normalizedValue()) && !Double.isNaN(this.normalizedValue());
            builder.field("normalized_value", hasValue ? Double.valueOf(this.normalizedValue()) : null);
            if (hasValue && this.format != DocValueFormat.RAW) {
                builder.field("normalized_value_as_string", this.format.format(this.normalizedValue()));
            }
        }
        return builder;
    }
}

