/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestRequest;

public class FetchSourceContext
implements Writeable,
ToXContent {
    public static final ParseField INCLUDES_FIELD = new ParseField("includes", "include");
    public static final ParseField EXCLUDES_FIELD = new ParseField("excludes", "exclude");
    public static final FetchSourceContext FETCH_SOURCE = new FetchSourceContext(true);
    public static final FetchSourceContext DO_NOT_FETCH_SOURCE = new FetchSourceContext(false);
    private boolean fetchSource;
    private String[] includes;
    private String[] excludes;

    public static FetchSourceContext parse(XContentParser parser) throws IOException {
        FetchSourceContext fetchSourceContext = new FetchSourceContext();
        fetchSourceContext.fromXContent(parser, ParseFieldMatcher.STRICT);
        return fetchSourceContext;
    }

    public FetchSourceContext() {
    }

    public FetchSourceContext(boolean fetchSource) {
        this(fetchSource, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
    }

    public FetchSourceContext(String include) {
        this(include, null);
    }

    public FetchSourceContext(String include, String exclude) {
        String[] stringArray;
        String[] stringArray2;
        if (include == null) {
            stringArray2 = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = include;
        }
        if (exclude == null) {
            stringArray = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = exclude;
        }
        this(true, stringArray2, stringArray);
    }

    public FetchSourceContext(String[] includes) {
        this(true, includes, Strings.EMPTY_ARRAY);
    }

    public FetchSourceContext(String[] includes, String[] excludes) {
        this(true, includes, excludes);
    }

    public FetchSourceContext(boolean fetchSource, String[] includes, String[] excludes) {
        this.fetchSource = fetchSource;
        this.includes = includes == null ? Strings.EMPTY_ARRAY : includes;
        this.excludes = excludes == null ? Strings.EMPTY_ARRAY : excludes;
    }

    public FetchSourceContext(StreamInput in) throws IOException {
        this.fetchSource = in.readBoolean();
        this.includes = in.readStringArray();
        this.excludes = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.fetchSource);
        out.writeStringArray(this.includes);
        out.writeStringArray(this.excludes);
    }

    public boolean fetchSource() {
        return this.fetchSource;
    }

    public FetchSourceContext fetchSource(boolean fetchSource) {
        this.fetchSource = fetchSource;
        return this;
    }

    public String[] includes() {
        return this.includes;
    }

    public FetchSourceContext includes(String[] includes) {
        this.includes = includes;
        return this;
    }

    public String[] excludes() {
        return this.excludes;
    }

    public FetchSourceContext excludes(String[] excludes) {
        this.excludes = excludes;
        return this;
    }

    public static FetchSourceContext parseFromRestRequest(RestRequest request) {
        Boolean fetchSource = null;
        String[] source_excludes = null;
        String[] source_includes = null;
        String source = request.param("_source");
        if (source != null) {
            if (Booleans.isExplicitTrue(source)) {
                fetchSource = true;
            } else if (Booleans.isExplicitFalse(source)) {
                fetchSource = false;
            } else {
                source_includes = Strings.splitStringByCommaToArray(source);
            }
        }
        String sIncludes = request.param("_source_includes");
        if ((sIncludes = request.param("_source_include", sIncludes)) != null) {
            source_includes = Strings.splitStringByCommaToArray(sIncludes);
        }
        String sExcludes = request.param("_source_excludes");
        if ((sExcludes = request.param("_source_exclude", sExcludes)) != null) {
            source_excludes = Strings.splitStringByCommaToArray(sExcludes);
        }
        if (fetchSource != null || source_includes != null || source_excludes != null) {
            return new FetchSourceContext(fetchSource == null ? true : fetchSource, source_includes, source_excludes);
        }
        return null;
    }

    public void fromXContent(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        XContentParser.Token token = parser.currentToken();
        boolean fetchSource = true;
        String[] includes = Strings.EMPTY_ARRAY;
        String[] excludes = Strings.EMPTY_ARRAY;
        if (token == XContentParser.Token.VALUE_BOOLEAN) {
            fetchSource = parser.booleanValue();
        } else if (token == XContentParser.Token.VALUE_STRING) {
            includes = new String[]{parser.text()};
        } else if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<String> list = new ArrayList<String>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                list.add(parser.text());
            }
            includes = list.toArray(new String[list.size()]);
        } else if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (parseFieldMatcher.match(currentFieldName, INCLUDES_FIELD)) {
                        ArrayList<String> includesList = new ArrayList<String>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                includesList.add(parser.text());
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                        }
                        includes = includesList.toArray(new String[includesList.size()]);
                        continue;
                    }
                    if (parseFieldMatcher.match(currentFieldName, EXCLUDES_FIELD)) {
                        ArrayList<String> excludesList = new ArrayList<String>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                excludesList.add(parser.text());
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                        }
                        excludes = excludesList.toArray(new String[excludesList.size()]);
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if (parseFieldMatcher.match(currentFieldName, INCLUDES_FIELD)) {
                        includes = new String[]{parser.text()};
                        continue;
                    }
                    if (parseFieldMatcher.match(currentFieldName, EXCLUDES_FIELD)) {
                        excludes = new String[]{parser.text()};
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
            }
        } else {
            throw new ParsingException(parser.getTokenLocation(), "Expected one of [" + (Object)((Object)XContentParser.Token.VALUE_BOOLEAN) + ", " + (Object)((Object)XContentParser.Token.START_OBJECT) + "] but found [" + (Object)((Object)token) + "]", parser.getTokenLocation());
        }
        this.fetchSource = fetchSource;
        this.includes = includes;
        this.excludes = excludes;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fetchSource) {
            builder.startObject();
            builder.array(INCLUDES_FIELD.getPreferredName(), this.includes);
            builder.array(EXCLUDES_FIELD.getPreferredName(), this.excludes);
            builder.endObject();
        } else {
            builder.value(false);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchSourceContext that = (FetchSourceContext)o;
        if (this.fetchSource != that.fetchSource) {
            return false;
        }
        if (!Arrays.equals(this.excludes, that.excludes)) {
            return false;
        }
        return Arrays.equals(this.includes, that.includes);
    }

    public int hashCode() {
        int result = this.fetchSource ? 1 : 0;
        result = 31 * result + (this.includes != null ? Arrays.hashCode(this.includes) : 0);
        result = 31 * result + (this.excludes != null ? Arrays.hashCode(this.excludes) : 0);
        return result;
    }
}

