/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.antlr;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.Pair;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.antlr.PainlessLexer;

final class EnhancedPainlessLexer
extends PainlessLexer {
    final String sourceName;
    private Token stashedNext = null;
    private Token previous = null;

    EnhancedPainlessLexer(CharStream charStream, String sourceName) {
        super(charStream);
        this.sourceName = sourceName;
    }

    public Token getPreviousToken() {
        return this.previous;
    }

    public Token nextToken() {
        if (this.stashedNext != null) {
            this.previous = this.stashedNext;
            this.stashedNext = null;
            return this.previous;
        }
        Token next = super.nextToken();
        if (EnhancedPainlessLexer.insertSemicolon(this.previous, next)) {
            this.stashedNext = next;
            this.previous = this._factory.create(new Pair((Object)this, (Object)this._input), 11, ";", 0, next.getStartIndex(), next.getStopIndex(), next.getLine(), next.getCharPositionInLine());
            return this.previous;
        }
        this.previous = next;
        return next;
    }

    public void recover(LexerNoViableAltException lnvae) {
        CharStream charStream = lnvae.getInputStream();
        int startIndex = lnvae.getStartIndex();
        String text = charStream.getText(Interval.of((int)startIndex, (int)charStream.index()));
        Location location = new Location(this.sourceName, this._tokenStartCharIndex);
        throw location.createError(new IllegalArgumentException("unexpected character [" + this.getErrorDisplay(text) + "].", (Throwable)lnvae));
    }

    private static boolean insertSemicolon(Token previous, Token next) {
        if (previous == null || next.getType() != 4) {
            return false;
        }
        switch (previous.getType()) {
            case 3: 
            case 4: 
            case 11: {
                return false;
            }
        }
        return true;
    }
}

