/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.StringUtils;

public class Building
extends WorkLocation
implements Named,
Consumer {
    private static final Logger logger = Logger.getLogger(Building.class.getName());
    public static final String UNIT_CHANGE = "UNIT_CHANGE";
    protected BuildingType buildingType;
    private static final String BUILDING_TYPE_TAG = "buildingType";

    protected Building(Game game, Colony colony, BuildingType type) {
        super(game);
        this.colony = colony;
        this.buildingType = type;
        this.updateProductionType();
    }

    public Building(Game game, String id) {
        super(game, id);
    }

    public BuildingType getType() {
        return this.buildingType;
    }

    private List<Unit> setType(BuildingType newBuildingType) {
        Colony colony = this.getColony();
        colony.removeFeatures(this.buildingType);
        ArrayList<Unit> eject = new ArrayList<Unit>();
        if (newBuildingType != null) {
            this.buildingType = newBuildingType;
            this.updateProductionType();
            colony.addFeatures(this.buildingType);
            for (Unit unit : this.getUnitList()) {
                if (this.canAddType(unit.getType())) continue;
                eject.add(unit);
            }
        }
        int extra = this.getUnitCount() - this.getUnitCapacity() - eject.size();
        for (Unit unit : this.getUnitList()) {
            if (extra <= 0) break;
            if (eject.contains(unit)) continue;
            eject.add(unit);
            --extra;
        }
        return eject;
    }

    public int getLevel() {
        return this.getType().getLevel();
    }

    public boolean canBuildNext() {
        return this.getColony().canBuild(this.getType().getUpgradesTo());
    }

    public boolean canBeDamaged() {
        return !this.getType().isAutomaticBuild() && !this.getColony().isAutomaticBuild(this.getType());
    }

    public List<Unit> downgrade() {
        if (!this.canBeDamaged()) {
            return null;
        }
        List<Unit> ret = this.setType(this.getType().getUpgradesFrom());
        this.getColony().invalidateCache();
        return ret;
    }

    public List<Unit> upgrade() {
        if (!this.canBuildNext()) {
            return null;
        }
        List<Unit> ret = this.setType(this.getType().getUpgradesTo());
        this.getColony().invalidateCache();
        return ret;
    }

    public boolean canAddType(UnitType unitType) {
        return this.canBeWorked() && this.getType().canAdd(unitType);
    }

    private int getAvailable(GoodsType type, List<AbstractGoods> available) {
        return AbstractGoods.getCount(type, available);
    }

    public ProductionInfo getAdjustedProductionInfo(List<AbstractGoods> inputs, List<AbstractGoods> outputs) {
        GoodsType goodsType;
        ProductionInfo result = new ProductionInfo();
        if (!this.hasOutputs()) {
            return result;
        }
        Specification spec = this.getSpecification();
        Turn turn = this.getGame().getTurn();
        boolean avoidOverflow = this.hasAbility("model.ability.avoidExcessProduction");
        int capacity = this.getColony().getWarehouseCapacity();
        double maximumRatio = 0.0;
        double minimumRatio = Double.MAX_VALUE;
        if (this.canAutoProduce()) {
            for (AbstractGoods output : this.getOutputs()) {
                if (output.getAmount() <= 0) continue;
                goodsType = output.getType();
                int available = this.getColony().getGoodsCount(goodsType);
                if (available >= capacity) {
                    maximumRatio = 0.0;
                    minimumRatio = 0.0;
                    continue;
                }
                int divisor = (int)this.getType().applyModifiers(0.0f, turn, "model.modifier.breedingDivisor");
                int factor = (int)this.getType().applyModifiers(0.0f, turn, "model.modifier.breedingFactor");
                int production = available < goodsType.getBreedingNumber() || divisor <= 0 ? 0 : ((available - 1) / divisor + 1) * factor;
                double newRatio = (double)production / (double)output.getAmount();
                minimumRatio = Math.min(minimumRatio, newRatio);
                maximumRatio = Math.max(maximumRatio, newRatio);
            }
        } else {
            for (AbstractGoods output : this.getOutputs()) {
                goodsType = output.getType();
                float production = this.getUnitList().stream().mapToInt(u -> this.getUnitProduction((Unit)u, goodsType)).sum();
                production += (float)this.getBaseProduction(null, goodsType, null);
                production = Building.applyModifiers(production, turn, this.getProductionModifiers(goodsType, null));
                production = (int)Math.floor(production);
                double newRatio = production / (float)output.getAmount();
                minimumRatio = Math.min(minimumRatio, newRatio);
                maximumRatio = Math.max(maximumRatio, newRatio);
            }
        }
        for (AbstractGoods input : this.getInputs()) {
            long minimumGoodsInput;
            long required = (long)Math.floor((double)input.getAmount() * minimumRatio);
            long available = this.getAvailable(input.getType(), inputs);
            if (this.canAutoProduce()) {
                available = Math.max(0L, available);
            }
            if (available < required && this.hasAbility("model.ability.expertsUseConnections") && spec.getBoolean("model.option.expertsHaveConnections") && (minimumGoodsInput = (long)(4 * (int)this.getUnitList().stream().filter(u -> u.getType() == this.getExpertUnitType()).count())) > available) {
                available = minimumGoodsInput;
            }
            if (available >= required) continue;
            minimumRatio *= (double)available / (double)required;
        }
        if (avoidOverflow) {
            for (AbstractGoods output : this.getOutputs()) {
                double production = (double)output.getAmount() * minimumRatio;
                if (production <= 0.0) continue;
                double headroom = (double)capacity - (double)this.getAvailable(output.getType(), outputs);
                if (production > headroom) {
                    minimumRatio = Math.min(minimumRatio, headroom / (double)output.getAmount());
                }
                if (!((production = (double)output.getAmount() * maximumRatio) > headroom)) continue;
                maximumRatio = Math.min(maximumRatio, headroom / (double)output.getAmount());
            }
        }
        double epsilon = 1.0E-4;
        for (AbstractGoods input : this.getInputs()) {
            GoodsType type = input.getType();
            int consumption = (int)Math.floor((double)input.getAmount() * minimumRatio + 1.0E-4);
            int maximumConsumption = (int)Math.floor((double)input.getAmount() * maximumRatio);
            result.addConsumption(new AbstractGoods(type, consumption));
            if (consumption >= maximumConsumption) continue;
            result.addMaximumConsumption(new AbstractGoods(type, maximumConsumption));
        }
        for (AbstractGoods output : this.getOutputs()) {
            GoodsType type = output.getType();
            int production = (int)Math.floor((double)output.getAmount() * minimumRatio + 1.0E-4);
            int maximumProduction = (int)Math.floor((double)output.getAmount() * maximumRatio);
            result.addProduction(new AbstractGoods(type, production));
            if (production >= maximumProduction) continue;
            result.addMaximumProduction(new AbstractGoods(type, maximumProduction));
        }
        return result;
    }

    @Override
    public int evaluateFor(Player player) {
        return super.evaluateFor(player) + this.getType().getRequiredGoods().stream().mapToInt(ag -> ag.evaluateFor(player)).sum();
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.template("model.building.locationLabel").addNamed("%location%", this);
    }

    @Override
    public Location up() {
        return this.getColony();
    }

    @Override
    public String toShortString() {
        return this.getColony().getName() + "-" + this.getType().getSuffix();
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        UnitLocation.NoAddReason reason = super.getNoAddReason(locatable);
        if (reason == UnitLocation.NoAddReason.NONE && (reason = this.getType().getNoAddReason(((Unit)locatable).getType())) == UnitLocation.NoAddReason.NONE) {
            reason = this.getNoWorkReason();
        }
        return reason;
    }

    @Override
    public int getUnitCapacity() {
        return this.getType().getWorkPlaces();
    }

    @Override
    public StringTemplate getLabel() {
        return this.buildingType == null ? null : StringTemplate.key(this.buildingType);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isCurrent() {
        return true;
    }

    @Override
    public UnitLocation.NoAddReason getNoWorkReason() {
        return UnitLocation.NoAddReason.NONE;
    }

    @Override
    public boolean canAutoProduce() {
        return this.hasAbility("model.ability.autoProduction");
    }

    @Override
    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        BuildingType type = this.getType();
        return type != null && type.canProduce(goodsType, unitType);
    }

    @Override
    public int getBaseProduction(ProductionType productionType, GoodsType goodsType, UnitType unitType) {
        BuildingType type = this.getType();
        return type == null ? 0 : this.getType().getBaseProduction(productionType, goodsType, unitType);
    }

    @Override
    public List<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        BuildingType type = this.getType();
        String id = goodsType == null ? null : goodsType.getId();
        Colony colony = this.getColony();
        Player owner = this.getOwner();
        Turn turn = this.getGame().getTurn();
        ArrayList<Modifier> mods = new ArrayList<Modifier>();
        if (unitType == null) {
            mods.addAll(colony.getModifiers(id, type, turn));
            if (owner != null) {
                mods.addAll(owner.getModifiers(id, type, turn));
            }
        } else {
            mods.addAll(this.getModifiers(id, unitType, turn));
            mods.addAll(colony.getProductionModifiers(goodsType));
            mods.addAll(unitType.getModifiers(id, goodsType, turn));
            if (owner != null) {
                mods.addAll(owner.getModifiers(id, unitType, turn));
            }
        }
        Collections.sort(mods);
        return mods;
    }

    @Override
    public List<ProductionType> getAvailableProductionTypes(boolean unattended) {
        return this.buildingType == null ? Collections.emptyList() : this.getType().getAvailableProductionTypes(unattended);
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        return this.getInputs();
    }

    @Override
    public int getPriority() {
        return this.getType().getPriority();
    }

    @Override
    public String getNameKey() {
        return this.getType().getNameKey();
    }

    @Override
    public Set<Ability> getAbilities(String id, FreeColGameObjectType type, Turn turn) {
        return this.getType().getAbilities(id, type, turn);
    }

    @Override
    public Set<Modifier> getModifiers(String id, FreeColGameObjectType fcgot, Turn turn) {
        return this.getType().getModifiers(id, fcgot, turn);
    }

    @Override
    public int compareTo(FreeColObject other) {
        int cmp = 0;
        if (other instanceof Building) {
            Building building = (Building)other;
            cmp = this.getType().compareTo(building.getType());
        }
        if (cmp == 0) {
            cmp = super.compareTo(other);
        }
        return cmp;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(BUILDING_TYPE_TAG, this.buildingType);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.buildingType = xr.getType(spec, BUILDING_TYPE_TAG, BuildingType.class, null);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.getId()).append(" ").append(this.buildingType == null ? "" : StringUtils.lastPart(this.buildingType.getId(), ".")).append("/").append(this.getColony().getName()).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return Building.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "building";
    }
}

