/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.FilteredCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDomainObjectCollection<T>
extends AbstractCollection<T>
implements DomainObjectCollection<T> {
    private final Class<? extends T> type;
    private final CollectionEventRegister<T> eventRegister;
    private final Collection<T> store;
    private final Set<Runnable> mutateActions = new LinkedHashSet<Runnable>();

    public DefaultDomainObjectCollection(Class<? extends T> type, Collection<T> store) {
        this(type, store, new CollectionEventRegister());
    }

    protected DefaultDomainObjectCollection(Class<? extends T> type, Collection<T> store, CollectionEventRegister<T> eventRegister) {
        this.type = type;
        this.store = store;
        this.eventRegister = eventRegister;
    }

    protected DefaultDomainObjectCollection(DefaultDomainObjectCollection<? super T> collection, CollectionFilter<T> filter) {
        this(filter.getType(), collection.filteredStore(filter), collection.filteredEvents(filter));
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    protected Collection<T> getStore() {
        return this.store;
    }

    protected CollectionEventRegister<T> getEventRegister() {
        return this.eventRegister;
    }

    protected CollectionFilter<T> createFilter(Spec<? super T> filter) {
        return this.createFilter(this.getType(), filter);
    }

    protected <S extends T> CollectionFilter<S> createFilter(Class<S> type) {
        return new CollectionFilter<S>(type);
    }

    protected <S extends T> CollectionFilter<S> createFilter(Class<? extends S> type, Spec<? super S> spec) {
        return new CollectionFilter<S>(type, spec);
    }

    protected <S extends T> DefaultDomainObjectCollection<S> filtered(CollectionFilter<S> filter) {
        return new DefaultDomainObjectCollection<S>(this, filter);
    }

    protected <S extends T> Collection<S> filteredStore(CollectionFilter<S> filter) {
        return new FilteredCollection(this, filter);
    }

    protected <S extends T> CollectionEventRegister<S> filteredEvents(CollectionFilter<S> filter) {
        return this.getEventRegister().filtered(filter);
    }

    @Override
    public DomainObjectCollection<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    @Override
    public DomainObjectCollection<T> matching(Closure spec) {
        return this.matching(Specs.convertClosureToSpec((Closure)spec));
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type) {
        return this.filtered(this.createFilter(type));
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl(this.getStore().iterator());
    }

    @Override
    public void all(Action<? super T> action) {
        action = this.whenObjectAdded(action);
        LinkedList copied = new LinkedList(this);
        for (Object t : copied) {
            action.execute(t);
        }
    }

    @Override
    public void all(Closure action) {
        this.all(this.toAction(action));
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Action<? super S> configureAction) {
        DomainObjectCollection<S> result = this.withType(type);
        result.all(configureAction);
        return result;
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Closure configureClosure) {
        DomainObjectCollection<S> result = this.withType(type);
        result.all(configureClosure);
        return result;
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return this.eventRegister.registerAddAction(action);
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return this.eventRegister.registerRemoveAction(action);
    }

    @Override
    public void whenObjectAdded(Closure action) {
        this.whenObjectAdded(this.toAction(action));
    }

    @Override
    public void whenObjectRemoved(Closure action) {
        this.whenObjectRemoved(this.toAction(action));
    }

    public void beforeChange(Runnable action) {
        this.mutateActions.add(action);
    }

    private Action<? super T> toAction(Closure action) {
        return ConfigureUtil.configureUsing(action);
    }

    @Override
    public boolean add(T toAdd) {
        this.assertMutable();
        return this.doAdd(toAdd);
    }

    private boolean doAdd(T toAdd) {
        if (this.getStore().add(toAdd)) {
            this.didAdd(toAdd);
            this.eventRegister.getAddAction().execute(toAdd);
            return true;
        }
        return false;
    }

    protected void didAdd(T toAdd) {
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.assertMutable();
        boolean changed = false;
        for (T o : c) {
            if (!this.doAdd(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.assertMutable();
        Object[] c = this.toArray();
        this.getStore().clear();
        for (Object o : c) {
            this.eventRegister.getRemoveAction().execute(o);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.getStore().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getStore().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.getStore().isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.assertMutable();
        return this.doRemove(o);
    }

    private boolean doRemove(Object o) {
        if (this.getStore().remove(o)) {
            Object cast = o;
            this.didRemove(cast);
            this.eventRegister.getRemoveAction().execute(cast);
            return true;
        }
        return false;
    }

    protected void didRemove(T t) {
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.assertMutable();
        boolean changed = false;
        for (Object o : c) {
            if (!this.doRemove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> target) {
        this.assertMutable();
        Object[] existingItems = this.toArray();
        boolean changed = false;
        for (Object existingItem : existingItems) {
            if (target.contains(existingItem)) continue;
            this.doRemove(existingItem);
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.getStore().size();
    }

    @Override
    public Collection<T> findAll(Closure cl) {
        return this.findAll(cl, new ArrayList());
    }

    protected <S extends Collection<? super T>> S findAll(Closure cl, S matches) {
        for (T t : this.filteredStore(this.createFilter(Specs.convertClosureToSpec((Closure)cl)))) {
            matches.add(t);
        }
        return matches;
    }

    protected void assertMutable() {
        for (Runnable action : this.mutateActions) {
            action.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private T currentElement;

        public IteratorImpl(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.currentElement = this.iterator.next();
            return this.currentElement;
        }

        @Override
        public void remove() {
            DefaultDomainObjectCollection.this.assertMutable();
            this.iterator.remove();
            DefaultDomainObjectCollection.this.didRemove(this.currentElement);
            DefaultDomainObjectCollection.this.getEventRegister().getRemoveAction().execute(this.currentElement);
            this.currentElement = null;
        }
    }
}

