/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class HiddenFieldCheck
extends Check {
    private LinkedList mFieldsStack = null;

    public int[] getDefaultTokens() {
        return new int[]{10, 21, 14};
    }

    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    public int[] getRequiredTokens() {
        return new int[]{14};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mFieldsStack = new LinkedList();
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 14) {
            HashSet<String> fieldSet = new HashSet<String>();
            DetailAST objBlock = aAST.findFirstToken(6);
            DetailAST child = (DetailAST)objBlock.getFirstChild();
            while (child != null) {
                if (child.getType() == 10) {
                    String name = child.findFirstToken(58).getText();
                    fieldSet.add(name);
                }
                child = (DetailAST)child.getNextSibling();
            }
            this.mFieldsStack.addLast(fieldSet);
        } else {
            this.processVariable(aAST);
        }
    }

    public void leaveToken(DetailAST aAST) {
        if (aAST.getType() == 14) {
            this.mFieldsStack.removeLast();
        }
    }

    private void processVariable(DetailAST aAST) {
        if (!ScopeUtils.inInterfaceBlock(aAST) && ScopeUtils.inCodeBlock(aAST)) {
            DetailAST nameAST = aAST.findFirstToken(58);
            String name = nameAST.getText();
            Iterator it = this.mFieldsStack.iterator();
            while (it.hasNext()) {
                HashSet aFieldsSet = (HashSet)it.next();
                if (!aFieldsSet.contains(name)) continue;
                this.log(nameAST.getLineNo(), nameAST.getColumnNo(), "hidden.field", (Object)name);
                break;
            }
        }
    }
}

