/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.FromXContentBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.MetaDataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class IndexMetaData
implements Diffable<IndexMetaData>,
FromXContentBuilder<IndexMetaData>,
ToXContent {
    public static Map<String, Custom> customPrototypes = new HashMap<String, Custom>();
    public static final ClusterBlock INDEX_READ_ONLY_BLOCK = new ClusterBlock(5, "index read-only (api)", false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock INDEX_READ_BLOCK = new ClusterBlock(7, "index read (api)", false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.READ));
    public static final ClusterBlock INDEX_WRITE_BLOCK = new ClusterBlock(8, "index write (api)", false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
    public static final ClusterBlock INDEX_METADATA_BLOCK = new ClusterBlock(9, "index metadata (api)", false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.METADATA_READ));
    public static final String INDEX_SETTING_PREFIX = "index.";
    public static final String SETTING_NUMBER_OF_SHARDS = "index.number_of_shards";
    public static final Setting<Integer> INDEX_NUMBER_OF_SHARDS_SETTING = IndexMetaData.buildNumberOfShardsSetting();
    public static final String SETTING_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final Setting<Integer> INDEX_NUMBER_OF_REPLICAS_SETTING = Setting.intSetting("index.number_of_replicas", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_SHADOW_REPLICAS = "index.shadow_replicas";
    public static final Setting<Boolean> INDEX_SHADOW_REPLICAS_SETTING = Setting.boolSetting("index.shadow_replicas", false, Setting.Property.IndexScope);
    public static final String SETTING_SHARED_FILESYSTEM = "index.shared_filesystem";
    public static final Setting<Boolean> INDEX_SHARED_FILESYSTEM_SETTING = Setting.boolSetting("index.shared_filesystem", false, Setting.Property.IndexScope);
    public static final String SETTING_AUTO_EXPAND_REPLICAS = "index.auto_expand_replicas";
    public static final Setting<AutoExpandReplicas> INDEX_AUTO_EXPAND_REPLICAS_SETTING = AutoExpandReplicas.SETTING;
    public static final String SETTING_READ_ONLY = "index.blocks.read_only";
    public static final Setting<Boolean> INDEX_READ_ONLY_SETTING = Setting.boolSetting("index.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_BLOCKS_READ = "index.blocks.read";
    public static final Setting<Boolean> INDEX_BLOCKS_READ_SETTING = Setting.boolSetting("index.blocks.read", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_BLOCKS_WRITE = "index.blocks.write";
    public static final Setting<Boolean> INDEX_BLOCKS_WRITE_SETTING = Setting.boolSetting("index.blocks.write", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_BLOCKS_METADATA = "index.blocks.metadata";
    public static final Setting<Boolean> INDEX_BLOCKS_METADATA_SETTING = Setting.boolSetting("index.blocks.metadata", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_VERSION_CREATED = "index.version.created";
    public static final String SETTING_VERSION_CREATED_STRING = "index.version.created_string";
    public static final String SETTING_VERSION_UPGRADED = "index.version.upgraded";
    public static final String SETTING_VERSION_UPGRADED_STRING = "index.version.upgraded_string";
    public static final String SETTING_VERSION_MINIMUM_COMPATIBLE = "index.version.minimum_compatible";
    public static final String SETTING_CREATION_DATE = "index.creation_date";
    public static final String SETTING_INDEX_PROVIDED_NAME = "index.provided_name";
    public static final String SETTING_PRIORITY = "index.priority";
    public static final Setting<Integer> INDEX_PRIORITY_SETTING = Setting.intSetting("index.priority", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_CREATION_DATE_STRING = "index.creation_date_string";
    public static final String SETTING_INDEX_UUID = "index.uuid";
    public static final String SETTING_DATA_PATH = "index.data_path";
    public static final Setting<String> INDEX_DATA_PATH_SETTING = new Setting("index.data_path", "", Function.identity(), Setting.Property.IndexScope);
    public static final String SETTING_SHARED_FS_ALLOW_RECOVERY_ON_ANY_NODE = "index.shared_filesystem.recover_on_any_node";
    public static final Setting<Boolean> INDEX_SHARED_FS_ALLOW_RECOVERY_ON_ANY_NODE_SETTING = Setting.boolSetting("index.shared_filesystem.recover_on_any_node", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String INDEX_UUID_NA_VALUE = "_na_";
    public static final Setting<Settings> INDEX_ROUTING_REQUIRE_GROUP_SETTING = Setting.groupSetting("index.routing.allocation.require.", Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Settings> INDEX_ROUTING_INCLUDE_GROUP_SETTING = Setting.groupSetting("index.routing.allocation.include.", Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Settings> INDEX_ROUTING_EXCLUDE_GROUP_SETTING = Setting.groupSetting("index.routing.allocation.exclude.", Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Settings> INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING = Setting.groupSetting("index.routing.allocation.initial_recovery.", new Setting.Property[0]);
    public static final Setting<ActiveShardCount> SETTING_WAIT_FOR_ACTIVE_SHARDS = new Setting<ActiveShardCount>("index.write.wait_for_active_shards", "1", ActiveShardCount::parseString, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final IndexMetaData PROTO = IndexMetaData.builder("").settings(Settings.builder().put("index.version.created", Version.CURRENT)).numberOfShards(1).numberOfReplicas(0).build();
    public static final String KEY_IN_SYNC_ALLOCATIONS = "in_sync_allocations";
    static final String KEY_VERSION = "version";
    static final String KEY_ROUTING_NUM_SHARDS = "routing_num_shards";
    static final String KEY_SETTINGS = "settings";
    static final String KEY_STATE = "state";
    static final String KEY_MAPPINGS = "mappings";
    static final String KEY_ALIASES = "aliases";
    public static final String KEY_PRIMARY_TERMS = "primary_terms";
    public static final String INDEX_STATE_FILE_PREFIX = "state-";
    private final int routingNumShards;
    private final int routingFactor;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private final Index index;
    private final long version;
    private final long[] primaryTerms;
    private final State state;
    private final ImmutableOpenMap<String, AliasMetaData> aliases;
    private final Settings settings;
    private final ImmutableOpenMap<String, MappingMetaData> mappings;
    private final ImmutableOpenMap<String, Custom> customs;
    private final ImmutableOpenIntMap<Set<String>> inSyncAllocationIds;
    private final transient int totalNumberOfShards;
    private final DiscoveryNodeFilters requireFilters;
    private final DiscoveryNodeFilters includeFilters;
    private final DiscoveryNodeFilters excludeFilters;
    private final DiscoveryNodeFilters initialRecoveryFilters;
    private final Version indexCreatedVersion;
    private final Version indexUpgradedVersion;
    private final org.apache.lucene.util.Version minimumCompatibleLuceneVersion;
    private final ActiveShardCount waitForActiveShards;
    public static final Setting<String> INDEX_SHRINK_SOURCE_UUID = Setting.simpleString("index.shrink.source.uuid", new Setting.Property[0]);
    public static final Setting<String> INDEX_SHRINK_SOURCE_NAME = Setting.simpleString("index.shrink.source.name", new Setting.Property[0]);
    private static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("binary", "true"));
    public static final MetaDataStateFormat<IndexMetaData> FORMAT = new MetaDataStateFormat<IndexMetaData>(XContentType.SMILE, "state-"){

        @Override
        public void toXContent(XContentBuilder builder, IndexMetaData state) throws IOException {
            Builder.toXContent(state, builder, FORMAT_PARAMS);
        }

        @Override
        public IndexMetaData fromXContent(XContentParser parser) throws IOException {
            return Builder.fromXContent(parser);
        }
    };

    public static void registerPrototype(String type, Custom proto) {
        customPrototypes.put(type, proto);
    }

    @Nullable
    public static <T extends Custom> T lookupPrototype(String type) {
        return (T)customPrototypes.get(type);
    }

    public static <T extends Custom> T lookupPrototypeSafe(String type) {
        Custom proto = customPrototypes.get(type);
        if (proto == null) {
            throw new IllegalArgumentException("No custom metadata prototype registered for type [" + type + "]");
        }
        return (T)proto;
    }

    static Setting<Integer> buildNumberOfShardsSetting() {
        int maxNumShards = Integer.parseInt(System.getProperty("es.index.max_number_of_shards", "1024"));
        if (maxNumShards < 1) {
            throw new IllegalArgumentException("es.index.max_number_of_shards must be > 0");
        }
        return Setting.intSetting(SETTING_NUMBER_OF_SHARDS, Math.min(5, maxNumShards), 1, maxNumShards, Setting.Property.IndexScope);
    }

    private IndexMetaData(Index index, long version, long[] primaryTerms, State state, int numberOfShards, int numberOfReplicas, Settings settings, ImmutableOpenMap<String, MappingMetaData> mappings, ImmutableOpenMap<String, AliasMetaData> aliases, ImmutableOpenMap<String, Custom> customs, ImmutableOpenIntMap<Set<String>> inSyncAllocationIds, DiscoveryNodeFilters requireFilters, DiscoveryNodeFilters initialRecoveryFilters, DiscoveryNodeFilters includeFilters, DiscoveryNodeFilters excludeFilters, Version indexCreatedVersion, Version indexUpgradedVersion, org.apache.lucene.util.Version minimumCompatibleLuceneVersion, int routingNumShards, ActiveShardCount waitForActiveShards) {
        this.index = index;
        this.version = version;
        this.primaryTerms = primaryTerms;
        assert (primaryTerms.length == numberOfShards);
        this.state = state;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.totalNumberOfShards = numberOfShards * (numberOfReplicas + 1);
        this.settings = settings;
        this.mappings = mappings;
        this.customs = customs;
        this.aliases = aliases;
        this.inSyncAllocationIds = inSyncAllocationIds;
        this.requireFilters = requireFilters;
        this.includeFilters = includeFilters;
        this.excludeFilters = excludeFilters;
        this.initialRecoveryFilters = initialRecoveryFilters;
        this.indexCreatedVersion = indexCreatedVersion;
        this.indexUpgradedVersion = indexUpgradedVersion;
        this.minimumCompatibleLuceneVersion = minimumCompatibleLuceneVersion;
        this.routingNumShards = routingNumShards;
        this.routingFactor = routingNumShards / numberOfShards;
        this.waitForActiveShards = waitForActiveShards;
        assert (numberOfShards * this.routingFactor == routingNumShards) : routingNumShards + " must be a multiple of " + numberOfShards;
    }

    public Index getIndex() {
        return this.index;
    }

    public String getIndexUUID() {
        return this.index.getUUID();
    }

    public boolean isSameUUID(String otherUUID) {
        assert (otherUUID != null);
        assert (this.getIndexUUID() != null);
        if (INDEX_UUID_NA_VALUE.equals(otherUUID) || INDEX_UUID_NA_VALUE.equals(this.getIndexUUID())) {
            return true;
        }
        return otherUUID.equals(this.getIndexUUID());
    }

    public long getVersion() {
        return this.version;
    }

    public long primaryTerm(int shardId) {
        return this.primaryTerms[shardId];
    }

    public Version getCreationVersion() {
        return this.indexCreatedVersion;
    }

    public Version getUpgradedVersion() {
        return this.indexUpgradedVersion;
    }

    public org.apache.lucene.util.Version getMinimumCompatibleVersion() {
        return this.minimumCompatibleLuceneVersion;
    }

    public long getCreationDate() {
        return this.settings.getAsLong(SETTING_CREATION_DATE, -1L);
    }

    public State getState() {
        return this.state;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public ActiveShardCount getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, AliasMetaData> getAliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, MappingMetaData> getMappings() {
        return this.mappings;
    }

    @Nullable
    public MappingMetaData mapping(String mappingType) {
        return this.mappings.get(mappingType);
    }

    public Index getMergeSourceIndex() {
        return INDEX_SHRINK_SOURCE_UUID.exists(this.settings) ? new Index(INDEX_SHRINK_SOURCE_NAME.get(this.settings), INDEX_SHRINK_SOURCE_UUID.get(this.settings)) : null;
    }

    @Nullable
    public MappingMetaData mappingOrDefault(String mappingType) {
        MappingMetaData mapping = this.mappings.get(mappingType);
        if (mapping != null) {
            return mapping;
        }
        return this.mappings.get("_default_");
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public ImmutableOpenIntMap<Set<String>> getInSyncAllocationIds() {
        return this.inSyncAllocationIds;
    }

    public Set<String> inSyncAllocationIds(int shardId) {
        assert (shardId >= 0 && shardId < this.numberOfShards);
        return this.inSyncAllocationIds.get(shardId);
    }

    @Nullable
    public DiscoveryNodeFilters requireFilters() {
        return this.requireFilters;
    }

    @Nullable
    public DiscoveryNodeFilters getInitialRecoveryFilters() {
        return this.initialRecoveryFilters;
    }

    @Nullable
    public DiscoveryNodeFilters includeFilters() {
        return this.includeFilters;
    }

    @Nullable
    public DiscoveryNodeFilters excludeFilters() {
        return this.excludeFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMetaData that = (IndexMetaData)o;
        if (this.version != that.version) {
            return false;
        }
        if (!this.aliases.equals(that.aliases)) {
            return false;
        }
        if (!this.index.equals(that.index)) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (!this.customs.equals(that.customs)) {
            return false;
        }
        if (this.routingNumShards != that.routingNumShards) {
            return false;
        }
        if (this.routingFactor != that.routingFactor) {
            return false;
        }
        if (!Arrays.equals(this.primaryTerms, that.primaryTerms)) {
            return false;
        }
        return this.inSyncAllocationIds.equals(that.inSyncAllocationIds);
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + Long.hashCode(this.version);
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.aliases.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mappings.hashCode();
        result = 31 * result + this.customs.hashCode();
        result = 31 * result + Long.hashCode(this.routingFactor);
        result = 31 * result + Long.hashCode(this.routingNumShards);
        result = 31 * result + Arrays.hashCode(this.primaryTerms);
        result = 31 * result + this.inSyncAllocationIds.hashCode();
        return result;
    }

    @Override
    public Diff<IndexMetaData> diff(IndexMetaData previousState) {
        return new IndexMetaDataDiff(previousState, this);
    }

    @Override
    public Diff<IndexMetaData> readDiffFrom(StreamInput in) throws IOException {
        return new IndexMetaDataDiff(in);
    }

    @Override
    public IndexMetaData fromXContent(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return Builder.fromXContent(parser);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    @Override
    public IndexMetaData readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString());
        builder.version(in.readLong());
        builder.setRoutingNumShards(in.readInt());
        builder.state(State.fromId(in.readByte()));
        builder.settings(Settings.readSettingsFromStream(in));
        builder.primaryTerms(in.readVLongArray());
        int mappingsSize = in.readVInt();
        for (int i = 0; i < mappingsSize; ++i) {
            MappingMetaData mappingMd = MappingMetaData.PROTO.readFrom(in);
            builder.putMapping(mappingMd);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            AliasMetaData aliasMd = AliasMetaData.Builder.readFrom(in);
            builder.putAlias(aliasMd);
        }
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            String type = in.readString();
            Custom customIndexMetaData = (Custom)IndexMetaData.lookupPrototypeSafe(type).readFrom(in);
            builder.putCustom(type, customIndexMetaData);
        }
        int inSyncAllocationIdsSize = in.readVInt();
        for (int i = 0; i < inSyncAllocationIdsSize; ++i) {
            int key = in.readVInt();
            Object allocationIds = DiffableUtils.StringSetValueSerializer.getInstance().read(in, (Object)key);
            builder.putInSyncAllocationIds(key, (Set<String>)allocationIds);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index.getName());
        out.writeLong(this.version);
        out.writeInt(this.routingNumShards);
        out.writeByte(this.state.id());
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVLongArray(this.primaryTerms);
        out.writeVInt(this.mappings.size());
        for (IntObjectCursor cursor : this.mappings.values()) {
            ((MappingMetaData)cursor.value).writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (IntObjectCursor cursor : this.aliases.values()) {
            ((AliasMetaData)cursor.value).writeTo(out);
        }
        out.writeVInt(this.customs.size());
        for (IntObjectCursor cursor : this.customs) {
            out.writeString((String)cursor.key);
            ((Custom)cursor.value).writeTo(out);
        }
        out.writeVInt(this.inSyncAllocationIds.size());
        for (IntObjectCursor cursor : this.inSyncAllocationIds) {
            out.writeVInt(cursor.key);
            DiffableUtils.StringSetValueSerializer.getInstance().write((Set)cursor.value, out);
        }
    }

    public static Builder builder(String index) {
        return new Builder(index);
    }

    public static Builder builder(IndexMetaData indexMetaData) {
        return new Builder(indexMetaData);
    }

    public static boolean isOnSharedFilesystem(Settings settings) {
        return settings.getAsBoolean(SETTING_SHARED_FILESYSTEM, IndexMetaData.isIndexUsingShadowReplicas(settings));
    }

    public static boolean isIndexUsingShadowReplicas(Settings settings) {
        return settings.getAsBoolean(SETTING_SHADOW_REPLICAS, false);
    }

    public static Settings addHumanReadableSettings(Settings settings) {
        Long creationDate;
        Version versionUpgraded;
        Settings.Builder builder = Settings.builder().put(settings);
        Version version = settings.getAsVersion(SETTING_VERSION_CREATED, null);
        if (version != null) {
            builder.put(SETTING_VERSION_CREATED_STRING, version.toString());
        }
        if ((versionUpgraded = settings.getAsVersion(SETTING_VERSION_UPGRADED, null)) != null) {
            builder.put(SETTING_VERSION_UPGRADED_STRING, versionUpgraded.toString());
        }
        if ((creationDate = settings.getAsLong(SETTING_CREATION_DATE, null)) != null) {
            DateTime creationDateTime = new DateTime((Object)creationDate, DateTimeZone.UTC);
            builder.put(SETTING_CREATION_DATE_STRING, creationDateTime.toString());
        }
        return builder.build();
    }

    public int getRoutingNumShards() {
        return this.routingNumShards;
    }

    public int getRoutingFactor() {
        return this.routingFactor;
    }

    public static Set<ShardId> selectShrinkShards(int shardId, IndexMetaData sourceIndexMetadata, int numTargetShards) {
        if (shardId >= numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be greater than the shard id: " + shardId);
        }
        int routingFactor = IndexMetaData.getRoutingFactor(sourceIndexMetadata, numTargetShards);
        HashSet<ShardId> shards = new HashSet<ShardId>(routingFactor);
        for (int i = shardId * routingFactor; i < routingFactor * shardId + routingFactor; ++i) {
            shards.add(new ShardId(sourceIndexMetadata.getIndex(), i));
        }
        return shards;
    }

    public static int getRoutingFactor(IndexMetaData sourceIndexMetadata, int targetNumberOfShards) {
        int sourceNumberOfShards = sourceIndexMetadata.getNumberOfShards();
        if (sourceNumberOfShards < targetNumberOfShards) {
            throw new IllegalArgumentException("the number of target shards must be less that the number of source shards");
        }
        int factor = sourceNumberOfShards / targetNumberOfShards;
        if (factor * targetNumberOfShards != sourceNumberOfShards || factor <= 1) {
            throw new IllegalArgumentException("the number of source shards [" + sourceNumberOfShards + "] must be a must be a multiple of [" + targetNumberOfShards + "]");
        }
        return factor;
    }

    public static class Builder {
        private String index;
        private State state = State.OPEN;
        private long version = 1L;
        private long[] primaryTerms = null;
        private Settings settings = Settings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, MappingMetaData> mappings;
        private final ImmutableOpenMap.Builder<String, AliasMetaData> aliases;
        private final ImmutableOpenMap.Builder<String, Custom> customs;
        private final ImmutableOpenIntMap.Builder<Set<String>> inSyncAllocationIds;
        private Integer routingNumShards;

        public Builder(String index) {
            this.index = index;
            this.mappings = ImmutableOpenMap.builder();
            this.aliases = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
            this.inSyncAllocationIds = ImmutableOpenIntMap.builder();
        }

        public Builder(IndexMetaData indexMetaData) {
            this.index = indexMetaData.getIndex().getName();
            this.state = indexMetaData.state;
            this.version = indexMetaData.version;
            this.settings = indexMetaData.getSettings();
            this.primaryTerms = (long[])indexMetaData.primaryTerms.clone();
            this.mappings = ImmutableOpenMap.builder(indexMetaData.mappings);
            this.aliases = ImmutableOpenMap.builder(indexMetaData.aliases);
            this.customs = ImmutableOpenMap.builder(indexMetaData.customs);
            this.routingNumShards = indexMetaData.routingNumShards;
            this.inSyncAllocationIds = ImmutableOpenIntMap.builder(indexMetaData.inSyncAllocationIds);
        }

        public String index() {
            return this.index;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder numberOfShards(int numberOfShards) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetaData.SETTING_NUMBER_OF_SHARDS, numberOfShards).build();
            return this;
        }

        public Builder setRoutingNumShards(int routingNumShards) {
            this.routingNumShards = routingNumShards;
            return this;
        }

        public int getRoutingNumShards() {
            return this.routingNumShards == null ? this.numberOfShards() : this.routingNumShards.intValue();
        }

        public int numberOfShards() {
            return this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_SHARDS, -1);
        }

        public Builder numberOfReplicas(int numberOfReplicas) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, numberOfReplicas).build();
            return this;
        }

        public int numberOfReplicas() {
            return this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, -1);
        }

        public Builder creationDate(long creationDate) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetaData.SETTING_CREATION_DATE, creationDate).build();
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            return this.settings(settings.build());
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public MappingMetaData mapping(String type) {
            return this.mappings.get(type);
        }

        public Builder putMapping(String type, String source) throws IOException {
            try (XContentParser parser = XContentFactory.xContent(source).createParser(source);){
                this.putMapping(new MappingMetaData(type, parser.mapOrdered()));
            }
            return this;
        }

        public Builder putMapping(MappingMetaData mappingMd) {
            this.mappings.put(mappingMd.type(), mappingMd);
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder putAlias(AliasMetaData aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData);
            return this;
        }

        public Builder putAlias(AliasMetaData.Builder aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData.build());
            return this;
        }

        public Builder removeAlias(String alias) {
            this.aliases.remove(alias);
            return this;
        }

        public Builder removeAllAliases() {
            this.aliases.clear();
            return this;
        }

        public Builder putCustom(String type, Custom customIndexMetaData) {
            this.customs.put(type, customIndexMetaData);
            return this;
        }

        public Set<String> getInSyncAllocationIds(int shardId) {
            return this.inSyncAllocationIds.get(shardId);
        }

        public Builder putInSyncAllocationIds(int shardId, Set<String> allocationIds) {
            this.inSyncAllocationIds.put(shardId, new HashSet<String>(allocationIds));
            return this;
        }

        public long version() {
            return this.version;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public long primaryTerm(int shardId) {
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            }
            return this.primaryTerms[shardId];
        }

        public Builder primaryTerm(int shardId, long primaryTerm) {
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            }
            this.primaryTerms[shardId] = primaryTerm;
            return this;
        }

        private void primaryTerms(long[] primaryTerms) {
            this.primaryTerms = (long[])primaryTerms.clone();
        }

        private void initializePrimaryTerms() {
            assert (this.primaryTerms == null);
            if (this.numberOfShards() < 0) {
                throw new IllegalStateException("you must set the number of shards before setting/reading primary terms");
            }
            this.primaryTerms = new long[this.numberOfShards()];
        }

        public IndexMetaData build() {
            org.apache.lucene.util.Version minimumCompatibleLuceneVersion;
            Integer maybeNumberOfShards;
            ImmutableOpenMap.Builder<String, AliasMetaData> tmpAliases = this.aliases;
            Settings tmpSettings = this.settings;
            if (this.mappings.containsKey("_default_")) {
                MappingMetaData defaultMapping = this.mappings.get("_default_");
                for (ObjectCursor cursor : this.mappings.values()) {
                    ((MappingMetaData)cursor.value).updateDefaultMapping(defaultMapping);
                }
            }
            if ((maybeNumberOfShards = this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_SHARDS, null)) == null) {
                throw new IllegalArgumentException("must specify numberOfShards for index [" + this.index + "]");
            }
            int numberOfShards = maybeNumberOfShards;
            if (numberOfShards <= 0) {
                throw new IllegalArgumentException("must specify positive number of shards for index [" + this.index + "]");
            }
            Integer maybeNumberOfReplicas = this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, null);
            if (maybeNumberOfReplicas == null) {
                throw new IllegalArgumentException("must specify numberOfReplicas for index [" + this.index + "]");
            }
            int numberOfReplicas = maybeNumberOfReplicas;
            if (numberOfReplicas < 0) {
                throw new IllegalArgumentException("must specify non-negative number of shards for index [" + this.index + "]");
            }
            ImmutableOpenIntMap.Builder filledInSyncAllocationIds = ImmutableOpenIntMap.builder();
            for (int i = 0; i < numberOfShards; ++i) {
                if (this.inSyncAllocationIds.containsKey(i)) {
                    filledInSyncAllocationIds.put(i, Collections.unmodifiableSet(new HashSet(this.inSyncAllocationIds.get(i))));
                    continue;
                }
                filledInSyncAllocationIds.put(i, Collections.emptySet());
            }
            Map<String, String> requireMap = INDEX_ROUTING_REQUIRE_GROUP_SETTING.get(this.settings).getAsMap();
            DiscoveryNodeFilters requireFilters = requireMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, requireMap);
            Map<String, String> includeMap = INDEX_ROUTING_INCLUDE_GROUP_SETTING.get(this.settings).getAsMap();
            DiscoveryNodeFilters includeFilters = includeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, includeMap);
            Map<String, String> excludeMap = INDEX_ROUTING_EXCLUDE_GROUP_SETTING.get(this.settings).getAsMap();
            DiscoveryNodeFilters excludeFilters = excludeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, excludeMap);
            Map<String, String> initialRecoveryMap = INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.get(this.settings).getAsMap();
            DiscoveryNodeFilters initialRecoveryFilters = initialRecoveryMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, initialRecoveryMap);
            Version indexCreatedVersion = Version.indexCreated(this.settings);
            Version indexUpgradedVersion = this.settings.getAsVersion(IndexMetaData.SETTING_VERSION_UPGRADED, indexCreatedVersion);
            String stringLuceneVersion = this.settings.get(IndexMetaData.SETTING_VERSION_MINIMUM_COMPATIBLE);
            if (stringLuceneVersion != null) {
                try {
                    minimumCompatibleLuceneVersion = org.apache.lucene.util.Version.parse((String)stringLuceneVersion);
                }
                catch (ParseException ex) {
                    throw new IllegalStateException("Cannot parse lucene version [" + stringLuceneVersion + "] in the [" + IndexMetaData.SETTING_VERSION_MINIMUM_COMPATIBLE + "] setting", ex);
                }
            } else {
                minimumCompatibleLuceneVersion = null;
            }
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            } else if (this.primaryTerms.length != numberOfShards) {
                throw new IllegalStateException("primaryTerms length is [" + this.primaryTerms.length + "] but should be equal to number of shards [" + this.numberOfShards() + "]");
            }
            ActiveShardCount waitForActiveShards = SETTING_WAIT_FOR_ACTIVE_SHARDS.get(this.settings);
            if (!waitForActiveShards.validate(numberOfReplicas)) {
                throw new IllegalArgumentException("invalid " + SETTING_WAIT_FOR_ACTIVE_SHARDS.getKey() + "[" + waitForActiveShards + "]: cannot be greater than number of shard copies [" + (numberOfReplicas + 1) + "]");
            }
            String uuid = this.settings.get(IndexMetaData.SETTING_INDEX_UUID, IndexMetaData.INDEX_UUID_NA_VALUE);
            return new IndexMetaData(new Index(this.index, uuid), this.version, this.primaryTerms, this.state, numberOfShards, numberOfReplicas, tmpSettings, this.mappings.build(), tmpAliases.build(), this.customs.build(), filledInSyncAllocationIds.build(), requireFilters, initialRecoveryFilters, includeFilters, excludeFilters, indexCreatedVersion, indexUpgradedVersion, minimumCompatibleLuceneVersion, this.getRoutingNumShards(), waitForActiveShards);
        }

        public static void toXContent(IndexMetaData indexMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexMetaData.getIndex().getName());
            builder.field(IndexMetaData.KEY_VERSION, indexMetaData.getVersion());
            builder.field(IndexMetaData.KEY_ROUTING_NUM_SHARDS, indexMetaData.getRoutingNumShards());
            builder.field(IndexMetaData.KEY_STATE, indexMetaData.getState().toString().toLowerCase(Locale.ENGLISH));
            boolean binary = params.paramAsBoolean("binary", false);
            builder.startObject(IndexMetaData.KEY_SETTINGS);
            for (Map.Entry<String, String> entry : indexMetaData.getSettings().getAsMap().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
            builder.endObject();
            builder.startArray(IndexMetaData.KEY_MAPPINGS);
            for (ObjectObjectCursor objectObjectCursor : indexMetaData.getMappings()) {
                if (binary) {
                    builder.value(((MappingMetaData)objectObjectCursor.value).source().compressed());
                    continue;
                }
                byte[] data = ((MappingMetaData)objectObjectCursor.value).source().uncompressed();
                XContentParser parser = XContentFactory.xContent(data).createParser(data);
                Throwable throwable = null;
                try {
                    Map<String, Object> mapping = parser.mapOrdered();
                    builder.map(mapping);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (parser == null) continue;
                    if (throwable != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    parser.close();
                }
            }
            builder.endArray();
            for (ObjectObjectCursor objectObjectCursor : indexMetaData.getCustoms()) {
                builder.startObject((String)objectObjectCursor.key);
                ((Custom)objectObjectCursor.value).toXContent(builder, params);
                builder.endObject();
            }
            builder.startObject(IndexMetaData.KEY_ALIASES);
            for (ObjectCursor objectCursor : indexMetaData.getAliases().values()) {
                AliasMetaData.Builder.toXContent((AliasMetaData)objectCursor.value, builder, params);
            }
            builder.endObject();
            builder.startArray(IndexMetaData.KEY_PRIMARY_TERMS);
            for (int i = 0; i < indexMetaData.getNumberOfShards(); ++i) {
                builder.value(indexMetaData.primaryTerm(i));
            }
            builder.endArray();
            builder.startObject(IndexMetaData.KEY_IN_SYNC_ALLOCATIONS);
            for (IntObjectCursor intObjectCursor : indexMetaData.inSyncAllocationIds) {
                builder.startArray(String.valueOf(intObjectCursor.key));
                for (String allocationId : (Set)intObjectCursor.value) {
                    builder.value(allocationId);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }

        public static IndexMetaData fromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
            }
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                throw new IllegalArgumentException("expected field name but got a " + (Object)((Object)parser.currentToken()));
            }
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("expected object but got a " + (Object)((Object)token));
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (IndexMetaData.KEY_SETTINGS.equals(currentFieldName)) {
                        builder.settings(Settings.builder().put(SettingsLoader.Helper.loadNestedFromMap(parser.mapOrdered())));
                        continue;
                    }
                    if (IndexMetaData.KEY_MAPPINGS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                String mappingType = currentFieldName;
                                Map<String, Object> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser.mapOrdered()).map();
                                builder.putMapping(new MappingMetaData(mappingType, mappingSource));
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + (Object)((Object)token));
                        }
                        continue;
                    }
                    if (IndexMetaData.KEY_ALIASES.equals(currentFieldName)) {
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetaData.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    if (IndexMetaData.KEY_IN_SYNC_ALLOCATIONS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                String shardId = currentFieldName;
                                HashSet<String> allocationIds = new HashSet<String>();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    if (token != XContentParser.Token.VALUE_STRING) continue;
                                    allocationIds.add(parser.text());
                                }
                                builder.putInSyncAllocationIds(Integer.valueOf(shardId), allocationIds);
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + (Object)((Object)token));
                        }
                        continue;
                    }
                    if ("warmers".equals(currentFieldName)) {
                        assert (Version.CURRENT.major <= 5);
                        parser.skipChildren();
                        continue;
                    }
                    Object proto = IndexMetaData.lookupPrototype(currentFieldName);
                    if (proto == null) {
                        parser.skipChildren();
                        continue;
                    }
                    Custom custom = proto.fromXContent(parser);
                    builder.putCustom(custom.type(), custom);
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (IndexMetaData.KEY_MAPPINGS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                                builder.putMapping(new MappingMetaData(new CompressedXContent(parser.binaryValue())));
                                continue;
                            }
                            Map<String, Object> mapping = parser.mapOrdered();
                            if (mapping.size() != 1) continue;
                            String mappingType = mapping.keySet().iterator().next();
                            builder.putMapping(new MappingMetaData(mappingType, mapping));
                        }
                        continue;
                    }
                    if (IndexMetaData.KEY_PRIMARY_TERMS.equals(currentFieldName)) {
                        LongArrayList list = new LongArrayList();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                list.add(parser.longValue());
                                continue;
                            }
                            throw new IllegalStateException("found a non-numeric value under [primary_terms]");
                        }
                        builder.primaryTerms(list.toArray());
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field for an array " + currentFieldName);
                }
                if (token.isValue()) {
                    if (IndexMetaData.KEY_STATE.equals(currentFieldName)) {
                        builder.state(State.fromString(parser.text()));
                        continue;
                    }
                    if (IndexMetaData.KEY_VERSION.equals(currentFieldName)) {
                        builder.version(parser.longValue());
                        continue;
                    }
                    if (IndexMetaData.KEY_ROUTING_NUM_SHARDS.equals(currentFieldName)) {
                        builder.setRoutingNumShards(parser.intValue());
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + (Object)((Object)token));
            }
            return builder.build();
        }

        public static IndexMetaData readFrom(StreamInput in) throws IOException {
            return PROTO.readFrom(in);
        }
    }

    private static class IndexMetaDataDiff
    implements Diff<IndexMetaData> {
        private final String index;
        private final int routingNumShards;
        private final long version;
        private final long[] primaryTerms;
        private final State state;
        private final Settings settings;
        private final Diff<ImmutableOpenMap<String, MappingMetaData>> mappings;
        private final Diff<ImmutableOpenMap<String, AliasMetaData>> aliases;
        private final Diff<ImmutableOpenMap<String, Custom>> customs;
        private final Diff<ImmutableOpenIntMap<Set<String>>> inSyncAllocationIds;

        public IndexMetaDataDiff(IndexMetaData before, IndexMetaData after) {
            this.index = after.index.getName();
            this.version = after.version;
            this.routingNumShards = after.routingNumShards;
            this.state = after.state;
            this.settings = after.settings;
            this.primaryTerms = after.primaryTerms;
            this.mappings = DiffableUtils.diff(before.mappings, after.mappings, DiffableUtils.getStringKeySerializer());
            this.aliases = DiffableUtils.diff(before.aliases, after.aliases, DiffableUtils.getStringKeySerializer());
            this.customs = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer());
            this.inSyncAllocationIds = DiffableUtils.diff(before.inSyncAllocationIds, after.inSyncAllocationIds, DiffableUtils.getVIntKeySerializer(), DiffableUtils.StringSetValueSerializer.getInstance());
        }

        public IndexMetaDataDiff(StreamInput in) throws IOException {
            this.index = in.readString();
            this.routingNumShards = in.readInt();
            this.version = in.readLong();
            this.state = State.fromId(in.readByte());
            this.settings = Settings.readSettingsFromStream(in);
            this.primaryTerms = in.readVLongArray();
            this.mappings = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), MappingMetaData.PROTO);
            this.aliases = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), AliasMetaData.PROTO);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), new DiffableUtils.DiffableValueSerializer<String, Custom>(){

                @Override
                public Custom read(StreamInput in, String key) throws IOException {
                    return (Custom)IndexMetaData.lookupPrototypeSafe(key).readFrom(in);
                }

                @Override
                public Diff<Custom> readDiff(StreamInput in, String key) throws IOException {
                    return IndexMetaData.lookupPrototypeSafe(key).readDiffFrom(in);
                }
            });
            this.inSyncAllocationIds = DiffableUtils.readImmutableOpenIntMapDiff(in, DiffableUtils.getVIntKeySerializer(), DiffableUtils.StringSetValueSerializer.getInstance());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeInt(this.routingNumShards);
            out.writeLong(this.version);
            out.writeByte(this.state.id);
            Settings.writeSettingsToStream(this.settings, out);
            out.writeVLongArray(this.primaryTerms);
            this.mappings.writeTo(out);
            this.aliases.writeTo(out);
            this.customs.writeTo(out);
            this.inSyncAllocationIds.writeTo(out);
        }

        @Override
        public IndexMetaData apply(IndexMetaData part) {
            Builder builder = IndexMetaData.builder(this.index);
            builder.version(this.version);
            builder.setRoutingNumShards(this.routingNumShards);
            builder.state(this.state);
            builder.settings(this.settings);
            builder.primaryTerms(this.primaryTerms);
            builder.mappings.putAll((Iterable)this.mappings.apply(part.mappings));
            builder.aliases.putAll((Iterable)this.aliases.apply(part.aliases));
            builder.customs.putAll((Iterable)this.customs.apply(part.customs));
            builder.inSyncAllocationIds.putAll((Iterable)this.inSyncAllocationIds.apply(part.inSyncAllocationIds));
            return builder.build();
        }
    }

    public static enum State {
        OPEN(0),
        CLOSE(1);

        private final byte id;

        private State(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static State fromId(byte id) {
            if (id == 0) {
                return OPEN;
            }
            if (id == 1) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for id [" + id + "]");
        }

        public static State fromString(String state) {
            if ("open".equals(state)) {
                return OPEN;
            }
            if ("close".equals(state)) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for [" + state + "]");
        }
    }

    public static interface Custom
    extends Diffable<Custom>,
    ToXContent {
        public String type();

        public Custom fromMap(Map<String, Object> var1) throws IOException;

        public Custom fromXContent(XContentParser var1) throws IOException;

        public Custom mergeWith(Custom var1);
    }
}

