/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.remote.Address;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DefaultDaemonContext;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;

public class DaemonInfo
implements Serializable,
DaemonConnectDetails {
    private final Address address;
    private final DaemonContext context;
    private final byte[] token;
    private final TimeProvider timeProvider;
    private DaemonStateControl.State state;
    private long lastBusy;

    public DaemonInfo(Address address, DaemonContext context, byte[] token, DaemonStateControl.State state) {
        this(address, context, token, state, new TrueTimeProvider());
    }

    @VisibleForTesting
    DaemonInfo(Address address, DaemonContext context, byte[] token, DaemonStateControl.State state, TimeProvider busyClock) {
        this.address = (Address)Preconditions.checkNotNull((Object)address);
        this.context = (DaemonContext)Preconditions.checkNotNull((Object)context);
        this.token = (byte[])Preconditions.checkNotNull((Object)token);
        this.timeProvider = (TimeProvider)Preconditions.checkNotNull((Object)busyClock);
        this.lastBusy = -1L;
        this.setState(state);
    }

    private DaemonInfo(Address address, DaemonContext context, byte[] token, DaemonStateControl.State state, long lastBusy) {
        this.address = address;
        this.context = context;
        this.token = token;
        this.state = state;
        this.lastBusy = lastBusy;
        this.timeProvider = new TrueTimeProvider();
    }

    public DaemonInfo setState(DaemonStateControl.State state) {
        if ((this.state == DaemonStateControl.State.Idle || this.state == null) && state == DaemonStateControl.State.Busy) {
            this.lastBusy = this.timeProvider.getCurrentTime();
        }
        this.state = state;
        return this;
    }

    public String getUid() {
        return this.context.getUid();
    }

    public Long getPid() {
        return this.context.getPid();
    }

    public Address getAddress() {
        return this.address;
    }

    public DaemonContext getContext() {
        return this.context;
    }

    public DaemonStateControl.State getState() {
        return this.state;
    }

    public byte[] getToken() {
        return this.token;
    }

    public Date getLastBusy() {
        return new Date(this.lastBusy);
    }

    public String toString() {
        return String.format("DaemonInfo{pid=%s, address=%s, state=%s, lastBusy=%s, context=%s}", new Object[]{this.context.getPid(), this.address, this.state, this.lastBusy, this.context});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Serializer
    implements org.gradle.internal.serialize.Serializer<DaemonInfo> {
        private final List<Address> addresses;

        public Serializer(List<Address> addresses) {
            this.addresses = addresses;
        }

        public DaemonInfo read(Decoder decoder) throws Exception {
            Address address = this.addresses.get(decoder.readInt());
            byte[] token = decoder.readBinary();
            DaemonStateControl.State state = DaemonStateControl.State.values()[decoder.readByte()];
            long lastBusy = decoder.readLong();
            DaemonContext context = (DaemonContext)DefaultDaemonContext.SERIALIZER.read(decoder);
            return new DaemonInfo(address, context, token, state, lastBusy);
        }

        public void write(Encoder encoder, DaemonInfo info) throws Exception {
            this.writeAddressIndex(encoder, info);
            encoder.writeBinary(info.token);
            encoder.writeByte((byte)info.state.ordinal());
            encoder.writeLong(info.lastBusy);
            DefaultDaemonContext.SERIALIZER.write(encoder, (Object)((DefaultDaemonContext)info.context));
        }

        private void writeAddressIndex(Encoder encoder, DaemonInfo info) throws IOException {
            int i = 0;
            for (Address address : this.addresses) {
                if (info.address.equals(address)) {
                    encoder.writeInt(i);
                    break;
                }
                ++i;
            }
        }
    }
}

