/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.Deserialization;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FlexibleTypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.LocalClassifierResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedAnnotationsWithPossibleTargets;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeBasedStarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    private final Function1<Integer, ClassDescriptor> classDescriptors;
    private final Function1<Integer, ClassifierDescriptor> typeAliasDescriptors;
    private final Map<Integer, TypeParameterDescriptor> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final String debugName;

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.toReadOnlyList(this.typeParameterDescriptors.values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)additionalAnnotations, (String)"additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            SimpleType lowerBound = this.simpleType(proto, additionalAnnotations);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            SimpleType upperBound = this.simpleType(type2, additionalAnnotations);
            FlexibleTypeDeserializer flexibleTypeDeserializer = this.c.getComponents().getFlexibleTypeDeserializer();
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            return flexibleTypeDeserializer.create(proto, string, lowerBound, upperBound);
        }
        return this.simpleType(proto, additionalAnnotations);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: type");
        }
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type2, annotations2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType simpleType(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)additionalAnnotations, (String)"additionalAnnotations");
        TypeConstructor constructor = this.typeConstructor(proto);
        if (ErrorUtils.isError(constructor.getDeclarationDescriptor())) {
            SimpleType simpleType2 = ErrorUtils.createErrorTypeWithCustomConstructor(constructor.toString(), constructor);
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"ErrorUtils.createErrorTy\u2026.toString(), constructor)");
            return simpleType2;
        }
        DeserializedAnnotationsWithPossibleTargets annotations2 = new DeserializedAnnotationsWithPossibleTargets(this.c.getStorageManager(), (Function0<? extends List<AnnotationWithTarget>>)((Function0)new Function0<List<? extends AnnotationWithTarget>>(this, proto, additionalAnnotations){
            final /* synthetic */ TypeDeserializer this$0;
            final /* synthetic */ ProtoBuf.Type $proto;
            final /* synthetic */ Annotations $additionalAnnotations;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<AnnotationWithTarget> invoke() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable $receiver$iv = TypeDeserializer.access$getC$p(this.this$0).getComponents().getAnnotationAndConstantLoader().loadTypeAnnotations(this.$proto, TypeDeserializer.access$getC$p(this.this$0).getNameResolver());
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    AnnotationWithTarget annotationWithTarget = new AnnotationWithTarget((AnnotationDescriptor)it, null);
                    collection.add(annotationWithTarget);
                }
                return CollectionsKt.plus((Collection)((List)var3_3), (Iterable)this.$additionalAnnotations.getAllAnnotations());
            }
            {
                this.this$0 = typeDeserializer;
                this.$proto = type2;
                this.$additionalAnnotations = annotations2;
                super(0);
            }
        }));
        Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>> collectAllArguments$ = new Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final List<ProtoBuf.Type.Argument> invoke(@NotNull ProtoBuf.Type $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.outerType($receiver, TypeDeserializer.access$getC$p(this.this$0).getTypeTable());
                List list = type2 != null ? this.invoke(type2) : null;
                Collection collection = $receiver.getArgumentList();
                List list2 = list;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List list3 = list2;
                return CollectionsKt.plus((Collection)collection, (Iterable)list3);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        };
        Iterable iterable = collectAllArguments$.invoke(proto);
        void var7_7 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto2;
            void index;
            int n = index$iv$iv++;
            ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
            int n2 = n;
            void var14_14 = destination$iv$iv;
            TypeProjection typeProjection = this.typeArgument((TypeParameterDescriptor)CollectionsKt.getOrNull(constructor.getParameters(), (int)index), (ProtoBuf.Type.Argument)proto2);
            var14_14.add(typeProjection);
        }
        List arguments = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.toReadOnlyList((List)destination$iv$iv);
        SimpleType simpleType3 = KotlinTypeFactory.simpleType$default(annotations2, constructor, arguments, proto.getNullable(), null, 16, null);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.abbreviatedType(proto, this.c.getTypeTable());
        if (type2 == null) {
            return simpleType3;
        }
        ProtoBuf.Type abbreviatedTypeProto = type2;
        return SpecialTypesKt.withAbbreviation(simpleType3, this.simpleType(abbreviatedTypeProto, additionalAnnotations));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SimpleType simpleType$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: simpleType");
        }
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.simpleType(type2, annotations2);
    }

    private final TypeConstructor typeConstructor(ProtoBuf.Type proto) {
        Annotated annotated;
        if (proto.hasClassName()) {
            annotated = (ClassDescriptor)this.classDescriptors.invoke((Object)proto.getClassName());
            if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
                annotated = this.c.getComponents().getNotFoundClasses().getClass(proto, this.c.getNameResolver(), this.c.getTypeTable());
            }
        } else if (proto.hasTypeParameter()) {
            annotated = this.typeParameterTypeConstructor(proto.getTypeParameter());
            if (annotated == null) {
                TypeConstructor typeConstructor2 = ErrorUtils.createErrorTypeConstructor("Unknown type parameter " + proto.getTypeParameter());
                annotated = typeConstructor2;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"ErrorUtils.createErrorTy\u2026 ${proto.typeParameter}\")");
            }
        } else if (proto.hasTypeParameterName()) {
            TypeParameterDescriptor parameter;
            Object v2;
            String name;
            DeclarationDescriptor container;
            block13: {
                container = this.c.getContainingDeclaration();
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable = this.getOwnTypeParameters();
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name)) continue;
                    v2 = t;
                    break block13;
                }
                v2 = null;
            }
            if ((annotated = (parameter = (TypeParameterDescriptor)v2)) == null || (annotated = annotated.getTypeConstructor()) == null) {
                TypeConstructor typeConstructor3 = ErrorUtils.createErrorTypeConstructor("Deserialized type parameter " + name + " in " + container);
                annotated = typeConstructor3;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor3, (String)"ErrorUtils.createErrorTy\u2026ter $name in $container\")");
            }
        } else if (proto.hasTypeAliasName()) {
            annotated = (ClassifierDescriptor)this.typeAliasDescriptors.invoke((Object)proto.getTypeAliasName());
            if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
                annotated = this.c.getComponents().getNotFoundClasses().getTypeAlias(proto, this.c.getNameResolver(), this.c.getTypeTable());
            }
        } else {
            TypeConstructor typeConstructor4 = ErrorUtils.createErrorTypeConstructor("Unknown type");
            annotated = typeConstructor4;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor4, (String)"ErrorUtils.createErrorTy\u2026nstructor(\"Unknown type\")");
        }
        return annotated;
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Annotated annotated = this.typeParameterDescriptors.get(typeParameterId);
        if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            annotated = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return annotated;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            LocalClassifierResolver localClassifierResolver = this.c.getComponents().getLocalClassifierResolver();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
            return localClassifierResolver.resolveLocalClass(classId);
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
    }

    private final ClassifierDescriptor computeTypeAliasDescriptor(int fqNameIndex) {
        ClassifierDescriptor classifierDescriptor;
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            LocalClassifierResolver localClassifierResolver = this.c.getComponents().getLocalClassifierResolver();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
            classifierDescriptor = localClassifierResolver.resolveLocalTypeAlias(classId);
        } else {
            ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"id");
            classifierDescriptor = FindClassInModuleKt.findTypeAliasAcrossModuleDependencies(moduleDescriptor, classId);
        }
        return classifierDescriptor;
    }

    private final TypeProjection typeArgument(TypeParameterDescriptor parameter, ProtoBuf.Type.Argument typeArgumentProto) {
        if (Intrinsics.areEqual((Object)typeArgumentProto.getProjection(), (Object)ProtoBuf.Type.Argument.Projection.STAR)) {
            TypeProjection typeProjection;
            if (parameter == null) {
                KotlinType kotlinType = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"c.components.moduleDescr\u2026.builtIns.nullableAnyType");
                typeProjection = new TypeBasedStarProjectionImpl(kotlinType);
            } else {
                typeProjection = new StarProjectionImpl(parameter);
            }
            return typeProjection;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull((Object)projection, (String)"typeArgumentProto.projection");
        Variance variance = Deserialization.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type2 == null) {
            return new TypeProjectionImpl(ErrorUtils.createErrorType("No type recorded"));
        }
        ProtoBuf.Type type3 = type2;
        return new TypeProjectionImpl(variance, TypeDeserializer.type$default(this, type3, null, 2, null));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, (String)"typeParameterProtos");
        Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
        this.c = c;
        this.parent = parent;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeAliasDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassifierDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassifierDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeTypeAliasDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        TypeDeserializer typeDeserializer = this;
        if (typeParameterProtos.isEmpty()) {
            TypeDeserializer typeDeserializer2 = typeDeserializer;
            Map map3 = MapsKt.emptyMap();
            typeDeserializer = typeDeserializer2;
            map2 = map3;
        } else {
            LinkedHashMap result = new LinkedHashMap();
            for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)typeParameterProtos)) {
                int index = indexedValue.component1();
                ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)indexedValue.component2();
                Map map4 = result;
                Integer n = proto.getId();
                DeserializedTypeParameterDescriptor deserializedTypeParameterDescriptor = new DeserializedTypeParameterDescriptor(this.c, proto, index);
                TypeDeserializer typeDeserializer3 = typeDeserializer;
                map4.put(n, deserializedTypeParameterDescriptor);
                TypeDeserializer typeDeserializer4 = typeDeserializer3;
            }
            map2 = result;
        }
        typeDeserializer.typeParameterDescriptors = map2;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @Nullable
    public static final /* synthetic */ ClassifierDescriptor access$computeTypeAliasDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeTypeAliasDescriptor(fqNameIndex);
    }
}

