/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.ExceptionTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.ParamDocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.ReturnDocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.SeeDocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.SerialDocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.SimpleDocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.ValueDocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.CustomJavadocTagProvider;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.JavadocManager;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.JavadocTagInfo;

public class JavadocManagerImpl
implements JavadocManager {
    private final List<JavadocTagInfo> myInfos = new ArrayList<JavadocTagInfo>();

    public JavadocManagerImpl(Project project) {
        this.myInfos.add(new SimpleDocTagInfo("author", PsiClass.class, PsiPackage.class, LanguageLevel.JDK_1_3));
        this.myInfos.add(new SimpleDocTagInfo("deprecated", PsiElement.class, false, LanguageLevel.JDK_1_3));
        this.myInfos.add(new SimpleDocTagInfo("serialData", PsiMethod.class, false, LanguageLevel.JDK_1_3));
        this.myInfos.add(new SimpleDocTagInfo("serialField", PsiField.class, false, LanguageLevel.JDK_1_3));
        this.myInfos.add(new SimpleDocTagInfo("since", PsiElement.class, PsiPackage.class, LanguageLevel.JDK_1_3));
        this.myInfos.add(new SimpleDocTagInfo("version", PsiClass.class, PsiPackage.class, LanguageLevel.JDK_1_3));
        this.myInfos.add(new SimpleDocTagInfo("apiNote", PsiElement.class, false, LanguageLevel.JDK_1_8));
        this.myInfos.add(new SimpleDocTagInfo("implNote", PsiElement.class, false, LanguageLevel.JDK_1_8));
        this.myInfos.add(new SimpleDocTagInfo("implSpec", PsiElement.class, false, LanguageLevel.JDK_1_8));
        this.myInfos.add(new SimpleDocTagInfo("docRoot", PsiElement.class, true, LanguageLevel.JDK_1_3));
        this.myInfos.add(new SimpleDocTagInfo("inheritDoc", PsiElement.class, true, LanguageLevel.JDK_1_4));
        this.myInfos.add(new SimpleDocTagInfo("literal", PsiElement.class, true, LanguageLevel.JDK_1_5));
        this.myInfos.add(new SimpleDocTagInfo("code", PsiElement.class, true, LanguageLevel.JDK_1_5));
        this.myInfos.add(new SimpleDocTagInfo("noinspection", PsiElement.class, false, LanguageLevel.JDK_1_3));
        this.myInfos.add(new ParamDocTagInfo());
        this.myInfos.add(new ReturnDocTagInfo());
        this.myInfos.add(new SerialDocTagInfo());
        this.myInfos.add(new SeeDocTagInfo("see", false));
        this.myInfos.add(new SeeDocTagInfo("link", true));
        this.myInfos.add(new SeeDocTagInfo("linkplain", true));
        this.myInfos.add(new ExceptionTagInfo("exception"));
        this.myInfos.add(new ExceptionTagInfo("throws"));
        this.myInfos.add(new ValueDocTagInfo());
        Collections.addAll(this.myInfos, Extensions.getExtensions(JavadocTagInfo.EP_NAME, (AreaInstance)project));
        for (CustomJavadocTagProvider extension : Extensions.getExtensions(CustomJavadocTagProvider.EP_NAME)) {
            this.myInfos.addAll(extension.getSupportedTags());
        }
    }

    @Deprecated
    public void registerTagInfo(@NotNull JavadocTagInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/JavadocManagerImpl", "registerTagInfo"));
        }
        this.myInfos.add(info);
    }

    @Override
    @NotNull
    public JavadocTagInfo[] getTagInfos(PsiElement context) {
        ArrayList<JavadocTagInfo> result2 = new ArrayList<JavadocTagInfo>();
        for (JavadocTagInfo info : this.myInfos) {
            if (!info.isValidInContext(context)) continue;
            result2.add(info);
        }
        JavadocTagInfo[] javadocTagInfoArray = result2.toArray(new JavadocTagInfo[result2.size()]);
        if (javadocTagInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/JavadocManagerImpl", "getTagInfos"));
        }
        return javadocTagInfoArray;
    }

    @Override
    @Nullable
    public JavadocTagInfo getTagInfo(String name) {
        for (JavadocTagInfo info : this.myInfos) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }
}

