/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search.searches;

import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.SimpleSmartExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.QueryExecutor;
import org.jetbrains.kotlin.com.intellij.util.QueryFactory;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class ExtensibleQueryFactory<Result, Parameters>
extends QueryFactory<Result, Parameters> {
    private final NotNullLazyValue<SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>> myPoint;

    protected ExtensibleQueryFactory() {
        this("org.jetbrains.kotlin.com.intellij");
    }

    protected ExtensibleQueryFactory(final @NonNls String epNamespace) {
        this.myPoint = new NotNullLazyValue<SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>>(){

            @Override
            @NotNull
            protected SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>> compute() {
                SimpleSmartExtensionPoint simpleSmartExtensionPoint = new SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>(new SmartList()){

                    @Override
                    @NotNull
                    protected ExtensionPoint<QueryExecutor<Result, Parameters>> getExtensionPoint() {
                        String epName = ExtensibleQueryFactory.this.getClass().getName();
                        int pos = epName.lastIndexOf(46);
                        if (pos >= 0) {
                            epName = epName.substring(pos + 1);
                        }
                        epName = epNamespace + "." + StringUtil.decapitalize(epName);
                        ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(epName);
                        if (extensionPoint == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/searches/ExtensibleQueryFactory$1$1", "getExtensionPoint"));
                        }
                        return extensionPoint;
                    }
                };
                if (simpleSmartExtensionPoint == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/searches/ExtensibleQueryFactory$1", "compute"));
                }
                return simpleSmartExtensionPoint;
            }
        };
    }

    public void registerExecutor(final QueryExecutor<Result, Parameters> queryExecutor, Disposable parentDisposable) {
        this.registerExecutor(queryExecutor);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ExtensibleQueryFactory.this.unregisterExecutor(queryExecutor);
            }
        });
    }

    @Override
    public void registerExecutor(@NotNull QueryExecutor<Result, Parameters> queryExecutor) {
        if (queryExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryExecutor", "org/jetbrains/kotlin/com/intellij/psi/search/searches/ExtensibleQueryFactory", "registerExecutor"));
        }
        this.myPoint.getValue().addExplicitExtension(queryExecutor);
    }

    @Override
    public void unregisterExecutor(@NotNull QueryExecutor<Result, Parameters> queryExecutor) {
        if (queryExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryExecutor", "org/jetbrains/kotlin/com/intellij/psi/search/searches/ExtensibleQueryFactory", "unregisterExecutor"));
        }
        this.myPoint.getValue().removeExplicitExtension(queryExecutor);
    }

    @Override
    @NotNull
    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        List<QueryExecutor<Result, Parameters>> list2 = this.myPoint.getValue().getExtensions();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/searches/ExtensibleQueryFactory", "getExecutors"));
        }
        return list2;
    }
}

