/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.Context;
import java.io.Serializable;

class UintMap
implements Serializable {
    private transient int[] keys;
    private transient Object[] values;
    private int power;
    private int keyCount;
    private transient int occupiedCount;
    private transient int ivaluesShift;

    public UintMap() {
        this(4);
    }

    public UintMap(int initialCapacity) {
        if (initialCapacity < 0) {
            Context.codeBug();
        }
        int minimalCapacity = initialCapacity * 4 / 3;
        int i = 2;
        while (1 << i < minimalCapacity) {
            ++i;
        }
        this.power = i;
    }

    public Object getObject(int key) {
        int index2;
        if (key < 0) {
            Context.codeBug();
        }
        if (this.values != null && 0 <= (index2 = this.findIndex(key))) {
            return this.values[index2];
        }
        return null;
    }

    public int getExistingInt(int key) {
        int index2;
        if (key < 0) {
            Context.codeBug();
        }
        if (0 <= (index2 = this.findIndex(key))) {
            if (this.ivaluesShift != 0) {
                return this.keys[this.ivaluesShift + index2];
            }
            return 0;
        }
        Context.codeBug();
        return 0;
    }

    public void put(int key, Object value) {
        if (key < 0) {
            Context.codeBug();
        }
        int index2 = this.ensureIndex(key, false);
        if (this.values == null) {
            this.values = new Object[1 << this.power];
        }
        this.values[index2] = value;
    }

    public void put(int key, int value) {
        if (key < 0) {
            Context.codeBug();
        }
        int index2 = this.ensureIndex(key, true);
        if (this.ivaluesShift == 0) {
            int N = 1 << this.power;
            if (this.keys.length != N * 2) {
                int[] tmp = new int[N * 2];
                System.arraycopy(this.keys, 0, tmp, 0, N);
                this.keys = tmp;
            }
            this.ivaluesShift = N;
        }
        this.keys[this.ivaluesShift + index2] = value;
    }

    public void remove(int key) {
        int index2;
        if (key < 0) {
            Context.codeBug();
        }
        if (0 <= (index2 = this.findIndex(key))) {
            this.keys[index2] = -2;
            --this.keyCount;
            if (this.values != null) {
                this.values[index2] = null;
            }
            if (this.ivaluesShift != 0) {
                this.keys[this.ivaluesShift + index2] = 0;
            }
        }
    }

    public int[] getKeys() {
        int[] keys = this.keys;
        int n = this.keyCount;
        int[] result2 = new int[n];
        int i = 0;
        while (n != 0) {
            int entry = keys[i];
            if (entry != -1 && entry != -2) {
                result2[--n] = entry;
            }
            ++i;
        }
        return result2;
    }

    private static int tableLookupStep(int fraction, int mask, int power) {
        int shift = 32 - 2 * power;
        if (shift >= 0) {
            return fraction >>> shift & mask | 1;
        }
        return fraction & mask >>> -shift | 1;
    }

    private int findIndex(int key) {
        int[] keys = this.keys;
        if (keys != null) {
            int fraction = key * -1640531527;
            int index2 = fraction >>> 32 - this.power;
            int entry = keys[index2];
            if (entry == key) {
                return index2;
            }
            if (entry != -1) {
                int mask = (1 << this.power) - 1;
                int step = UintMap.tableLookupStep(fraction, mask, this.power);
                boolean n = false;
                do {
                    if ((entry = keys[index2 = index2 + step & mask]) != key) continue;
                    return index2;
                } while (entry != -1);
            }
        }
        return -1;
    }

    private int insertNewKey(int key) {
        int[] keys = this.keys;
        int fraction = key * -1640531527;
        int index2 = fraction >>> 32 - this.power;
        if (keys[index2] != -1) {
            int mask = (1 << this.power) - 1;
            int step = UintMap.tableLookupStep(fraction, mask, this.power);
            int firstIndex = index2;
            while (keys[index2 = index2 + step & mask] != -1) {
            }
        }
        keys[index2] = key;
        ++this.occupiedCount;
        ++this.keyCount;
        return index2;
    }

    private void rehashTable(boolean ensureIntSpace) {
        if (this.keys != null && this.keyCount * 2 >= this.occupiedCount) {
            ++this.power;
        }
        int N = 1 << this.power;
        int[] old = this.keys;
        int oldShift = this.ivaluesShift;
        if (oldShift == 0 && !ensureIntSpace) {
            this.keys = new int[N];
        } else {
            this.ivaluesShift = N;
            this.keys = new int[N * 2];
        }
        for (int i = 0; i != N; ++i) {
            this.keys[i] = -1;
        }
        Object[] oldValues = this.values;
        if (oldValues != null) {
            this.values = new Object[N];
        }
        int oldCount = this.keyCount;
        this.occupiedCount = 0;
        if (oldCount != 0) {
            this.keyCount = 0;
            int i = 0;
            int remaining = oldCount;
            while (remaining != 0) {
                int key = old[i];
                if (key != -1 && key != -2) {
                    int index2 = this.insertNewKey(key);
                    if (oldValues != null) {
                        this.values[index2] = oldValues[i];
                    }
                    if (oldShift != 0) {
                        this.keys[this.ivaluesShift + index2] = old[oldShift + i];
                    }
                    --remaining;
                }
                ++i;
            }
        }
    }

    private int ensureIndex(int key, boolean intType) {
        int index2 = -1;
        int firstDeleted = -1;
        int[] keys = this.keys;
        if (keys != null) {
            int fraction = key * -1640531527;
            index2 = fraction >>> 32 - this.power;
            int entry = keys[index2];
            if (entry == key) {
                return index2;
            }
            if (entry != -1) {
                if (entry == -2) {
                    firstDeleted = index2;
                }
                int mask = (1 << this.power) - 1;
                int step = UintMap.tableLookupStep(fraction, mask, this.power);
                boolean n = false;
                do {
                    if ((entry = keys[index2 = index2 + step & mask]) == key) {
                        return index2;
                    }
                    if (entry != -2 || firstDeleted >= 0) continue;
                    firstDeleted = index2;
                } while (entry != -1);
            }
        }
        if (firstDeleted >= 0) {
            index2 = firstDeleted;
        } else {
            if (keys == null || this.occupiedCount * 4 >= (1 << this.power) * 3) {
                this.rehashTable(intType);
                return this.insertNewKey(key);
            }
            ++this.occupiedCount;
        }
        keys[index2] = key;
        ++this.keyCount;
        return index2;
    }
}

