/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.FigureTransferCommand;
import CH.ifa.draw.util.Clipboard;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;

public class PasteCommand
extends FigureTransferCommand {
    public PasteCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        Point lastClick = this.view().lastClick();
        FigureSelection selection = (FigureSelection)Clipboard.getClipboard().getContents();
        if (selection != null) {
            this.setUndoActivity(this.createUndoActivity());
            this.getUndoActivity().setAffectedFigures((FigureEnumerator)selection.getData("CH.ifa.draw.Figures"));
            if (!this.getUndoActivity().getAffectedFigures().hasMoreElements()) {
                this.setUndoActivity(null);
                return;
            }
            Rectangle r = this.bounds(this.getUndoActivity().getAffectedFigures());
            this.view().clearSelection();
            FigureEnumeration fe = this.insertFigures(this.getUndoActivity().getAffectedFigures(), lastClick.x - r.x, lastClick.y - r.y);
            this.getUndoActivity().setAffectedFigures(fe);
            this.view().checkDamage();
        }
    }

    public boolean isExecutableWithView() {
        return Clipboard.getClipboard().getContents() != null;
    }

    Rectangle bounds(Enumeration k) {
        Rectangle r = ((Figure)k.nextElement()).displayBox();
        while (k.hasMoreElements()) {
            r.add(((Figure)k.nextElement()).displayBox());
        }
        return r;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasMoreElements()) {
                this.getDrawingView().drawing().orphan(fe.nextFigure());
            }
            this.getDrawingView().clearSelection();
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.setAffectedFigures(this.getDrawingView().insertFigures(this.getAffectedFigures(), 0, 0, false));
            return true;
        }
    }
}

