/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.jfree.layouting.DefaultLayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.swing.Converter;
import org.jfree.layouting.input.swing.ConverterAttributeSet;
import org.jfree.layouting.input.swing.converter.CharacterConverter;
import org.jfree.layouting.input.swing.converter.ColorConverter;
import org.jfree.layouting.input.swing.converter.DocumentConverter;
import org.jfree.layouting.input.swing.converter.FontConverter;
import org.jfree.layouting.input.swing.converter.ParagraphConverter;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.feed.InputFeedException;
import org.jfree.layouting.modules.output.html.StreamingHtmlOutputProcessor;

public class SwingDocumentImport {
    public static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final String STYLESHEET_TYPE = "type";
    public static final String STYLESHEET_PCDATA = "#pcdata";
    public static final String STYLESHEET = "stylesheet";
    public static final String ELEMENT_STYLE_ATTRIBUTE = "style";
    private Map styleNames = new HashMap();
    private InputFeed feed;
    private static Map styleConstantsMap = new HashMap();

    public InputFeed getFeed() {
        return this.feed;
    }

    public void setFeed(InputFeed inputFeed) {
        this.feed = inputFeed;
    }

    private String convertStyleName(String string) {
        return string;
    }

    public String getNormalizedStyleName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The style name must not be null");
        }
        String string2 = (String)this.styleNames.get(string);
        if (string2 == null) {
            string2 = this.convertStyleName(string);
            if (string2 == null) {
                throw new IllegalStateException("Unable to convert style name");
            }
            String string3 = this.styleNames.put(string, string2);
            if (string3 != null) {
                throw new IllegalStateException("Style name clash during convertion");
            }
        }
        return string2;
    }

    public ConverterAttributeSet convertAttributes(AttributeSet attributeSet, Element element) throws InputFeedException {
        ConverterAttributeSet converterAttributeSet = new ConverterAttributeSet();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            Converter converter = (Converter)styleConstantsMap.get(obj);
            if (converter != null) {
                ConverterAttributeSet converterAttributeSet2 = converter.convertToCSS(obj, object, converterAttributeSet, element);
                if (converterAttributeSet2 != null) {
                    converterAttributeSet.addAttributes(converterAttributeSet2);
                    continue;
                }
                this.debugAttribut("No convertion for ", obj, object);
                converterAttributeSet.addAttribute(obj, object);
                continue;
            }
            this.debugAttribut("No converter for ", obj, object);
            converterAttributeSet.addAttribute(obj, object);
        }
        return converterAttributeSet;
    }

    private void debugAttribut(String string, Object object, Object object2) {
        System.out.println(string + "attribute [" + object.getClass().getName() + "] " + object + " = " + object2 + " [" + object2.getClass().getName() + ']');
    }

    protected void handleElement(Element element) throws BadLocationException, InputFeedException {
        Object object;
        if (element == null) {
            return;
        }
        System.out.println("Stating Element: " + element.getName());
        this.feed.startElement(NAMESPACE, element.getName());
        AttributeSet attributeSet = element.getAttributes();
        ConverterAttributeSet converterAttributeSet = this.convertAttributes(attributeSet, element);
        Enumeration<?> enumeration = converterAttributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Object object2 = converterAttributeSet.getAttribute(object);
            if (object == StyleConstants.NameAttribute) continue;
            if (object == StyleConstants.ResolveAttribute && object2 instanceof Style) {
                Style style = (Style)object2;
                this.feed.setAttribute(NAMESPACE, ELEMENT_STYLE_ATTRIBUTE, this.getNormalizedStyleName(style.getName()));
                continue;
            }
            this.debugAttribut("Element ", object, object2);
            this.feed.setAttribute(NAMESPACE, object.toString(), object2);
        }
        object = this.getElementText(element);
        if ((object != null || !"".equals(object)) && element.isLeaf()) {
            System.out.println("" + '\'' + object + '\'');
            this.feed.addContent((String)object);
        }
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            this.handleElement(element2);
        }
        this.feed.endElement();
    }

    protected String getElementText(Element element) throws BadLocationException {
        Document document = element.getDocument();
        String string = document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        return string;
    }

    protected void processStyleElements(DefaultStyledDocument defaultStyledDocument) throws InputFeedException {
        Enumeration<?> enumeration = defaultStyledDocument.getStyleNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Style style = defaultStyledDocument.getStyle(string);
            if (style == null) continue;
            String string2 = this.getNormalizedStyleName(string);
            System.out.println("Processing style: " + string + '(' + string2 + ')');
            ConverterAttributeSet converterAttributeSet = this.convertAttributes(style, null);
            Enumeration<?> enumeration2 = converterAttributeSet.getAttributeNames();
            StringBuffer stringBuffer = new StringBuffer(converterAttributeSet.getAttributeCount() * 4 + 5);
            this.feed.startMetaNode();
            stringBuffer.append(string2);
            stringBuffer.append(' ');
            stringBuffer.append(this.getParentSelector(style.getResolveParent()));
            stringBuffer.append("{\n");
            while (enumeration2.hasMoreElements()) {
                Object obj = enumeration2.nextElement();
                Object object = converterAttributeSet.getAttribute(obj);
                if (obj == StyleConstants.NameAttribute || obj == StyleConstants.ResolveAttribute) continue;
                this.debugAttribut("Style ", obj, object);
                stringBuffer.append(obj.toString());
                stringBuffer.append(':');
                stringBuffer.append(object.toString());
                stringBuffer.append(";\n");
            }
            stringBuffer.append('}');
            this.feed.setMetaNodeAttribute(STYLESHEET_TYPE, STYLESHEET);
            this.feed.setMetaNodeAttribute(STYLESHEET_PCDATA, stringBuffer.toString());
            this.feed.endMetaNode();
        }
    }

    private String getParentSelector(AttributeSet attributeSet) {
        if (attributeSet != null) {
            Object object = attributeSet.getAttribute(StyleConstants.ResolveAttribute);
            if (object != null) {
                Style style = (Style)object;
                return this.getNormalizedStyleName(style.getName()) + ' ' + this.getParentSelector(attributeSet.getResolveParent());
            }
        } else {
            return "";
        }
        return "";
    }

    protected void processDocumentProperties(DefaultStyledDocument defaultStyledDocument) throws InputFeedException {
        Object object;
        Object object2;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Dictionary<Object, Object> dictionary = defaultStyledDocument.getDocumentProperties();
        Enumeration<Object> enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = dictionary.get(object2);
            simpleAttributeSet.addAttribute(object2, object);
        }
        object2 = this.convertAttributes(simpleAttributeSet, null);
        this.processRules((ConverterAttributeSet)object2);
        object = ((ConverterAttributeSet)object2).getAttributesByType("not_typed");
        Enumeration<?> enumeration2 = object.getAttributeNames();
        while (enumeration2.hasMoreElements()) {
            Object obj = enumeration2.nextElement();
            Object object3 = object.getAttribute(obj);
            this.debugAttribut("Document Property ", obj, object3);
            this.feed.addDocumentAttribute(obj.toString(), object3);
        }
    }

    private void processRules(ConverterAttributeSet converterAttributeSet) throws InputFeedException {
        AttributeSet attributeSet = converterAttributeSet.getAttributesByType("@page");
        if (attributeSet.getAttributeCount() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("@page {\n");
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = attributeSet.getAttribute(obj);
                this.debugAttribut("Page rule attribute ", obj, object);
                stringBuffer.append(obj.toString());
                stringBuffer.append(':');
                stringBuffer.append(object.toString());
                stringBuffer.append(";\n");
            }
            stringBuffer.append('}');
            this.feed.startMetaNode();
            this.feed.setMetaNodeAttribute(STYLESHEET_TYPE, STYLESHEET);
            this.feed.setMetaNodeAttribute(STYLESHEET_PCDATA, stringBuffer.toString());
            this.feed.endMetaNode();
        }
    }

    public void parseDocument(DefaultStyledDocument defaultStyledDocument, InputFeed inputFeed) throws BadLocationException, InputFeedException {
        this.setFeed(inputFeed);
        inputFeed.startDocument();
        inputFeed.startMetaInfo();
        this.processDocumentProperties(defaultStyledDocument);
        this.processStyleElements(defaultStyledDocument);
        inputFeed.endMetaInfo();
        this.handleElement(defaultStyledDocument.getDefaultRootElement());
        inputFeed.endDocument();
    }

    public static void main(String[] stringArray) throws IOException, BadLocationException, InputFeedException {
        URL uRL = new URL("http://interglacial.com/rtf/rtf_book_examples/example_documents/p060_landscape_a4.rtf");
        uRL.getContent();
        JEditorPane jEditorPane = new JEditorPane(uRL);
        jEditorPane.setEditable(false);
        JFrame jFrame = new JFrame("HTML Viewer");
        jFrame.setSize(800, 600);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jEditorPane, 20, 30);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setVisible(true);
        LibLayoutBoot.getInstance().start();
        long l = System.currentTimeMillis();
        StreamingHtmlOutputProcessor streamingHtmlOutputProcessor = new StreamingHtmlOutputProcessor(LibLayoutBoot.getInstance().getGlobalConfig());
        DefaultLayoutProcess defaultLayoutProcess = new DefaultLayoutProcess(streamingHtmlOutputProcessor);
        SwingDocumentImport swingDocumentImport = new SwingDocumentImport();
        swingDocumentImport.parseDocument((DefaultStyledDocument)jEditorPane.getDocument(), defaultLayoutProcess.getInputFeed());
        long l2 = System.currentTimeMillis();
        System.out.println("Done!: " + (l2 - l));
    }

    static {
        FontConverter fontConverter = new FontConverter();
        styleConstantsMap.put(StyleConstants.FontFamily, fontConverter);
        styleConstantsMap.put(StyleConstants.FontSize, fontConverter);
        styleConstantsMap.put(StyleConstants.Bold, fontConverter);
        styleConstantsMap.put(StyleConstants.Italic, fontConverter);
        ParagraphConverter paragraphConverter = new ParagraphConverter();
        styleConstantsMap.put(StyleConstants.Alignment, paragraphConverter);
        styleConstantsMap.put(StyleConstants.LeftIndent, paragraphConverter);
        styleConstantsMap.put(StyleConstants.RightIndent, paragraphConverter);
        styleConstantsMap.put(StyleConstants.SpaceAbove, paragraphConverter);
        styleConstantsMap.put(StyleConstants.SpaceBelow, paragraphConverter);
        styleConstantsMap.put(StyleConstants.FirstLineIndent, paragraphConverter);
        CharacterConverter characterConverter = new CharacterConverter();
        styleConstantsMap.put(StyleConstants.Underline, characterConverter);
        styleConstantsMap.put(StyleConstants.StrikeThrough, characterConverter);
        styleConstantsMap.put(StyleConstants.BidiLevel, characterConverter);
        styleConstantsMap.put(StyleConstants.Superscript, characterConverter);
        styleConstantsMap.put(StyleConstants.Subscript, characterConverter);
        styleConstantsMap.put("caps", characterConverter);
        styleConstantsMap.put("scaps", characterConverter);
        styleConstantsMap.put("outl", characterConverter);
        ColorConverter colorConverter = new ColorConverter();
        styleConstantsMap.put(StyleConstants.Foreground, colorConverter);
        styleConstantsMap.put(StyleConstants.Background, colorConverter);
        DocumentConverter documentConverter = new DocumentConverter();
        styleConstantsMap.put("paperw", documentConverter);
        styleConstantsMap.put("paperh", documentConverter);
        styleConstantsMap.put("margb", documentConverter);
        styleConstantsMap.put("margl", documentConverter);
        styleConstantsMap.put("margr", documentConverter);
        styleConstantsMap.put("margt", documentConverter);
        styleConstantsMap.put("landscape", documentConverter);
    }
}

