/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.reportbuilder.layout;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.WrappedTargetRuntimeException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.report.XFixedText;
import com.sun.star.report.XFormattedField;
import com.sun.star.report.XGroup;
import com.sun.star.report.XGroups;
import com.sun.star.report.XReportDefinition;
import com.sun.star.report.XSection;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.reportbuilder.layout.SectionEmptyObject;
import com.sun.star.wizards.reportbuilder.layout.SectionLabel;
import com.sun.star.wizards.reportbuilder.layout.SectionObject;
import com.sun.star.wizards.reportbuilder.layout.SectionTextField;

public class DesignTemplate {
    private XReportDefinition m_xReportDefinition;
    private SectionObject m_aDetailLabel;
    private SectionObject m_aDetailTextField;
    private SectionObject[] m_aGroupLabel;
    private SectionObject[] m_aGroupTextField;

    private DesignTemplate() {
    }

    XGroups getGroups() {
        return this.m_xReportDefinition.getGroups();
    }

    XSection getDetail() {
        return this.m_xReportDefinition.getDetail();
    }

    boolean getReportHeaderOn() {
        return this.m_xReportDefinition.getReportHeaderOn();
    }

    XSection getReportHeader() throws NoSuchElementException {
        return this.m_xReportDefinition.getReportHeader();
    }

    boolean getReportFooterOn() {
        return this.m_xReportDefinition.getReportFooterOn();
    }

    XSection getReportFooter() throws NoSuchElementException {
        return this.m_xReportDefinition.getReportFooter();
    }

    boolean getPageHeaderOn() {
        return this.m_xReportDefinition.getPageHeaderOn();
    }

    XSection getPageHeader() throws NoSuchElementException {
        return this.m_xReportDefinition.getPageHeader();
    }

    boolean getPageFooterOn() {
        return this.m_xReportDefinition.getPageFooterOn();
    }

    XSection getPageFooter() throws NoSuchElementException {
        return this.m_xReportDefinition.getPageFooter();
    }

    SectionObject getDetailLabel() {
        if (this.m_aDetailLabel == null) {
            return SectionEmptyObject.create();
        }
        return this.m_aDetailLabel;
    }

    SectionObject getDetailTextField() {
        if (this.m_aDetailTextField == null) {
            return SectionEmptyObject.create();
        }
        return this.m_aDetailTextField;
    }

    SectionObject getGroupTextField(int _nGroup) {
        return this.getGroupSectionObject(this.m_aGroupTextField, _nGroup);
    }

    SectionObject getGroupLabel(int _nGroup) {
        return this.getGroupSectionObject(this.m_aGroupLabel, _nGroup);
    }

    private SectionObject getGroupSectionObject(SectionObject[] _aGroupList, int _nGroup) {
        SectionObject a = null;
        if (_nGroup < _aGroupList.length) {
            a = _aGroupList[_nGroup];
        } else if (_aGroupList.length > 0) {
            a = _aGroupList[_aGroupList.length - 1];
        }
        if (a == null) {
            a = SectionEmptyObject.create();
            a.setPropertyValue("CharWeight", new Float(150.0f));
        }
        return a;
    }

    private void analyseReportDefinition() {
        XSection xDetailSection = this.m_xReportDefinition.getDetail();
        int nDetailCount = xDetailSection.getCount();
        for (int i = 0; i < nDetailCount; ++i) {
            try {
                Object aObj = xDetailSection.getByIndex(i);
                XFixedText aFixedText = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)aObj);
                if (aFixedText != null && this.m_aDetailLabel == null) {
                    this.m_aDetailLabel = SectionLabel.create(aFixedText);
                    continue;
                }
                XFormattedField aFormattedField = (XFormattedField)UnoRuntime.queryInterface(XFormattedField.class, (Object)aObj);
                if (aFormattedField == null || this.m_aDetailTextField != null) continue;
                this.m_aDetailTextField = SectionTextField.create(aFormattedField);
                continue;
            }
            catch (IndexOutOfBoundsException aObj) {
                continue;
            }
            catch (WrappedTargetException aObj) {
                // empty catch block
            }
        }
        XGroups xGroups = this.m_xReportDefinition.getGroups();
        int nGroupCount = xGroups.getCount();
        this.m_aGroupLabel = new SectionObject[nGroupCount];
        this.m_aGroupTextField = new SectionObject[nGroupCount];
        for (int nGroup = 0; nGroup < nGroupCount; ++nGroup) {
            try {
                Object aGroup = xGroups.getByIndex(nGroup);
                XGroup xGroup = (XGroup)UnoRuntime.queryInterface(XGroup.class, (Object)aGroup);
                XSection xGroupSection = xGroup.getHeader();
                int nCount = xGroupSection.getCount();
                for (int i = 0; i < nCount; ++i) {
                    try {
                        Object aObj = xGroupSection.getByIndex(i);
                        XFixedText aFixedText = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)aObj);
                        if (aFixedText != null && this.m_aGroupLabel[nGroup] == null) {
                            this.m_aGroupLabel[nGroup] = SectionLabel.create(aFixedText);
                            continue;
                        }
                        XFormattedField aFormattedField = (XFormattedField)UnoRuntime.queryInterface(XFormattedField.class, (Object)aObj);
                        if (aFormattedField == null || this.m_aGroupTextField[nGroup] != null) continue;
                        this.m_aGroupTextField[nGroup] = SectionTextField.create(aFormattedField);
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        continue;
                    }
                    catch (WrappedTargetException wrappedTargetException) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            catch (WrappedTargetException wrappedTargetException) {
                // empty catch block
            }
        }
    }

    void close() {
        try {
            this.m_xReportDefinition.close(true);
        }
        catch (CloseVetoException closeVetoException) {
            // empty catch block
        }
    }

    public static DesignTemplate create(XMultiServiceFactory _xMSF, String _sPath) {
        DesignTemplate a = new DesignTemplate();
        try {
            a.load(_xMSF, _sPath);
        }
        catch (WrappedTargetRuntimeException e) {
            a = null;
            throw new RuntimeException(e);
        }
        catch (com.sun.star.uno.Exception e) {
            a = null;
        }
        catch (Exception e) {
            a = null;
        }
        return a;
    }

    private void load(XMultiServiceFactory _xMSF, String _sPath) throws com.sun.star.uno.Exception {
        Object aObj = _xMSF.createInstance("com.sun.star.report.ReportDefinition");
        this.m_xReportDefinition = (XReportDefinition)UnoRuntime.queryInterface(XReportDefinition.class, (Object)aObj);
        PropertyValue[] aLoadProps = new PropertyValue[]{Properties.createProperty(PropertyNames.URL, _sPath), Properties.createProperty(PropertyNames.READ_ONLY, Boolean.TRUE)};
        this.m_xReportDefinition.load(aLoadProps);
        this.analyseReportDefinition();
    }
}

