/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTargetUtil;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.report.util.AttributeNameGenerator;
import org.jfree.report.util.IntegerCache;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.pentaho.model.OfficeMasterPage;
import org.libreoffice.report.pentaho.model.OfficeMasterStyles;
import org.libreoffice.report.pentaho.model.OfficeStyle;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.model.OfficeStylesCollection;
import org.libreoffice.report.pentaho.model.PageSection;
import org.libreoffice.report.pentaho.output.OfficeDocumentReportTarget;
import org.libreoffice.report.pentaho.output.StyleUtilities;
import org.libreoffice.report.pentaho.output.text.MasterPageFactory;
import org.libreoffice.report.pentaho.output.text.PageBreakDefinition;
import org.libreoffice.report.pentaho.output.text.PageContext;
import org.libreoffice.report.pentaho.output.text.VariablesDeclarations;
import org.libreoffice.report.pentaho.styles.LengthCalculator;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class TextRawReportTarget
extends OfficeDocumentReportTarget {
    private static final String ALWAYS = "always";
    private static final String KEEP_TOGETHER = "keep-together";
    private static final String KEEP_WITH_NEXT = "keep-with-next";
    private static final String MAY_BREAK_BETWEEN_ROWS = "may-break-between-rows";
    private static final String NAME = "name";
    private static final String NONE = "none";
    private static final String NORMAL = "normal";
    private static final String PARAGRAPH_PROPERTIES = "paragraph-properties";
    private static final String STANDARD = "Standard";
    private static final String TABLE_PROPERTIES = "table-properties";
    private static final String VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT = "variables_paragraph_with_next";
    private static final String VARIABLES_HIDDEN_STYLE_WITHOUT_KEEPWNEXT = "variables_paragraph_without_next";
    private static final int TABLE_LAYOUT_VARIABLES_PARAGRAPH = 0;
    private static final int TABLE_LAYOUT_SINGLE_DETAIL_TABLE = 2;
    private static final int CP_SETUP = 0;
    private static final int CP_FIRST_TABLE = 1;
    private static final int CP_NEXT_TABLE = 2;
    private static final int DETAIL_SECTION_WAIT = 0;
    private static final int DETAIL_SECTION_FIRST_STARTED = 1;
    private static final int DETAIL_SECTION_FIRST_PRINTED = 2;
    private static final int DETAIL_SECTION_OTHER_STARTED = 3;
    private static final int DETAIL_SECTION_OTHER_PRINTED = 4;
    private boolean pageFooterOnReportFooter;
    private boolean pageFooterOnReportHeader;
    private boolean pageHeaderOnReportFooter;
    private boolean pageHeaderOnReportHeader;
    private int contentProcessingState;
    private OfficeMasterPage currentMasterPage;
    private final FastStack activePageContext = new FastStack();
    private MasterPageFactory masterPageFactory;
    private LengthCalculator sectionHeight;
    private String variables;
    private PageBreakDefinition pageBreakDefinition;
    private VariablesDeclarations variablesDeclarations;
    private boolean columnBreakPending;
    private boolean sectionKeepTogether;
    private final AttributeNameGenerator sectionNames = new AttributeNameGenerator();
    private int detailBandProcessingState;
    private final int tableLayoutConfig;
    private int expectedTableRowCount;
    private boolean firstCellSeen;

    public TextRawReportTarget(ReportJob reportJob, ResourceManager resourceManager, ResourceKey baseResource, InputRepository inputRepository, OutputRepository outputRepository, String target, ImageService imageService, DataSourceFactory datasourcefactory) throws ReportProcessingException {
        super(reportJob, resourceManager, baseResource, inputRepository, outputRepository, target, imageService, datasourcefactory);
        this.tableLayoutConfig = 2;
    }

    protected String getTargetMimeType() {
        return "application/vnd.oasis.opendocument.text";
    }

    private boolean isPagebreakPending() {
        return this.pageBreakDefinition != null;
    }

    private boolean isResetPageNumber() {
        return this.pageBreakDefinition != null && this.pageBreakDefinition.isResetPageNumber();
    }

    private void setPagebreakDefinition(PageBreakDefinition pageBreakDefinition) {
        this.pageBreakDefinition = pageBreakDefinition;
    }

    private PageBreakDefinition getPagebreakDefinition() {
        return this.pageBreakDefinition;
    }

    private boolean isKeepTableWithNext() {
        int keepTogetherState = this.getCurrentContext().getKeepTogether();
        if (keepTogetherState == 1) {
            return true;
        }
        boolean keepWithNext = keepTogetherState == 2 && this.detailBandProcessingState == 0;
        return keepWithNext;
    }

    private boolean isSectionPagebreakAfter(AttributeMap attrs) {
        Object forceNewPage = attrs.getAttribute("http://openoffice.org/2005/report", "force-new-page");
        return "after-section".equals(forceNewPage) || "before-after-section".equals(forceNewPage);
    }

    private boolean isSectionPagebreakBefore(AttributeMap attrs) {
        Object forceNewPage = attrs.getAttribute("http://openoffice.org/2005/report", "force-new-page");
        return "before-section".equals(forceNewPage) || "before-after-section".equals(forceNewPage);
    }

    private PageContext getCurrentContext() {
        return (PageContext)this.activePageContext.peek();
    }

    private String createMasterPage(boolean printHeader, boolean printFooter) throws ReportProcessingException {
        String masterPageName;
        PageContext context = this.getCurrentContext();
        String activePageFooter = printFooter ? context.getPageFooterContent() : null;
        String activePageHeader = printHeader ? context.getPageHeaderContent() : null;
        if (this.currentMasterPage == null || !this.masterPageFactory.containsMasterPage(STANDARD, activePageHeader, activePageFooter)) {
            CSSNumericValue headerSize = context.getAllHeaderSize();
            CSSNumericValue footerSize = context.getAllFooterSize();
            this.currentMasterPage = this.masterPageFactory.createMasterPage(STANDARD, activePageHeader, activePageFooter);
            OfficeStylesCollection officeStylesCollection = this.getGlobalStylesCollection();
            OfficeMasterStyles officeMasterStyles = officeStylesCollection.getMasterStyles();
            String pageLayoutTemplate = this.currentMasterPage.getPageLayout();
            if (pageLayoutTemplate == null) {
                String derivedLayout = this.masterPageFactory.createPageStyle(this.getGlobalStylesCollection().getAutomaticStyles(), headerSize, footerSize);
                this.currentMasterPage.setPageLayout(derivedLayout);
            } else {
                String derivedLayout = this.masterPageFactory.derivePageStyle(pageLayoutTemplate, this.getPredefinedStylesCollection().getAutomaticStyles(), this.getGlobalStylesCollection().getAutomaticStyles(), headerSize, footerSize);
                this.currentMasterPage.setPageLayout(derivedLayout);
            }
            officeMasterStyles.addMasterPage(this.currentMasterPage);
            masterPageName = this.currentMasterPage.getStyleName();
        } else {
            OfficeMasterPage masterPage = this.masterPageFactory.getMasterPage(STANDARD, activePageHeader, activePageFooter);
            if (ObjectUtilities.equal((Object)masterPage.getStyleName(), (Object)this.currentMasterPage.getStyleName())) {
                masterPageName = null;
            } else {
                this.currentMasterPage = masterPage;
                masterPageName = this.currentMasterPage.getStyleName();
            }
        }
        if (!printHeader && context.getHeader() != null || !printFooter && context.getFooter() != null) {
            this.setPagebreakDefinition(new PageBreakDefinition(this.isResetPageNumber()));
        }
        return masterPageName;
    }

    private boolean isColumnBreakPending() {
        return this.columnBreakPending;
    }

    private void setColumnBreakPending(boolean columnBreakPending) {
        this.columnBreakPending = columnBreakPending;
    }

    private Integer parseInt(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return IntegerCache.getInteger(n.intValue());
        }
        if (value instanceof String) {
            try {
                return IntegerCache.getInteger(Integer.parseInt((String)value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private OfficeDocumentReportTarget.BufferState applyColumnsToPageBand(OfficeDocumentReportTarget.BufferState contents, int numberOfColumns) throws IOException, ReportProcessingException {
        if (numberOfColumns <= 1) {
            return contents;
        }
        this.startBuffering(this.getGlobalStylesCollection(), true);
        XmlWriter writer = this.getXmlWriter();
        AttributeList attrs = new AttributeList();
        attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name", this.generateSectionStyle(numberOfColumns));
        attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME, this.sectionNames.generateName("Section"));
        writer.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "section", attrs, false);
        for (int i = 0; i < numberOfColumns; ++i) {
            writer.writeStream(contents.getXmlAsReader());
        }
        writer.writeCloseTag();
        return this.finishBuffering();
    }

    private String generateSectionStyle(int columnCount) {
        OfficeStyles automaticStyles = this.getStylesCollection().getAutomaticStyles();
        String styleName = this.getAutoStyleNameGenerator().generateName("auto_section_style");
        Section sectionProperties = new Section();
        sectionProperties.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        sectionProperties.setType("section-properties");
        sectionProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", "transparent");
        sectionProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "dont-balance-text-columns", "false");
        sectionProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "editable", "false");
        if (columnCount > 1) {
            Section columns = new Section();
            columns.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            columns.setType("columns");
            columns.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "column-count", String.valueOf(columnCount));
            columns.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "column-gap", "0cm");
            sectionProperties.addNode(columns);
            for (int i = 0; i < columnCount; ++i) {
                Section column = new Section();
                column.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                column.setType("column");
                column.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "rel-width", "1*");
                column.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "start-indent", "0cm");
                column.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "end-indent", "0cm");
                columns.addNode(column);
            }
        }
        OfficeStyle style = new OfficeStyle();
        style.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        style.setType("style");
        style.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", NAME, styleName);
        style.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "family", "section");
        style.addNode(sectionProperties);
        automaticStyles.addStyle(style);
        return styleName;
    }

    public void startReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        super.startReport(report);
        this.variablesDeclarations = new VariablesDeclarations();
        this.detailBandProcessingState = 0;
        this.sectionNames.reset();
        this.pageFooterOnReportFooter = false;
        this.pageFooterOnReportHeader = false;
        this.pageHeaderOnReportFooter = false;
        this.pageHeaderOnReportHeader = false;
        this.contentProcessingState = 0;
        this.activePageContext.clear();
        this.activePageContext.push((Object)new PageContext());
        OfficeStylesCollection predefStyles = this.getPredefinedStylesCollection();
        this.masterPageFactory = new MasterPageFactory(predefStyles.getMasterStyles());
        predefStyles.getAutomaticStyles().addStyle(this.createVariablesStyle(true));
        predefStyles.getAutomaticStyles().addStyle(this.createVariablesStyle(false));
    }

    private OfficeStyle createVariablesStyle(boolean keepWithNext) {
        OfficeStyle variablesSectionStyle = new OfficeStyle();
        variablesSectionStyle.setStyleFamily("paragraph");
        if (keepWithNext) {
            variablesSectionStyle.setStyleName(VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT);
        } else {
            variablesSectionStyle.setStyleName(VARIABLES_HIDDEN_STYLE_WITHOUT_KEEPWNEXT);
        }
        Section paragraphProps = new Section();
        paragraphProps.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        paragraphProps.setType(PARAGRAPH_PROPERTIES);
        paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", "transparent");
        paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "text-align", "start");
        paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_WITH_NEXT, ALWAYS);
        paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_TOGETHER, ALWAYS);
        paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "vertical-align", "top");
        variablesSectionStyle.addNode(paragraphProps);
        Section textProps = new Section();
        textProps.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        textProps.setType("text-properties");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-variant", NORMAL);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "text-transform", NONE);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "color", "#ffffff");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-outline", "false");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-blinking", "false");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-line-through-style", NONE);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-line-through-mode", "continuous");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-position", "0% 100%");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-name", "Tahoma");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-size", "1pt");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "letter-spacing", NORMAL);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "letter-kerning", "false");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-style", NORMAL);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "text-shadow", NONE);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-underline-style", NONE);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-underline-mode", "continuous");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-weight", NORMAL);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-rotation-angle", "0");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-emphasize", NONE);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-combine", NONE);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-combine-start-char", "");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-combine-end-char", "");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-blinking", "false");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-scale", "100%");
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-relief", NONE);
        textProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-display", NONE);
        variablesSectionStyle.addNode(textProps);
        return variablesSectionStyle;
    }

    protected void startContent(AttributeMap attrs) throws IOException, DataSourceException, ReportProcessingException {
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "text", null, false);
        this.writeNullDate();
        this.startBuffering(this.getStylesCollection(), true);
        Object columnCountRaw = attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "column-count");
        Integer colCount = this.parseInt(columnCountRaw);
        if (colCount != null) {
            PageContext pageContext = this.getCurrentContext();
            pageContext.setColumnCount(colCount);
        }
    }

    protected void startOther(AttributeMap attrs) throws IOException, DataSourceException, ReportProcessingException {
        String namespace = ReportTargetUtil.getNamespaceFromAttribute(attrs);
        String elementType = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
        if (ObjectUtilities.equal((Object)"http://jfreereport.sourceforge.net/namespaces/engine", (Object)namespace)) {
            if (ObjectUtilities.equal((Object)"image", (Object)elementType)) {
                this.startImageProcessing(attrs);
            } else if (ObjectUtilities.equal((Object)"object-ole", (Object)elementType) && this.getCurrentRole() != 11) {
                this.startChartProcessing(attrs);
            }
            return;
        }
        if (this.isFilteredNamespace(namespace)) {
            throw new IllegalStateException("This element should be hidden: " + namespace + ", " + elementType);
        }
        if (this.isTableMergeActive() && this.detailBandProcessingState == 4 && ObjectUtilities.equal((Object)"urn:oasis:names:tc:opendocument:xmlns:table:1.0", (Object)namespace) && ObjectUtilities.equal((Object)"table-columns", (Object)elementType)) {
            this.startBuffering(this.getStylesCollection(), true);
        } else {
            this.openSection();
            boolean isTableNS = ObjectUtilities.equal((Object)"urn:oasis:names:tc:opendocument:xmlns:table:1.0", (Object)namespace);
            if (isTableNS) {
                if (ObjectUtilities.equal((Object)"table", (Object)elementType)) {
                    this.startTable(attrs);
                    return;
                }
                if (ObjectUtilities.equal((Object)"table-row", (Object)elementType)) {
                    this.startRow(attrs);
                    return;
                }
            }
            if (ObjectUtilities.equal((Object)"urn:oasis:names:tc:opendocument:xmlns:text:1.0", (Object)namespace)) {
                String newVarName;
                String varType;
                String varName;
                if (ObjectUtilities.equal((Object)"variable-set", (Object)elementType)) {
                    varName = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME);
                    varType = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type");
                    newVarName = this.variablesDeclarations.produceVariable(varName, varType);
                    attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME, (Object)newVarName);
                } else if (ObjectUtilities.equal((Object)"variable-get", (Object)elementType)) {
                    varName = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME);
                    varType = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type");
                    newVarName = this.variablesDeclarations.produceVariable(varName, varType);
                    attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME, (Object)newVarName);
                }
            }
            if (this.tableLayoutConfig == 0 && this.variables != null) {
                StyleUtilities.copyStyle("paragraph", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT, this.getStylesCollection(), this.getGlobalStylesCollection(), this.getPredefinedStylesCollection());
                XmlWriter xmlWriter = this.getXmlWriter();
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", "style-name", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT, false);
                xmlWriter.writeText(this.variables);
                xmlWriter.writeCloseTag();
                this.variables = null;
            }
            boolean keepTogetherOnParagraph = true;
            if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", attrs)) {
                int keepTogetherState = this.getCurrentContext().getKeepTogether();
                if (!this.firstCellSeen && (this.sectionKeepTogether || keepTogetherState == 1)) {
                    OfficeStyle style = null;
                    String styleName = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name");
                    if (styleName == null) {
                        boolean keep = (keepTogetherState == 1 || this.expectedTableRowCount > 0) && this.isParentKeepTogether();
                        ArrayList<String> propertyNameSpaces = new ArrayList<String>();
                        ArrayList<String> propertyNames = new ArrayList<String>();
                        ArrayList<String> propertyValues = new ArrayList<String>();
                        propertyNameSpaces.add("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
                        propertyNameSpaces.add("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
                        propertyNames.add(KEEP_TOGETHER);
                        propertyValues.add(ALWAYS);
                        if (keep) {
                            propertyNames.add(KEEP_WITH_NEXT);
                            propertyValues.add(ALWAYS);
                        } else {
                            propertyNames.add(KEEP_WITH_NEXT);
                            propertyValues.add(null);
                        }
                        style = StyleUtilities.queryStyleByProperties(this.getStylesCollection(), "paragraph", PARAGRAPH_PROPERTIES, propertyNameSpaces, propertyNames, propertyValues);
                    }
                    if (style == null) {
                        style = this.deriveStyle("paragraph", styleName);
                        Element paragraphProps = style.getParagraphProperties();
                        if (paragraphProps == null) {
                            paragraphProps = new Section();
                            paragraphProps.setNamespace("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                            paragraphProps.setType(PARAGRAPH_PROPERTIES);
                            style.addNode(paragraphProps);
                        }
                        paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_TOGETHER, ALWAYS);
                        if ((keepTogetherState == 1 || this.expectedTableRowCount > 0) && this.isParentKeepTogether()) {
                            paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_WITH_NEXT, ALWAYS);
                        }
                    }
                    attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name", (Object)style.getStyleName());
                }
            }
            if (ObjectUtilities.equal((Object)"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", (Object)namespace) && ObjectUtilities.equal((Object)"frame", (Object)elementType)) {
                String styleName = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "style-name");
                OfficeStyle predefAutoStyle = this.getPredefinedStylesCollection().getAutomaticStyles().getStyle("graphic", styleName);
                if (predefAutoStyle != null) {
                    Element graphicProperties = predefAutoStyle.getGraphicProperties();
                    graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "vertical-pos", "from-top");
                    graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "horizontal-pos", "from-left");
                    graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "vertical-rel", "paragraph-content");
                    graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "horizontal-rel", "paragraph");
                    graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "flow-with-text", "false");
                    graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "ole-draw-aspect", "1");
                }
            }
            this.performStyleProcessing(attrs);
            XmlWriter xmlWriter = this.getXmlWriter();
            AttributeList attrList = this.buildAttributeList(attrs);
            xmlWriter.writeTag(namespace, elementType, attrList, false);
            if (this.tableLayoutConfig != 0 && this.variables != null && !this.isRepeatingSection() && ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", attrs)) {
                xmlWriter.writeText(this.variables);
                this.variables = null;
            }
        }
    }

    private void startRow(AttributeMap attrs) throws IOException, ReportProcessingException {
        this.firstCellSeen = false;
        --this.expectedTableRowCount;
        String rowStyle = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        CSSNumericValue rowHeight = this.computeRowHeight(rowStyle);
        this.sectionHeight.add(rowHeight);
        this.performStyleProcessing(attrs);
        AttributeList attrList = this.buildAttributeList(attrs);
        this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-row", attrList, false);
    }

    private void startTable(AttributeMap attrs) throws ReportProcessingException, IOException {
        OfficeStyle style;
        String styleName;
        PageBreakDefinition breakDefinition;
        Integer trc = (Integer)attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "table-row-count");
        this.expectedTableRowCount = trc == null ? -1 : trc;
        if (this.isSectionPagebreakBefore(attrs)) {
            this.setPagebreakDefinition(new PageBreakDefinition(this.isResetPageNumber()));
        }
        String masterPageName = null;
        int currentRole = this.getCurrentRole();
        if (this.contentProcessingState == 1) {
            this.contentProcessingState = 2;
            if (currentRole == 1) {
                breakDefinition = new PageBreakDefinition(this.isResetPageNumber());
                masterPageName = this.createMasterPage(this.pageHeaderOnReportHeader, this.pageFooterOnReportHeader);
                if (masterPageName == null) {
                    masterPageName = this.currentMasterPage.getStyleName();
                }
            } else if (currentRole == 2) {
                breakDefinition = new PageBreakDefinition(this.isResetPageNumber());
                masterPageName = this.createMasterPage(this.pageHeaderOnReportFooter, this.pageFooterOnReportFooter);
                if (masterPageName == null && this.isSectionPagebreakBefore(attrs)) {
                    masterPageName = this.currentMasterPage.getStyleName();
                }
            } else if (currentRole == 5 || currentRole == 6) {
                breakDefinition = null;
            } else if (this.currentMasterPage == null || this.isPagebreakPending()) {
                masterPageName = this.createMasterPage(true, true);
                this.setPagebreakDefinition(null);
                if (masterPageName == null) {
                    masterPageName = this.currentMasterPage.getStyleName();
                }
                breakDefinition = new PageBreakDefinition(this.isResetPageNumber());
            } else {
                breakDefinition = null;
            }
        } else if (this.isPagebreakPending() && currentRole != 5 && currentRole != 6) {
            breakDefinition = this.getPagebreakDefinition();
            this.setPagebreakDefinition(null);
            masterPageName = this.createMasterPage(true, true);
            if (masterPageName == null || this.isSectionPagebreakBefore(attrs)) {
                masterPageName = this.currentMasterPage.getStyleName();
            }
        } else {
            breakDefinition = null;
        }
        XmlWriter xmlWriter = this.getXmlWriter();
        if (this.detailBandProcessingState == 4 && masterPageName != null) {
            xmlWriter.writeCloseTag();
            this.detailBandProcessingState = 3;
        }
        if (this.tableLayoutConfig == 0 && this.variables != null) {
            Element paragraphProps;
            OfficeStyle style2;
            if (masterPageName != null) {
                style2 = this.deriveStyle("paragraph", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT);
                style2.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "master-page-name", masterPageName);
                if (breakDefinition.isResetPageNumber()) {
                    paragraphProps = this.produceFirstChild(style2, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", PARAGRAPH_PROPERTIES);
                    paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "page-number", "1");
                }
                if (this.isColumnBreakPending()) {
                    paragraphProps = this.produceFirstChild(style2, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", PARAGRAPH_PROPERTIES);
                    paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "break-before", "column");
                    this.setColumnBreakPending(false);
                }
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", "style-name", style2.getStyleName(), false);
                masterPageName = null;
            } else if (this.isColumnBreakPending()) {
                this.setColumnBreakPending(false);
                style2 = this.deriveStyle("paragraph", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT);
                paragraphProps = this.produceFirstChild(style2, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", PARAGRAPH_PROPERTIES);
                paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "page-number", "1");
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", "style-name", style2.getStyleName(), false);
            } else {
                StyleUtilities.copyStyle("paragraph", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT, this.getStylesCollection(), this.getGlobalStylesCollection(), this.getPredefinedStylesCollection());
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", "style-name", VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT, false);
            }
            xmlWriter.writeText(this.variables);
            xmlWriter.writeCloseTag();
            this.variables = null;
        }
        boolean keepWithNext = this.isKeepTableWithNext();
        boolean localKeepTogether = "true".equals(attrs.getAttribute("http://openoffice.org/2005/report", KEEP_TOGETHER));
        boolean tableMergeActive = this.isTableMergeActive();
        boolean bl = this.sectionKeepTogether = tableMergeActive && localKeepTogether;
        if (masterPageName != null || !tableMergeActive && (localKeepTogether || keepWithNext) || this.isColumnBreakPending()) {
            Element paragraphProps;
            styleName = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
            style = this.deriveStyle("table", styleName);
            if (masterPageName != null) {
                style.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "master-page-name", masterPageName);
                if (breakDefinition.isResetPageNumber()) {
                    paragraphProps = this.produceFirstChild(style, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", PARAGRAPH_PROPERTIES);
                    paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "page-number", "1");
                }
            }
            if (this.isColumnBreakPending()) {
                paragraphProps = this.produceFirstChild(style, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", PARAGRAPH_PROPERTIES);
                paragraphProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "break-before", "column");
                this.setColumnBreakPending(false);
            }
            if (!tableMergeActive) {
                if (localKeepTogether) {
                    Element tableProps = this.produceFirstChild(style, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", TABLE_PROPERTIES);
                    tableProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", MAY_BREAK_BETWEEN_ROWS, "false");
                }
            } else if (this.detailBandProcessingState == 0) {
                this.detailBandProcessingState = 1;
            } else if (this.detailBandProcessingState == 2) {
                this.detailBandProcessingState = 3;
            }
            if (keepWithNext) {
                boolean addKeepWithNext = true;
                if (currentRole == 4) {
                    addKeepWithNext = this.isParentKeepTogether();
                }
                Element tableProps = this.produceFirstChild(style, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", TABLE_PROPERTIES);
                tableProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", MAY_BREAK_BETWEEN_ROWS, "false");
                if (addKeepWithNext) {
                    tableProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_WITH_NEXT, ALWAYS);
                }
            }
            attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)style.getStyleName());
        } else {
            if (tableMergeActive) {
                if (this.detailBandProcessingState == 4) {
                    return;
                }
                if (this.detailBandProcessingState == 0) {
                    if (keepWithNext) {
                        styleName = (String)attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
                        style = this.deriveStyle("table", styleName);
                        Element tableProps = this.produceFirstChild(style, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", TABLE_PROPERTIES);
                        tableProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", MAY_BREAK_BETWEEN_ROWS, "false");
                        String hasGroupFooter = (String)attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "has-group-footer");
                        if (hasGroupFooter != null && hasGroupFooter.equals("true")) {
                            tableProps.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", KEEP_WITH_NEXT, ALWAYS);
                        }
                        attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", (Object)style.getStyleName());
                    }
                    this.detailBandProcessingState = 1;
                } else if (this.detailBandProcessingState == 2) {
                    this.detailBandProcessingState = 3;
                }
            }
            this.performStyleProcessing(attrs);
        }
        String namespace = ReportTargetUtil.getNamespaceFromAttribute(attrs);
        String elementType = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
        AttributeList attrList = this.buildAttributeList(attrs);
        xmlWriter.writeTag(namespace, elementType, attrList, false);
    }

    private boolean isParentKeepTogether() {
        PageContext context = this.getCurrentContext();
        if (context != null && (context = context.getParent()) != null) {
            return context.getKeepTogether() == 1;
        }
        return false;
    }

    private boolean isTableMergeActive() {
        return this.getCurrentRole() == 9 && this.tableLayoutConfig == 2;
    }

    private void openSection() throws IOException {
        if (this.isRepeatingSection()) {
            return;
        }
        if (this.getCurrentRole() == 11 || this.getCurrentRole() == 12 || this.getCurrentRole() == 13) {
            return;
        }
        PageContext pageContext = this.getCurrentContext();
        Integer columnCount = pageContext.getColumnCount();
        if (columnCount != null && !pageContext.isSectionOpen()) {
            AttributeList attrs = new AttributeList();
            attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name", this.generateSectionStyle(columnCount));
            attrs.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME, this.sectionNames.generateName("Section"));
            this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "section", attrs, false);
            pageContext.setSectionOpen(true);
        }
    }

    protected void startReportSection(AttributeMap attrs, int role) throws ReportProcessingException {
        this.sectionHeight = new LengthCalculator();
        if (role == 11 || role == 12 || role == 13) {
            this.startBuffering(new OfficeStylesCollection(), true);
        } else if (role == 7) {
            this.startBuffering(this.getGlobalStylesCollection(), true);
            this.pageHeaderOnReportHeader = PageSection.isPrintWithReportHeader(attrs);
            this.pageHeaderOnReportFooter = PageSection.isPrintWithReportFooter(attrs);
        } else if (role == 8) {
            this.startBuffering(this.getGlobalStylesCollection(), true);
            this.pageFooterOnReportHeader = PageSection.isPrintWithReportHeader(attrs);
            this.pageFooterOnReportFooter = PageSection.isPrintWithReportFooter(attrs);
        } else if (role == 5 || role == 6) {
            this.startBuffering(this.getGlobalStylesCollection(), true);
        } else if (role == 10) {
            this.startBuffering(this.getGlobalStylesCollection(), false);
        } else {
            this.contentProcessingState = 1;
            if (role == 3 || role == 4) {
                this.startBuffering(this.getContentStylesCollection(), true);
            }
            if (role != 9) {
                this.detailBandProcessingState = 0;
            }
        }
    }

    protected void startGroup(AttributeMap attrs) {
        Object newColumn;
        Object keepTogether;
        super.startGroup(attrs);
        PageContext pageContext = new PageContext(this.getCurrentContext());
        this.activePageContext.push((Object)pageContext);
        Object resetPageNumber = attrs.getAttribute("http://openoffice.org/2005/report", "reset-page-number");
        if ("true".equals(resetPageNumber)) {
            this.setPagebreakDefinition(new PageBreakDefinition(true));
        }
        if ("whole-group".equals(keepTogether = attrs.getAttribute("http://openoffice.org/2005/report", KEEP_TOGETHER))) {
            pageContext.setKeepTogether(1);
        } else if ("with-first-detail".equals(keepTogether) && pageContext.getKeepTogether() != 1) {
            pageContext.setKeepTogether(2);
        }
        Object columnCountRaw = attrs.getAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "column-count");
        Integer colCount = this.parseInt(columnCountRaw);
        if (colCount != null) {
            pageContext.setColumnCount(colCount);
        }
        if ("true".equals(newColumn = attrs.getAttribute("http://openoffice.org/2005/report", "start-new-column"))) {
            this.setColumnBreakPending(true);
        }
    }

    protected void startGroupInstance(AttributeMap attrs) {
        if (this.getGroupContext().isGroupWithRepeatingSection()) {
            this.setPagebreakDefinition(new PageBreakDefinition(this.isResetPageNumber()));
        }
    }

    protected void endGroup(AttributeMap attrs) throws ReportProcessingException {
        if (this.getGroupContext().isGroupWithRepeatingSection()) {
            this.setPagebreakDefinition(new PageBreakDefinition(this.isResetPageNumber()));
        }
        super.endGroup(attrs);
        this.finishSection();
        this.activePageContext.pop();
    }

    private void finishSection() throws ReportProcessingException {
        PageContext pageContext = this.getCurrentContext();
        if (pageContext.isSectionOpen()) {
            pageContext.setSectionOpen(false);
            try {
                this.getXmlWriter().writeCloseTag();
            }
            catch (IOException e) {
                throw new ReportProcessingException("IOError", e);
            }
        }
    }

    protected void endReportSection(AttributeMap attrs, int role) throws IOException, ReportProcessingException {
        if (role == 11 || role == 12 || role == 13) {
            this.finishBuffering();
            return;
        }
        CSSNumericValue result = this.sectionHeight.getResult();
        if (role == 7) {
            PageContext pageContext = this.getCurrentContext();
            pageContext.setHeader(this.applyColumnsToPageBand(this.finishBuffering(), pageContext.getActiveColumns()).getXmlBuffer(), result);
        } else if (role == 8) {
            PageContext pageContext = this.getCurrentContext();
            pageContext.setFooter(this.applyColumnsToPageBand(this.finishBuffering(), pageContext.getActiveColumns()).getXmlBuffer(), result);
        } else if (role == 5) {
            PageContext pageContext = this.getCurrentContext();
            pageContext.setHeader(this.applyColumnsToPageBand(this.finishBuffering(), pageContext.getActiveColumns()).getXmlBuffer(), result);
        } else if (role == 6) {
            PageContext pageContext = this.getCurrentContext();
            pageContext.setFooter(this.applyColumnsToPageBand(this.finishBuffering(), pageContext.getActiveColumns()).getXmlBuffer(), result);
        } else if (role == 10) {
            this.variables = this.variables == null ? this.finishBuffering().getXmlBuffer() : this.variables + this.finishBuffering().getXmlBuffer();
        } else if (role == 3) {
            String headerText = this.finishBuffering().getXmlBuffer();
            int iterationCount = this.getGroupContext().getParent().getIterationCount();
            boolean repeat = "true".equals(attrs.getAttribute("http://openoffice.org/2005/report", "repeat-section"));
            if (!repeat || iterationCount > 0) {
                this.getXmlWriter().writeText(headerText);
            }
        } else if (role == 4) {
            String footerText = this.finishBuffering().getXmlBuffer();
            this.getXmlWriter().writeText(footerText);
        }
    }

    public void endReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        super.endReport(report);
        this.variablesDeclarations = null;
        try {
            AttributeList rootAttributes = new AttributeList();
            rootAttributes.addNamespaceDeclaration("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
            rootAttributes.addNamespaceDeclaration("config", "urn:oasis:names:tc:opendocument:xmlns:config:1.0");
            rootAttributes.addNamespaceDeclaration("ooo", "http://openoffice.org/2004/office");
            rootAttributes.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version", "1.2");
            OutputStream outputStream = this.getOutputRepository().createOutputStream("settings.xml", "text/xml");
            XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)this.createTagDescription());
            xmlWriter.setAlwaysAddNamespace(true);
            xmlWriter.writeXmlDeclaration("UTF-8");
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "document-settings", rootAttributes, false);
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "settings", false);
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:config:1.0", "config-item-set", NAME, "ooo:configuration-settings", false);
            AttributeList configAttributes = new AttributeList();
            configAttributes.setAttribute("urn:oasis:names:tc:opendocument:xmlns:config:1.0", NAME, "TableRowKeep");
            configAttributes.setAttribute("urn:oasis:names:tc:opendocument:xmlns:config:1.0", "type", "boolean");
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:config:1.0", "config-item", configAttributes, false);
            xmlWriter.writeText("true");
            xmlWriter.writeCloseTag();
            xmlWriter.writeCloseTag();
            xmlWriter.writeCloseTag();
            xmlWriter.writeCloseTag();
            xmlWriter.close();
            this.copyMeta();
        }
        catch (IOException ioe) {
            throw new ReportProcessingException("Failed to write settings document", ioe);
        }
    }

    protected void endOther(AttributeMap attrs) throws IOException, DataSourceException, ReportProcessingException {
        String namespace = ReportTargetUtil.getNamespaceFromAttribute(attrs);
        String elementType = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
        boolean isInternalNS = ObjectUtilities.equal((Object)"http://jfreereport.sourceforge.net/namespaces/engine", (Object)namespace);
        boolean isTableNs = ObjectUtilities.equal((Object)"urn:oasis:names:tc:opendocument:xmlns:table:1.0", (Object)namespace);
        if (this.isTableMergeActive() && this.detailBandProcessingState == 4 && isTableNs && ObjectUtilities.equal((Object)"table-columns", (Object)elementType)) {
            this.finishBuffering();
            return;
        }
        if (isInternalNS && (ObjectUtilities.equal((Object)"image", (Object)elementType) || ObjectUtilities.equal((Object)"object-ole", (Object)elementType))) {
            return;
        }
        XmlWriter xmlWriter = this.getXmlWriter();
        if (this.tableLayoutConfig != 0 && isTableNs && ObjectUtilities.equal((Object)"table-cell", (Object)elementType) && !this.isRepeatingSection() && this.variables != null) {
            String tag = this.sectionKeepTogether && this.expectedTableRowCount > 0 ? VARIABLES_HIDDEN_STYLE_WITH_KEEPWNEXT : VARIABLES_HIDDEN_STYLE_WITHOUT_KEEPWNEXT;
            StyleUtilities.copyStyle("paragraph", tag, this.getStylesCollection(), this.getGlobalStylesCollection(), this.getPredefinedStylesCollection());
            xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p", "style-name", tag, false);
            xmlWriter.writeText(this.variables);
            xmlWriter.writeCloseTag();
            this.variables = null;
        }
        if (isTableNs && (ObjectUtilities.equal((Object)"table-cell", (Object)elementType) || ObjectUtilities.equal((Object)"covered-table-cell", (Object)elementType))) {
            this.firstCellSeen = true;
        }
        if (isTableNs && ObjectUtilities.equal((Object)"table", (Object)elementType)) {
            if (this.getCurrentRole() == 9) {
                if (!this.isTableMergeActive()) {
                    xmlWriter.writeCloseTag();
                } else if (this.detailBandProcessingState == 1) {
                    int keepTogetherState = this.getCurrentContext().getKeepTogether();
                    if (keepTogetherState == 2) {
                        xmlWriter.writeCloseTag();
                        this.detailBandProcessingState = 2;
                    } else {
                        this.detailBandProcessingState = 4;
                    }
                } else if (this.detailBandProcessingState == 3) {
                    this.detailBandProcessingState = 4;
                }
            } else {
                xmlWriter.writeCloseTag();
            }
            if (this.isSectionPagebreakAfter(attrs)) {
                this.setPagebreakDefinition(new PageBreakDefinition(false));
            }
        } else {
            xmlWriter.writeCloseTag();
        }
    }

    protected void endGroupBody(AttributeMap attrs) throws IOException {
        if (this.tableLayoutConfig == 2 && this.detailBandProcessingState == 4) {
            XmlWriter xmlWriter = this.getXmlWriter();
            xmlWriter.writeCloseTag();
            this.detailBandProcessingState = 0;
        }
    }

    protected void endContent(AttributeMap attrs) throws IOException, DataSourceException, ReportProcessingException {
        this.finishSection();
        OfficeDocumentReportTarget.BufferState bodyText = this.finishBuffering();
        XmlWriter writer = this.getXmlWriter();
        Map<String, String> definedMappings = this.variablesDeclarations.getDefinedMappings();
        if (!definedMappings.isEmpty()) {
            writer.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "variable-decls", false);
            for (Map.Entry<String, String> entry : definedMappings.entrySet()) {
                AttributeList entryList = new AttributeList();
                entryList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", NAME, entry.getKey());
                entryList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", entry.getValue());
                writer.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "variable-decl", entryList, true);
            }
            writer.writeCloseTag();
        }
        writer.writeStream(bodyText.getXmlAsReader());
        writer.setLineEmpty(true);
        writer.writeCloseTag();
    }

    public String getExportDescriptor() {
        return "raw/application/vnd.oasis.opendocument.text";
    }
}

