/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.model.ObjectOleElement;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MasterDetailReadHandler
extends ElementReadHandler {
    private final ObjectOleElement element;
    private final boolean parseMasterDetail;

    public MasterDetailReadHandler(ObjectOleElement element) {
        this.element = element;
        this.parseMasterDetail = false;
    }

    private MasterDetailReadHandler(ObjectOleElement element, boolean parseMasterDetail) {
        this.element = element;
        this.parseMasterDetail = parseMasterDetail;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String master;
        super.startParsing(attrs);
        if (this.parseMasterDetail && (master = attrs.getValue("http://openoffice.org/2005/report", "master")) != null && master.length() > 0) {
            String detail = attrs.getValue("http://openoffice.org/2005/report", "detail");
            this.element.addMasterDetailFields(master, detail);
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("http://openoffice.org/2005/report".equals(uri) && "master-detail-field".equals(tagName)) {
            return new MasterDetailReadHandler(this.element, true);
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }
}

