/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.model.ReportElement;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.ConditionalPrintExpressionReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.FormatConditionReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportElementReadHandler
extends ElementReadHandler {
    private final ReportElement element;

    public ReportElementReadHandler(ReportElement element) {
        if (element == null) {
            throw new NullPointerException();
        }
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        String printWhenGroupChange = attrs.getValue("http://openoffice.org/2005/report", "print-when-group-change");
        this.element.setPrintWhenGroupChange("true".equals(printWhenGroupChange));
        String printRepeatingValues = attrs.getValue("http://openoffice.org/2005/report", "print-repeated-values");
        this.element.setPrintRepeatedValues(printRepeatingValues == null || "true".equals(printRepeatingValues));
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!"http://openoffice.org/2005/report".equals(uri)) {
            return null;
        }
        if ("conditional-print-expression".equals(tagName)) {
            return new ConditionalPrintExpressionReadHandler(this.element);
        }
        if ("format-condition".equals(tagName)) {
            return new FormatConditionReadHandler(this.element);
        }
        if ("report-component".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        return null;
    }
}

