/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.LibRepositoryBoot;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zip.ZipContentLocation;
import org.pentaho.reporting.libraries.repository.zip.ZipEntryOutputStream;
import org.pentaho.reporting.libraries.repository.zip.ZipRepository;

public class ZipContentItem
implements ContentItem {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private String comment;
    private String name;
    private long size;
    private long time;
    private ZipRepository repository;
    private byte[] rawData;
    private ZipContentLocation parent;
    private String entryName;
    private Integer method;
    private int compression;
    private long crc32;

    public ZipContentItem(ZipRepository repository, ZipContentLocation parent, ZipEntry zipEntry, byte[] bytes) {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.repository = repository;
        this.comment = zipEntry.getComment();
        this.name = RepositoryUtilities.buildName(this, "/");
        this.entryName = IOUtils.getInstance().getFileName(this.name);
        this.size = zipEntry.getSize();
        this.crc32 = zipEntry.getCrc();
        this.time = zipEntry.getTime();
        this.rawData = bytes;
        int method = zipEntry.getMethod();
        this.method = method == 0 || method == 8 ? new Integer(method) : new Integer(8);
        this.compression = -1;
    }

    public ZipContentItem(ZipRepository repository, ZipContentLocation parent, String name) {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
        this.parent = parent;
        this.entryName = name;
        this.name = RepositoryUtilities.buildName(this, "/");
        this.time = System.currentTimeMillis();
        this.comment = null;
        this.size = 0L;
        this.rawData = EMPTY_BYTES;
        this.method = LibRepositoryBoot.ZIP_METHOD_DEFLATED;
        this.compression = -1;
    }

    public void setRawData(byte[] rawData, long size, long crc32) {
        if (rawData == null) {
            throw new NullPointerException();
        }
        this.rawData = rawData;
        this.size = size;
        this.crc32 = crc32;
        this.time = System.currentTimeMillis();
    }

    public String getMimeType() throws ContentIOException {
        return this.repository.getMimeRegistry().getMimeType(this);
    }

    public OutputStream getOutputStream() throws ContentIOException, IOException {
        return new ZipEntryOutputStream(this);
    }

    public InputStream getInputStream() throws ContentIOException, IOException {
        return new InflaterInputStream(new ByteArrayInputStream(this.rawData));
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWriteable() {
        return true;
    }

    public String getName() {
        return this.entryName;
    }

    public Object getContentId() {
        return this.name;
    }

    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain)) {
            if ("size".equals(key)) {
                return new Long(this.size);
            }
            if ("version".equals(key)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(domain)) {
            if ("comment".equals(key)) {
                return this.comment;
            }
            if ("crc32".equals(key)) {
                return new Long(this.crc32);
            }
            if ("method".equals(key)) {
                return this.method;
            }
            if ("compression".equals(key)) {
                return new Integer(this.compression);
            }
        }
        return null;
    }

    public boolean setAttribute(String domain, String key, Object value) {
        if ("org.jfree.repository".equals(domain)) {
            if ("version".equals(key)) {
                if (value instanceof Date) {
                    Date n = (Date)value;
                    this.time = n.getTime();
                    return true;
                }
                if (value instanceof Number) {
                    Number n = (Number)value;
                    this.time = n.longValue();
                    return true;
                }
            }
        } else if ("org.jfree.repository.zip".equals(domain)) {
            Integer valueInt;
            int compression;
            if ("comment".equals(key)) {
                if (value != null) {
                    this.comment = String.valueOf(value);
                    return true;
                }
                this.comment = null;
                return true;
            }
            if ("method".equals(key)) {
                if (LibRepositoryBoot.ZIP_METHOD_STORED.equals(value)) {
                    this.method = LibRepositoryBoot.ZIP_METHOD_STORED;
                    return true;
                }
                if (LibRepositoryBoot.ZIP_METHOD_DEFLATED.equals(value)) {
                    this.method = LibRepositoryBoot.ZIP_METHOD_DEFLATED;
                    return true;
                }
            }
            if ("compression".equals(key) && value instanceof Integer && (compression = (valueInt = (Integer)value).intValue()) >= 0 && compression <= 9) {
                this.compression = compression;
                return true;
            }
        }
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean delete() {
        return this.parent.removeEntity(this);
    }
}

